/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.intent;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.intent.Callback;
import org.netbeans.api.intent.Intent;
import org.netbeans.modules.intent.CallbackResult;
import org.netbeans.modules.intent.IntentHandler;
import org.netbeans.modules.intent.SettableResult;

public final class IntentAction {
    private final Intent intent;
    private final IntentHandler delegate;

    IntentAction(Intent intent, IntentHandler intentHandler) {
        this.intent = intent;
        this.delegate = intentHandler;
    }

    int getPosition() {
        return this.delegate.getPosition();
    }

    public void execute(final @NullAllowed Callback callback) {
        IntentHandler.RP.post(new Runnable(){

            @Override
            public void run() {
                CallbackResult callbackResult = callback == null ? null : new CallbackResult(callback);
                IntentAction.this.delegate.handle(IntentAction.this.intent, callbackResult);
            }
        });
    }

    @NonNull
    public Future<Object> execute() {
        return IntentHandler.RP.submit((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                SettableResult settableResult = new SettableResult();
                IntentAction.this.delegate.handle(IntentAction.this.intent, settableResult);
                if (settableResult.getException() != null) {
                    throw settableResult.getException();
                }
                return settableResult.getResult();
            }
        });
    }

    @NonNull
    public String getDisplayName() {
        return this.delegate.getDisplayName();
    }

    @NonNull
    public String getIcon() {
        return this.delegate.getIcon();
    }
}

