/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.core.snapshot;

import java.awt.Image;
import org.graalvm.visualvm.core.datasource.DataSource;
import org.graalvm.visualvm.core.snapshot.Snapshot;
import org.graalvm.visualvm.core.ui.DataSourceView;

public abstract class SnapshotView
extends DataSourceView {
    public SnapshotView(Snapshot snapshot, String name, Image icon, int preferredPosition) {
        super(snapshot, name, icon, preferredPosition, SnapshotView.isClosableView(snapshot));
    }

    public SnapshotView(Snapshot snapshot, String name, Image icon, int preferredPosition, boolean isClosable) {
        super(snapshot, name, icon, preferredPosition, isClosable);
    }

    private static boolean isClosableView(Snapshot snapshot) {
        String closable = snapshot.getStorage().getCustomProperty("prop_view_closable");
        if (Boolean.TRUE.toString().equals(closable)) {
            return true;
        }
        if (Boolean.FALSE.toString().equals(closable)) {
            return false;
        }
        if (!snapshot.isVisible()) {
            return false;
        }
        DataSource owner = snapshot.getOwner();
        if (owner == null) {
            return false;
        }
        while (owner != null && owner != DataSource.ROOT) {
            if (!owner.isVisible()) {
                return false;
            }
            owner = owner.getOwner();
        }
        return owner == DataSource.ROOT;
    }
}

