/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.oql.repository.api;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.graalvm.visualvm.lib.profiler.oql.repository.api.OQLQueryCategory;
import org.graalvm.visualvm.lib.profiler.oql.repository.api.OQLQueryDefinition;
import org.netbeans.api.annotations.common.NonNull;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class OQLQueryRepository {
    private static final String MATCH_ALL = ".*";
    private static final Logger LOGGER = Logger.getLogger(OQLQueryRepository.class.getName());

    private OQLQueryRepository() {
    }

    public static OQLQueryRepository getInstance() {
        return Singleton.INSTANCE;
    }

    @NonNull
    private FileObject getRepositoryRoot() {
        FileObject root = FileUtil.getConfigFile((String)"NBProfiler/Config/OQL");
        if (root == null) {
            throw new IllegalStateException("can not find OQL queries repository");
        }
        return root;
    }

    @NonNull
    private String getDisplayName(@NonNull FileObject fo) {
        String dName = (String)fo.getAttribute("displayName");
        return dName != null ? dName : fo.getName();
    }

    private String getDescription(FileObject fo) {
        return (String)fo.getAttribute("desc");
    }

    @NonNull
    private List<? extends OQLQueryDefinition> getQueries(FileObject categoryFO, String pattern) {
        ArrayList<OQLQueryDefinition> defs = new ArrayList<OQLQueryDefinition>();
        try {
            Pattern p = Pattern.compile(pattern);
            List<FileObject> queries = OQLQueryRepository.sortedFOs(categoryFO.getData(false));
            for (FileObject query : queries) {
                String displayName = this.getDisplayName(query);
                if (!p.matcher(displayName).matches()) continue;
                defs.add(new OQLQueryDefinition(displayName, this.getDescription(query), query.asText()));
            }
        }
        catch (IOException iOException) {
            LOGGER.log(Level.SEVERE, "error while retrieving query definitions", iOException);
        }
        return defs;
    }

    @NonNull
    public List<? extends OQLQueryCategory> listCategories() {
        return this.listCategories(MATCH_ALL);
    }

    @NonNull
    public List<? extends OQLQueryCategory> listCategories(@NonNull String pattern) {
        FileObject root = this.getRepositoryRoot();
        Pattern p = Pattern.compile(pattern);
        ArrayList<OQLQueryCategory> catList = new ArrayList<OQLQueryCategory>();
        List<FileObject> categories = OQLQueryRepository.sortedFOs(root.getFolders(false));
        for (FileObject categoryFO : categories) {
            String displayName = this.getDisplayName(categoryFO);
            if (!p.matcher(displayName).matches()) continue;
            catList.add(new OQLQueryCategory(this, categoryFO.getName(), displayName, this.getDescription(categoryFO)));
        }
        return catList;
    }

    @NonNull
    public List<? extends OQLQueryDefinition> listQueries() {
        return this.listQueries(MATCH_ALL);
    }

    @NonNull
    public List<? extends OQLQueryDefinition> listQueries(@NonNull String pattern) {
        FileObject root = this.getRepositoryRoot();
        ArrayList<? extends OQLQueryDefinition> qdefs = new ArrayList<OQLQueryDefinition>();
        for (OQLQueryCategory oQLQueryCategory : this.listCategories()) {
            FileObject catFO = root.getFileObject(oQLQueryCategory.getID());
            qdefs.addAll(this.getQueries(catFO, pattern));
        }
        return qdefs;
    }

    @NonNull
    public List<? extends OQLQueryDefinition> listQueries(@NonNull OQLQueryCategory category) {
        return this.listQueries(category, MATCH_ALL);
    }

    @NonNull
    public List<? extends OQLQueryDefinition> listQueries(@NonNull OQLQueryCategory category, @NonNull String pattern) {
        FileObject root = this.getRepositoryRoot();
        FileObject catFO = root.getFileObject(category.getID());
        return this.getQueries(catFO, pattern);
    }

    private static List<FileObject> sortedFOs(Enumeration<? extends FileObject> fos) {
        ArrayList<FileObject> list = new ArrayList<FileObject>();
        while (fos.hasMoreElements()) {
            list.add(fos.nextElement());
        }
        return FileUtil.getOrder(list, (boolean)false);
    }

    private static final class Singleton {
        private static final OQLQueryRepository INSTANCE = new OQLQueryRepository();

        private Singleton() {
        }
    }
}

