/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultCaret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.View;
import org.graalvm.visualvm.lib.profiler.api.ActionsSupport;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.components.CloseButton;
import org.graalvm.visualvm.lib.ui.components.HTMLTextArea;
import org.graalvm.visualvm.lib.ui.swing.EditableHistoryCombo;
import org.graalvm.visualvm.lib.ui.swing.InvisibleToolbar;

public final class HTMLTextAreaSearchUtils {
    private static final ResourceBundle messages = ResourceBundle.getBundle("org.graalvm.visualvm.lib.ui.components.Bundle");
    private static final String FIND_ACTION_NAME = messages.getString("HTMLTextAreaSearchUtils_FindActionName");
    private static final String MATCHES_PATTERN = messages.getString("HTMLTextAreaSearchUtils_MatchesPattern");
    private static final String NO_MATCHES = messages.getString("HTMLTextAreaSearchUtils_NoMatches");
    private static final String MATCHES_TOOLTIP = messages.getString("HTMLTextAreaSearchUtils_MatchesTooltip");
    private static final String SIDEBAR_CAPTION = messages.getString("HTMLTextAreaSearchUtils_SidebarCaption");
    private static final String BTN_PREVIOUS = messages.getString("HTMLTextAreaSearchUtils_BtnPrevious");
    private static final String BTN_PREVIOUS_TOOLTIP = messages.getString("HTMLTextAreaSearchUtils_BtnPreviousTooltip");
    private static final String BTN_NEXT = messages.getString("HTMLTextAreaSearchUtils_BtnNext");
    private static final String BTN_NEXT_TOOLTIP = messages.getString("HTMLTextAreaSearchUtils_BtnNextTooltip");
    private static final String BTN_MATCH_CASE_TOOLTIP = messages.getString("HTMLTextAreaSearchUtils_BtnMatchCaseTooltip");
    private static final String BTN_CLOSE_TOOLTIP = messages.getString("HTMLTextAreaSearchUtils_BtnCloseTooltip");
    public static final String FIND_ACTION_KEY = "find-action-key";
    public static final String FIND_NEXT_ACTION_KEY = "find-next-action-key";
    public static final String FIND_PREV_ACTION_KEY = "find-prev-action-key";
    public static final String FIND_SEL_ACTION_KEY = "find-sel-action-key";
    private static final String FIND_CLOSE_ACTION_KEY = "find-close-action-key";
    private static final String PROP_LAST_FIND_TEXT = "last-find-text";
    private static final String PROP_LAST_FIND_MATCH_CASE = "last-find-match-case";
    private static final String PROP_SEARCH_PANEL = "search-panel";
    private static final String PROP_SEARCH_RESULT = "search-result";

    public static boolean findString(HTMLTextArea area, String text) {
        return HTMLTextAreaSearchUtils.findString(area, text, true, true);
    }

    public static boolean findString(HTMLTextArea area, String text, boolean matchCase, boolean next) {
        int closest;
        DocumentSearchResult result = HTMLTextAreaSearchUtils.findStringImpl(area, text, matchCase);
        if (result == null) {
            return false;
        }
        int offset = next ? area.getSelectionEnd() : area.getSelectionStart();
        int n = closest = next ? result.getNextIndex(offset) : result.getPreviousIndex(offset);
        if (closest < 0) {
            area.select(area.getSelectionStart(), area.getSelectionStart());
            return false;
        }
        offset = result.getOffset(closest);
        area.select(offset, offset + text.length());
        return true;
    }

    public static void textChanged(HTMLTextArea area) {
        DocumentSearchResult result = DocumentSearchResult.reset(area);
        SearchPanel search = (SearchPanel)area.getClientProperty(PROP_SEARCH_PANEL);
        if (search.isVisible()) {
            search.clearResultsFeedback(result);
        }
    }

    private static DocumentSearchResult findStringImpl(HTMLTextArea area, String text, boolean matchCase) {
        area.putClientProperty(PROP_LAST_FIND_TEXT, text);
        area.putClientProperty(PROP_LAST_FIND_MATCH_CASE, Boolean.toString(matchCase));
        return DocumentSearchResult.get(text, matchCase, area);
    }

    public static JComponent createSearchPanel(final HTMLTextArea area) {
        SearchPanel sp = new SearchPanel(area){

            @Override
            public void setVisible(boolean visible) {
                super.setVisible(visible);
                if (!visible) {
                    area.requestFocusInWindow();
                }
            }
        };
        area.putClientProperty(PROP_SEARCH_PANEL, sp);
        HTMLTextAreaSearchUtils.enableSearchActions(area);
        Caret caret = area.getCaret();
        if (caret instanceof DefaultCaret) {
            area.setCaret(new DefaultCaret(){

                @Override
                public void setSelectionVisible(boolean visible) {
                    super.setSelectionVisible(true);
                }
            });
        }
        return sp;
    }

    public static void enableSearchActions(final HTMLTextArea area) {
        ActionMap actionMapArea = area.getActionMap();
        InputMap inputMapArea = area.getInputMap();
        AbstractAction findAction = new AbstractAction(FIND_ACTION_NAME){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String selected = area.getSelectedText();
                        if (selected != null) {
                            area.putClientProperty(HTMLTextAreaSearchUtils.PROP_LAST_FIND_TEXT, selected);
                        }
                        ((SearchPanel)area.getClientProperty(HTMLTextAreaSearchUtils.PROP_SEARCH_PANEL)).setVisible(true);
                    }
                });
            }
        };
        ActionsSupport.registerAction((String)FIND_ACTION_KEY, (Action)findAction, (ActionMap)actionMapArea, (InputMap)inputMapArea);
        AbstractAction nextAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String search = (String)area.getClientProperty(HTMLTextAreaSearchUtils.PROP_LAST_FIND_TEXT);
                        if (search != null) {
                            boolean matchCase = Boolean.parseBoolean((String)area.getClientProperty(HTMLTextAreaSearchUtils.PROP_LAST_FIND_MATCH_CASE));
                            HTMLTextAreaSearchUtils.findString(area, search, matchCase, true);
                        } else {
                            ((SearchPanel)area.getClientProperty(HTMLTextAreaSearchUtils.PROP_SEARCH_PANEL)).setVisible(true);
                        }
                    }
                });
            }
        };
        ActionsSupport.registerAction((String)FIND_NEXT_ACTION_KEY, (Action)nextAction, (ActionMap)actionMapArea, (InputMap)inputMapArea);
        AbstractAction prevAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String search = (String)area.getClientProperty(HTMLTextAreaSearchUtils.PROP_LAST_FIND_TEXT);
                        if (search != null) {
                            boolean matchCase = Boolean.parseBoolean((String)area.getClientProperty(HTMLTextAreaSearchUtils.PROP_LAST_FIND_MATCH_CASE));
                            HTMLTextAreaSearchUtils.findString(area, search, matchCase, false);
                        } else {
                            ((SearchPanel)area.getClientProperty(HTMLTextAreaSearchUtils.PROP_SEARCH_PANEL)).setVisible(true);
                        }
                    }
                });
            }
        };
        ActionsSupport.registerAction((String)FIND_PREV_ACTION_KEY, (Action)prevAction, (ActionMap)actionMapArea, (InputMap)inputMapArea);
        AbstractAction selAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String selected = area.getSelectedText();
                        area.putClientProperty(HTMLTextAreaSearchUtils.PROP_LAST_FIND_TEXT, selected);
                        if (selected != null) {
                            boolean matchCase = Boolean.parseBoolean((String)area.getClientProperty(HTMLTextAreaSearchUtils.PROP_LAST_FIND_MATCH_CASE));
                            HTMLTextAreaSearchUtils.findString(area, selected, matchCase, true);
                        } else {
                            ((SearchPanel)area.getClientProperty(HTMLTextAreaSearchUtils.PROP_SEARCH_PANEL)).setVisible(true);
                        }
                    }
                });
            }
        };
        ActionsSupport.registerAction((String)FIND_SEL_ACTION_KEY, (Action)selAction, (ActionMap)actionMapArea, (InputMap)inputMapArea);
        AbstractAction closeAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((SearchPanel)area.getClientProperty(HTMLTextAreaSearchUtils.PROP_SEARCH_PANEL)).setVisible(false);
                    }
                });
            }
        };
        actionMapArea.put(FIND_CLOSE_ACTION_KEY, closeAction);
        inputMapArea.put(KeyStroke.getKeyStroke(27, 0), FIND_CLOSE_ACTION_KEY);
    }

    private static class SearchPanel
    extends JPanel {
        private final HTMLTextArea area;
        private final EditableHistoryCombo combo;
        private final JTextComponent textC;
        private final JToggleButton matchCase;
        private final JToggleButton highlightResults;
        private final JLabel feedback;

        SearchPanel(final HTMLTextArea area) {
            super(new BorderLayout());
            this.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlShadow")));
            this.area = area;
            this.feedback = new JLabel();
            this.feedback.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
            InvisibleToolbar toolbar = new InvisibleToolbar();
            if (UIUtils.isWindowsModernLookAndFeel()) {
                toolbar.setBorder(BorderFactory.createEmptyBorder(2, 2, 1, 2));
            } else if (!UIUtils.isNimbusLookAndFeel() && !UIUtils.isAquaLookAndFeel()) {
                toolbar.setBorder(BorderFactory.createEmptyBorder(1, 2, 1, 2));
            }
            toolbar.add(Box.createHorizontalStrut(6));
            toolbar.add(new JLabel(SIDEBAR_CAPTION));
            toolbar.add(Box.createHorizontalStrut(3));
            this.add((Component)toolbar, "Center");
            this.combo = new EditableHistoryCombo();
            this.textC = this.combo.getTextComponent();
            JPanel comboContainer = new JPanel(new BorderLayout());
            comboContainer.add((Component)this.combo, "Center");
            comboContainer.setMinimumSize(this.combo.getMinimumSize());
            comboContainer.setPreferredSize(this.combo.getPreferredSize());
            comboContainer.setMaximumSize(this.combo.getMaximumSize());
            toolbar.add(comboContainer);
            toolbar.add(Box.createHorizontalStrut(5));
            KeyStroke escKey = KeyStroke.getKeyStroke(27, 0);
            KeyStroke prevKey = KeyStroke.getKeyStroke(10, 1);
            KeyStroke nextKey = KeyStroke.getKeyStroke(10, 0);
            this.matchCase = new JToggleButton(Icons.getIcon((String)"GeneralIcons.MatchCase")){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            this.clearResultsFeedback(DocumentSearchResult.current(area));
                        }
                    });
                }
            };
            this.matchCase.setToolTipText(BTN_MATCH_CASE_TOOLTIP);
            this.highlightResults = new JToggleButton(Icons.getIcon((String)"GeneralIcons.HighlightResults"), true){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            DocumentSearchResult result = DocumentSearchResult.current(area);
                            if (result != null) {
                                Highlighter hl = area.getHighlighter();
                                result.clearHighlightedResults(hl);
                                if (this.isSelected() && !feedback.getText().isEmpty() && result.getResultsCount() > 0) {
                                    result.highlightResults(hl);
                                }
                            }
                        }
                    });
                }
            };
            this.highlightResults.setToolTipText(MATCHES_TOOLTIP);
            final JButton prev = new JButton(BTN_PREVIOUS, Icons.getIcon((String)"GeneralIcons.FindPrevious")){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String search = this.getSearchString();
                            if (search.isEmpty()) {
                                return;
                            }
                            DocumentSearchResult result = HTMLTextAreaSearchUtils.findStringImpl(area, search, matchCase.isSelected());
                            int results = result.getResultsCount();
                            if (results > 0) {
                                int index = result.getPreviousIndex(area.getSelectionStart());
                                this.setResultsFeedback(index, results, result);
                                combo.addItem(search);
                                int offset = result.getOffset(index);
                                area.select(offset, offset + search.length());
                            } else {
                                feedback.setText(NO_MATCHES);
                                area.select(area.getSelectionStart(), area.getSelectionStart());
                            }
                        }
                    });
                }
            };
            prev.putClientProperty("JButton.buttonType", "segmented");
            prev.putClientProperty("JButton.segmentPosition", "first");
            String prevAccelerator = ActionsSupport.keyAcceleratorString((KeyStroke)prevKey);
            prev.setToolTipText(MessageFormat.format(BTN_PREVIOUS_TOOLTIP, prevAccelerator));
            prev.setEnabled(false);
            toolbar.add(prev);
            if (!UIUtils.isAquaLookAndFeel()) {
                toolbar.add(Box.createHorizontalStrut(2));
            }
            final JButton next = new JButton(BTN_NEXT, Icons.getIcon((String)"GeneralIcons.FindNext")){

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    super.fireActionPerformed(e);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            String search = this.getSearchString();
                            if (search.isEmpty()) {
                                return;
                            }
                            DocumentSearchResult result = HTMLTextAreaSearchUtils.findStringImpl(area, search, matchCase.isSelected());
                            int results = result.getResultsCount();
                            if (results > 0) {
                                int index = result.getNextIndex(area.getSelectionEnd());
                                this.setResultsFeedback(index, results, result);
                                combo.addItem(search);
                                int offset = result.getOffset(index);
                                area.select(offset, offset + search.length());
                            } else {
                                feedback.setText(NO_MATCHES);
                                area.select(area.getSelectionStart(), area.getSelectionStart());
                            }
                        }
                    });
                }
            };
            next.putClientProperty("JButton.buttonType", "segmented");
            next.putClientProperty("JButton.segmentPosition", "last");
            String nextAccelerator = ActionsSupport.keyAcceleratorString((KeyStroke)KeyStroke.getKeyStroke(10, 0));
            next.setToolTipText(MessageFormat.format(BTN_NEXT_TOOLTIP, nextAccelerator));
            next.setEnabled(false);
            toolbar.add(next);
            toolbar.add(Box.createHorizontalStrut(2));
            ((JToolBar)toolbar).addSeparator();
            toolbar.add(Box.createHorizontalStrut(1));
            toolbar.add(this.matchCase);
            toolbar.add(this.highlightResults);
            toolbar.add(Box.createHorizontalStrut(2));
            this.combo.setOnTextChangeHandler(new Runnable(){

                @Override
                public void run() {
                    boolean enable = !combo.getText().trim().isEmpty();
                    prev.setEnabled(enable);
                    next.setEnabled(enable);
                }
            });
            final Runnable hider = new Runnable(){

                @Override
                public void run() {
                    this.setVisible(false);
                }
            };
            JButton closeButton = CloseButton.create(hider);
            String escAccelerator = ActionsSupport.keyAcceleratorString((KeyStroke)escKey);
            closeButton.setToolTipText(MessageFormat.format(BTN_CLOSE_TOOLTIP, escAccelerator));
            String HIDE = "hide-action";
            InputMap inputMap = this.getInputMap(1);
            AbstractAction hiderAction = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    hider.run();
                }
            };
            this.getActionMap().put(HIDE, hiderAction);
            inputMap.put(escKey, HIDE);
            if (this.textC != null) {
                KeyStroke prevKey2;
                String prevAccelerator2;
                KeyStroke nextKey2;
                String nextAccelerator2;
                ActionMap actionMap = this.getActionMap();
                String NEXT = "search-next-action";
                AbstractAction nextAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (combo.isPopupVisible()) {
                            combo.hidePopup();
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (next.isEnabled()) {
                                    next.doClick();
                                }
                            }
                        });
                    }
                };
                actionMap.put(NEXT, nextAction);
                inputMap.put(nextKey, NEXT);
                if (this.textC != null) {
                    this.textC.getActionMap().put(NEXT, nextAction);
                    this.textC.getInputMap().put(nextKey, NEXT);
                }
                if ((nextAccelerator2 = ActionsSupport.keyAcceleratorString((KeyStroke)(nextKey2 = ActionsSupport.registerAction((String)HTMLTextAreaSearchUtils.FIND_NEXT_ACTION_KEY, (Action)nextAction, (ActionMap)actionMap, (InputMap)inputMap)))) != null) {
                    next.setToolTipText(MessageFormat.format(BTN_NEXT_TOOLTIP, nextAccelerator + ", " + nextAccelerator2));
                }
                String PREV = "search-prev-action";
                AbstractAction prevAction = new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        if (combo.isPopupVisible()) {
                            combo.hidePopup();
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                if (next.isEnabled()) {
                                    prev.doClick();
                                }
                            }
                        });
                    }
                };
                actionMap.put(PREV, prevAction);
                inputMap.put(prevKey, PREV);
                if (this.textC != null) {
                    this.textC.getActionMap().put(PREV, prevAction);
                    this.textC.getInputMap().put(prevKey, PREV);
                }
                if ((prevAccelerator2 = ActionsSupport.keyAcceleratorString((KeyStroke)(prevKey2 = ActionsSupport.registerAction((String)HTMLTextAreaSearchUtils.FIND_PREV_ACTION_KEY, (Action)prevAction, (ActionMap)actionMap, (InputMap)inputMap)))) != null) {
                    prev.setToolTipText(MessageFormat.format(BTN_PREVIOUS_TOOLTIP, prevAccelerator + ", " + prevAccelerator2));
                }
            }
            JPanel rightPanel = new JPanel(new BorderLayout());
            rightPanel.add((Component)this.feedback, "West");
            rightPanel.add((Component)closeButton, "East");
            this.add((Component)rightPanel, "East");
            this.setVisible(false);
        }

        private String getSearchString() {
            String search = this.combo.getText();
            return search == null ? "" : search.trim();
        }

        private void setResultsFeedback(int index, int count, DocumentSearchResult result) {
            NumberFormat format = NumberFormat.getInstance();
            this.feedback.setText(MessageFormat.format(MATCHES_PATTERN, format.format(index + 1), format.format(count)));
            if (result != null) {
                if (this.highlightResults.isSelected()) {
                    result.highlightResults(this.area.getHighlighter());
                } else {
                    result.clearHighlightedResults(this.area.getHighlighter());
                }
            }
        }

        void clearResultsFeedback(DocumentSearchResult result) {
            this.feedback.setText("");
            if (result != null) {
                result.clearHighlightedResults(this.area.getHighlighter());
            }
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.clearResultsFeedback(DocumentSearchResult.current(this.area));
            if (visible) {
                String search = (String)this.area.getClientProperty(HTMLTextAreaSearchUtils.PROP_LAST_FIND_TEXT);
                this.textC.setText(search == null ? "" : search);
                boolean match = Boolean.parseBoolean((String)this.area.getClientProperty(HTMLTextAreaSearchUtils.PROP_LAST_FIND_MATCH_CASE));
                this.matchCase.setSelected(match);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ((JComponent)this.getParent()).scrollRectToVisible(this.getBounds());
                    }
                });
                this.requestFocusInWindow();
            } else {
                if (this.getSearchString().isEmpty()) {
                    this.area.putClientProperty(HTMLTextAreaSearchUtils.PROP_LAST_FIND_TEXT, null);
                }
                this.area.putClientProperty(HTMLTextAreaSearchUtils.PROP_LAST_FIND_MATCH_CASE, Boolean.toString(this.matchCase.isSelected()));
            }
        }

        @Override
        public boolean requestFocusInWindow() {
            if (this.textC != null) {
                this.textC.selectAll();
                return this.textC.requestFocusInWindow();
            }
            return super.requestFocusInWindow();
        }
    }

    private static final class CustomHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        CustomHighlightPainter() {
            super(Color.ORANGE);
        }

        @Override
        public Shape paintLayer(Graphics g, int offs0, int offs1, Shape bounds, JTextComponent c, View view) {
            int selStart = c.getSelectionStart();
            int selEnd = c.getSelectionEnd();
            if (selEnd - selStart == 0 || offs0 >= selEnd || offs1 <= selStart) {
                return super.paintLayer(g, offs0, offs1, bounds, c, view);
            }
            if (offs0 >= selStart && offs1 <= selEnd) {
                return bounds;
            }
            if (offs0 < selStart || offs1 > selEnd) {
                if (offs0 >= selStart) {
                    return super.paintLayer(g, selEnd, offs1, bounds, c, view);
                }
                if (offs1 <= selEnd) {
                    return super.paintLayer(g, offs0, selStart, bounds, c, view);
                }
                super.paintLayer(g, offs0, selStart, bounds, c, view);
                super.paintLayer(g, selEnd, offs1, bounds, c, view);
            }
            return bounds;
        }
    }

    private static class DocumentSearchResult {
        private final String search;
        private final boolean matchCase;
        private final List<Integer> result;
        private final List<Object> highlights;

        static DocumentSearchResult current(JTextComponent component) {
            return (DocumentSearchResult)component.getClientProperty(HTMLTextAreaSearchUtils.PROP_SEARCH_RESULT);
        }

        static DocumentSearchResult get(String search, boolean matchCase, JTextComponent component) {
            DocumentSearchResult result = DocumentSearchResult.current(component);
            if (result != null) {
                if (result.compatibleSearch(search, matchCase)) {
                    return result;
                }
                result.clearHighlightedResults(component.getHighlighter());
            }
            try {
                Document document = component.getDocument();
                result = new DocumentSearchResult(search, matchCase, document.getText(0, document.getLength()));
                component.putClientProperty(HTMLTextAreaSearchUtils.PROP_SEARCH_RESULT, result);
                return result;
            }
            catch (BadLocationException ex) {
                return null;
            }
        }

        static DocumentSearchResult reset(JTextComponent component) {
            DocumentSearchResult result = DocumentSearchResult.current(component);
            if (result != null) {
                result.clearHighlightedResults(component.getHighlighter());
                component.putClientProperty(HTMLTextAreaSearchUtils.PROP_SEARCH_RESULT, null);
            }
            return result;
        }

        private DocumentSearchResult(String search, boolean matchCase, String text) {
            if (!matchCase) {
                search = search.toLowerCase(Locale.ENGLISH);
                text = text.toLowerCase(Locale.ENGLISH);
            }
            this.search = search;
            this.matchCase = matchCase;
            this.result = new ArrayList<Integer>();
            this.highlights = new ArrayList<Object>();
            int searchLength = search.length();
            int offset = text.indexOf(search, 0);
            while (offset >= 0) {
                this.result.add(offset);
                offset = text.indexOf(search, offset + searchLength);
            }
        }

        private boolean compatibleSearch(String string, boolean match) {
            if (this.matchCase != match) {
                return false;
            }
            return this.search.equals(this.matchCase ? string : string.toLowerCase(Locale.ENGLISH));
        }

        void highlightResults(Highlighter hl) {
            this.clearHighlightedResults(hl);
            for (int offset : this.result) {
                try {
                    this.highlights.add(hl.addHighlight(offset, offset + this.search.length(), new CustomHighlightPainter()));
                }
                catch (BadLocationException badLocationException) {}
            }
        }

        void clearHighlightedResults(Highlighter hl) {
            for (Object highlight : this.highlights) {
                hl.removeHighlight(highlight);
            }
            this.highlights.clear();
        }

        int getResultsCount() {
            return this.result.size();
        }

        int getOffset(int index) {
            return this.result.get(index);
        }

        int getNextIndex(int offset) {
            if (this.result.isEmpty()) {
                return -1;
            }
            for (int index = 0; index < this.result.size(); ++index) {
                if (this.result.get(index) <= offset) continue;
                return index;
            }
            return 0;
        }

        int getPreviousIndex(int offset) {
            if (this.result.isEmpty()) {
                return -1;
            }
            for (int i = this.result.size() - 1; i >= 0; --i) {
                if (this.result.get(i) >= offset) continue;
                return i;
            }
            return this.result.size() - 1;
        }
    }
}

