/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.awscore.retry;

import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsErrorCode;
import software.amazon.awssdk.awscore.retry.AwsRetryPolicy;
import software.amazon.awssdk.core.internal.retry.RetryPolicyAdapter;
import software.amazon.awssdk.core.internal.retry.SdkDefaultRetryStrategy;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.retries.AdaptiveRetryStrategy;
import software.amazon.awssdk.retries.DefaultRetryStrategy;
import software.amazon.awssdk.retries.LegacyRetryStrategy;
import software.amazon.awssdk.retries.StandardRetryStrategy;
import software.amazon.awssdk.retries.api.RetryStrategy;
import software.amazon.awssdk.retries.internal.DefaultAwareRetryStrategy;
import software.amazon.awssdk.retries.internal.RetryStrategyDefaults;

@SdkPublicApi
public final class AwsRetryStrategy {
    private static final String DEFAULTS_NAME = "aws";
    private static final RetryStrategyDefaults DEFAULTS_PREDICATES = new RetryStrategyDefaults(){

        public String name() {
            return AwsRetryStrategy.DEFAULTS_NAME;
        }

        public void applyDefaults(RetryStrategy.Builder<?, ?> retryStrategyBuilder) {
            AwsRetryStrategy.configureStrategy(retryStrategyBuilder);
            AwsRetryStrategy.markDefaultsAdded(retryStrategyBuilder);
        }
    };

    private AwsRetryStrategy() {
    }

    public static RetryStrategy defaultRetryStrategy() {
        return AwsRetryStrategy.forRetryMode(RetryMode.defaultRetryMode());
    }

    public static RetryStrategy forRetryMode(RetryMode mode) {
        switch (mode) {
            case STANDARD: {
                return AwsRetryStrategy.standardRetryStrategy();
            }
            case ADAPTIVE_V2: {
                return AwsRetryStrategy.adaptiveRetryStrategy();
            }
            case LEGACY: {
                return AwsRetryStrategy.legacyRetryStrategy();
            }
            case ADAPTIVE: {
                return AwsRetryStrategy.legacyAdaptiveRetryStrategy();
            }
        }
        throw new IllegalArgumentException("unknown retry mode: " + mode);
    }

    public static RetryStrategy addRetryConditions(RetryStrategy strategy) {
        return strategy.toBuilder().retryOnException(AwsRetryStrategy::retryOnAwsRetryableErrors).build();
    }

    public static RetryStrategy doNotRetry() {
        return DefaultRetryStrategy.doNotRetry();
    }

    public static StandardRetryStrategy standardRetryStrategy() {
        StandardRetryStrategy.Builder builder = SdkDefaultRetryStrategy.standardRetryStrategyBuilder();
        return AwsRetryStrategy.configure(builder).build();
    }

    public static LegacyRetryStrategy legacyRetryStrategy() {
        LegacyRetryStrategy.Builder builder = SdkDefaultRetryStrategy.legacyRetryStrategyBuilder();
        return AwsRetryStrategy.configure(builder).build();
    }

    public static AdaptiveRetryStrategy adaptiveRetryStrategy() {
        AdaptiveRetryStrategy.Builder builder = SdkDefaultRetryStrategy.adaptiveRetryStrategyBuilder();
        return AwsRetryStrategy.configure(builder).build();
    }

    public static <T extends RetryStrategy.Builder<T, ?>> T configure(T builder) {
        builder.retryOnException(AwsRetryStrategy::retryOnAwsRetryableErrors);
        AwsRetryStrategy.markDefaultsAdded(builder);
        return builder;
    }

    public static RetryStrategy.Builder<?, ?> configureStrategy(RetryStrategy.Builder<?, ?> builder) {
        if (builder instanceof RetryPolicyAdapter.Builder) {
            return builder;
        }
        return builder.retryOnException(AwsRetryStrategy::retryOnAwsRetryableErrors);
    }

    private static boolean retryOnAwsRetryableErrors(Throwable ex) {
        if (ex instanceof AwsServiceException) {
            AwsServiceException exception = (AwsServiceException)((Object)ex);
            return AwsErrorCode.RETRYABLE_ERROR_CODES.contains(exception.awsErrorDetails().errorCode());
        }
        return false;
    }

    private static RetryStrategy legacyAdaptiveRetryStrategy() {
        return RetryPolicyAdapter.builder().retryPolicy(AwsRetryPolicy.forRetryMode(RetryMode.ADAPTIVE)).build();
    }

    public static RetryStrategyDefaults retryStrategyDefaults() {
        return DEFAULTS_PREDICATES;
    }

    private static void markDefaultsAdded(RetryStrategy.Builder<?, ?> builder) {
        if (builder instanceof DefaultAwareRetryStrategy.Builder) {
            DefaultAwareRetryStrategy.Builder b = (DefaultAwareRetryStrategy.Builder)builder;
            b.markDefaultAdded(DEFAULTS_NAME);
        }
    }
}

