/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl3.internal.introspection;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.jexl3.JexlArithmetic;
import org.apache.commons.jexl3.JexlOperator;
import org.apache.commons.jexl3.introspection.JexlMethod;
import org.apache.commons.jexl3.introspection.JexlPropertyGet;
import org.apache.commons.jexl3.introspection.JexlPropertySet;
import org.apache.commons.jexl3.introspection.JexlSandbox;
import org.apache.commons.jexl3.introspection.JexlUberspect;

public final class SandboxUberspect
implements JexlUberspect {
    private final JexlUberspect uberspect;
    private final JexlSandbox sandbox;

    private static boolean eq(Object lhs, Object rhs) {
        return lhs == rhs;
    }

    public SandboxUberspect(JexlUberspect theUberspect, JexlSandbox theSandbox) {
        Objects.requireNonNull(theSandbox, "theSandbox");
        Objects.requireNonNull(theUberspect, "theUberspect");
        this.uberspect = theUberspect;
        this.sandbox = theSandbox.copy();
    }

    @Override
    public JexlArithmetic.Uberspect getArithmetic(JexlArithmetic arithmetic) {
        return this.uberspect.getArithmetic(arithmetic);
    }

    @Override
    public Class<?> getClassByName(String className) {
        return this.uberspect.getClassByName(className);
    }

    @Override
    public ClassLoader getClassLoader() {
        return this.uberspect.getClassLoader();
    }

    @Override
    public JexlMethod getConstructor(Object ctorHandle, Object ... args) {
        String className = ctorHandle instanceof Class ? this.sandbox.execute((Class)ctorHandle, "") : (ctorHandle != null ? this.sandbox.execute(ctorHandle.toString(), "") : null);
        return className != null && className != "?" ? this.uberspect.getConstructor(className, args) : null;
    }

    @Override
    public Iterator<?> getIterator(Object obj) {
        return this.uberspect.getIterator(obj);
    }

    @Override
    public JexlMethod getMethod(Object obj, String method, Object ... args) {
        Class<?> clazz;
        String actual;
        if (obj != null && method != null && (actual = this.sandbox.execute(clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass(), method)) != null && actual != "?") {
            return this.uberspect.getMethod(obj, actual, args);
        }
        return null;
    }

    @Override
    public JexlPropertyGet getPropertyGet(List<JexlUberspect.PropertyResolver> resolvers, Object obj, Object identifier) {
        if (obj != null) {
            Class<?> clazz;
            Class<?> clazz2 = clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
            if (identifier != null) {
                String property = identifier.toString();
                String actual = this.sandbox.read(clazz, property);
                if (actual != null) {
                    Object pty = SandboxUberspect.eq(actual, property) ? identifier : actual;
                    return this.uberspect.getPropertyGet(resolvers, obj, pty);
                }
            } else {
                String actual = this.sandbox.read(clazz, null);
                if (actual != "?") {
                    return this.uberspect.getPropertyGet(resolvers, obj, null);
                }
            }
        }
        return null;
    }

    @Override
    public JexlPropertyGet getPropertyGet(Object obj, Object identifier) {
        return this.getPropertyGet(null, obj, identifier);
    }

    @Override
    public JexlPropertySet getPropertySet(List<JexlUberspect.PropertyResolver> resolvers, Object obj, Object identifier, Object arg) {
        if (obj != null) {
            Class<?> clazz;
            Class<?> clazz2 = clazz = obj instanceof Class ? (Class<?>)obj : obj.getClass();
            if (identifier != null) {
                String property = identifier.toString();
                String actual = this.sandbox.write(clazz, property);
                if (actual != null) {
                    Object pty = SandboxUberspect.eq(actual, property) ? identifier : actual;
                    return this.uberspect.getPropertySet(resolvers, obj, pty, arg);
                }
            } else {
                String actual = this.sandbox.write(clazz, null);
                if (actual != "?") {
                    return this.uberspect.getPropertySet(resolvers, obj, null, arg);
                }
            }
        }
        return null;
    }

    @Override
    public JexlPropertySet getPropertySet(Object obj, Object identifier, Object arg) {
        return this.getPropertySet(null, obj, identifier, arg);
    }

    @Override
    public List<JexlUberspect.PropertyResolver> getResolvers(JexlOperator op, Object obj) {
        return this.uberspect.getResolvers(op, obj);
    }

    @Override
    public int getVersion() {
        return this.uberspect.getVersion();
    }

    @Override
    public void setClassLoader(ClassLoader loader) {
        this.uberspect.setClassLoader(loader);
    }
}

