/* [config]
 * expect_result: pass
 * glsl_version: 1.50
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * sqrt(0.0) => 0.0
 * sqrt(0.6666667) => 0.8164966
 * sqrt(1.3333334) => 1.1547005
 * sqrt(2.0) => 1.4142135
 */
#version 150

void main()
{
  float[distance(sqrt(0.0), 0.0) <= 0.0 ? 1 : -1] array0;
  float[distance(sqrt(0.6666667), 0.8164966) <= 8.164966e-06 ? 1 : -1] array1;
  float[distance(sqrt(1.3333334), 1.1547005) <= 1.1547006e-05 ? 1 : -1] array2;
  float[distance(sqrt(2.0), 1.4142135) <= 1.4142136e-05 ? 1 : -1] array3;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length());
}
