/* [config]
 * expect_result: pass
 * glsl_version: 1.30
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (ivec3(-36, 32, -88) | abs(~ ivec3(-36, 32, -88))) => ivec3(-1, 33, -1)
 * (ivec3(-36, 32, -88) | abs(~ ivec3(36, 32, 88))) => ivec3(-3, 33, -7)
 * (ivec3(-36, 32, -88) | abs(~ ivec3(59, 77, 68))) => ivec3(-4, 110, -19)
 * (ivec3(36, 32, 88) | abs(~ ivec3(-36, 32, -88))) => ivec3(39, 33, 95)
 * (ivec3(36, 32, 88) | abs(~ ivec3(36, 32, 88))) => ivec3(37, 33, 89)
 * (ivec3(36, 32, 88) | abs(~ ivec3(59, 77, 68))) => ivec3(60, 110, 93)
 * (ivec3(59, 77, 68) | abs(~ ivec3(-36, 32, -88))) => ivec3(59, 109, 87)
 * (ivec3(59, 77, 68) | abs(~ ivec3(36, 32, 88))) => ivec3(63, 109, 93)
 * (ivec3(59, 77, 68) | abs(~ ivec3(59, 77, 68))) => ivec3(63, 79, 69)
 */
#version 130

void main()
{
  float[all(equal((ivec3(-36, 32, -88) | abs(~ ivec3(-36, 32, -88))), ivec3(-1, 33, -1))) ? 1 : -1] array0;
  float[all(equal((ivec3(-36, 32, -88) | abs(~ ivec3(36, 32, 88))), ivec3(-3, 33, -7))) ? 1 : -1] array1;
  float[all(equal((ivec3(-36, 32, -88) | abs(~ ivec3(59, 77, 68))), ivec3(-4, 110, -19))) ? 1 : -1] array2;
  float[all(equal((ivec3(36, 32, 88) | abs(~ ivec3(-36, 32, -88))), ivec3(39, 33, 95))) ? 1 : -1] array3;
  float[all(equal((ivec3(36, 32, 88) | abs(~ ivec3(36, 32, 88))), ivec3(37, 33, 89))) ? 1 : -1] array4;
  float[all(equal((ivec3(36, 32, 88) | abs(~ ivec3(59, 77, 68))), ivec3(60, 110, 93))) ? 1 : -1] array5;
  float[all(equal((ivec3(59, 77, 68) | abs(~ ivec3(-36, 32, -88))), ivec3(59, 109, 87))) ? 1 : -1] array6;
  float[all(equal((ivec3(59, 77, 68) | abs(~ ivec3(36, 32, 88))), ivec3(63, 109, 93))) ? 1 : -1] array7;
  float[all(equal((ivec3(59, 77, 68) | abs(~ ivec3(59, 77, 68))), ivec3(63, 79, 69))) ? 1 : -1] array8;
  gl_FragColor = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length());
}
