/* [config]
 * expect_result: pass
 * glsl_version: 1.20
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * atan(vec2(0.0, 1e-10)) => vec2(0.0, 1e-10)
 * atan(vec2(-1e-10, 0.1)) => vec2(-1e-10, 0.09966865)
 * atan(vec2(-0.1, 1.0)) => vec2(-0.09966865, 0.7853982)
 * atan(vec2(-1.0, 10.0)) => vec2(-0.7853982, 1.4711276)
 * atan(vec2(-10.0, 10000000000.0)) => vec2(-1.4711276, 1.5707964)
 * atan(vec2(-10000000000.0, 0.0)) => vec2(-1.5707964, 0.0)
 */
#version 120

void main()
{
  float[distance(atan(vec2(0.0, 1e-10)), vec2(0.0, 1e-10)) <= 0.00014142135 ? 1 : -1] array0;
  float[distance(atan(vec2(-1e-10, 0.1)), vec2(-1e-10, 0.09966865)) <= 0.00014142135 ? 1 : -1] array1;
  float[distance(atan(vec2(-0.1, 1.0)), vec2(-0.09966865, 0.7853982)) <= 0.0007917388 ? 1 : -1] array2;
  float[distance(atan(vec2(-1.0, 10.0)), vec2(-0.7853982, 1.4711276)) <= 0.0016676531 ? 1 : -1] array3;
  float[distance(atan(vec2(-10.0, 10000000000.0)), vec2(-1.4711276, 1.5707964)) <= 0.0021521193 ? 1 : -1] array4;
  float[distance(atan(vec2(-10000000000.0, 0.0)), vec2(-1.5707964, 0.0)) <= 0.0015739762 ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
