/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (u64vec4(165ul, 133ul, 193ul, 76ul) - 0ul) => u64vec4(165ul, 133ul, 193ul, 76ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) - 3ul) => u64vec4(162ul, 130ul, 190ul, 73ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) - 1192ul) => u64vec4(18446744073709550589ul, 18446744073709550557ul, 18446744073709550617ul, 18446744073709550500ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) - 1048576ul) => u64vec4(18446744073708503205ul, 18446744073708503173ul, 18446744073708503233ul, 18446744073708503116ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) - 4251475ul) => u64vec4(18446744073705300306ul, 18446744073705300274ul, 18446744073705300334ul, 18446744073705300217ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) - 29852643761ul) => u64vec4(18446744043856908020ul, 18446744043856907988ul, 18446744043856908048ul, 18446744043856907931ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) - 4398046511104ul) => u64vec4(18446739675663040677ul, 18446739675663040645ul, 18446739675663040705ul, 18446739675663040588ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) - 3948976685146ul) => u64vec4(18446740124732866635ul, 18446740124732866603ul, 18446740124732866663ul, 18446740124732866546ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) - 135763469567146206ul) => u64vec4(18310980604142405575ul, 18310980604142405543ul, 18310980604142405603ul, 18310980604142405486ul)
 * (u64vec4(165ul, 133ul, 193ul, 76ul) - 11654173250180970009ul) => u64vec4(6792570823528581772ul, 6792570823528581740ul, 6792570823528581800ul, 6792570823528581683ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) - 0ul) => u64vec4(80ul, 15ul, 51ul, 0ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) - 3ul) => u64vec4(77ul, 12ul, 48ul, 18446744073709551613ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) - 1192ul) => u64vec4(18446744073709550504ul, 18446744073709550439ul, 18446744073709550475ul, 18446744073709550424ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) - 1048576ul) => u64vec4(18446744073708503120ul, 18446744073708503055ul, 18446744073708503091ul, 18446744073708503040ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) - 4251475ul) => u64vec4(18446744073705300221ul, 18446744073705300156ul, 18446744073705300192ul, 18446744073705300141ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) - 29852643761ul) => u64vec4(18446744043856907935ul, 18446744043856907870ul, 18446744043856907906ul, 18446744043856907855ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) - 4398046511104ul) => u64vec4(18446739675663040592ul, 18446739675663040527ul, 18446739675663040563ul, 18446739675663040512ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) - 3948976685146ul) => u64vec4(18446740124732866550ul, 18446740124732866485ul, 18446740124732866521ul, 18446740124732866470ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) - 135763469567146206ul) => u64vec4(18310980604142405490ul, 18310980604142405425ul, 18310980604142405461ul, 18310980604142405410ul)
 * (u64vec4(80ul, 15ul, 51ul, 0ul) - 11654173250180970009ul) => u64vec4(6792570823528581687ul, 6792570823528581622ul, 6792570823528581658ul, 6792570823528581607ul)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) - 0ul), u64vec4(165ul, 133ul, 193ul, 76ul))) ? 1 : -1] array0;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) - 3ul), u64vec4(162ul, 130ul, 190ul, 73ul))) ? 1 : -1] array1;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) - 1192ul), u64vec4(18446744073709550589ul, 18446744073709550557ul, 18446744073709550617ul, 18446744073709550500ul))) ? 1 : -1] array2;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) - 1048576ul), u64vec4(18446744073708503205ul, 18446744073708503173ul, 18446744073708503233ul, 18446744073708503116ul))) ? 1 : -1] array3;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) - 4251475ul), u64vec4(18446744073705300306ul, 18446744073705300274ul, 18446744073705300334ul, 18446744073705300217ul))) ? 1 : -1] array4;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) - 29852643761ul), u64vec4(18446744043856908020ul, 18446744043856907988ul, 18446744043856908048ul, 18446744043856907931ul))) ? 1 : -1] array5;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) - 4398046511104ul), u64vec4(18446739675663040677ul, 18446739675663040645ul, 18446739675663040705ul, 18446739675663040588ul))) ? 1 : -1] array6;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) - 3948976685146ul), u64vec4(18446740124732866635ul, 18446740124732866603ul, 18446740124732866663ul, 18446740124732866546ul))) ? 1 : -1] array7;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) - 135763469567146206ul), u64vec4(18310980604142405575ul, 18310980604142405543ul, 18310980604142405603ul, 18310980604142405486ul))) ? 1 : -1] array8;
  float[all(equal((u64vec4(165ul, 133ul, 193ul, 76ul) - 11654173250180970009ul), u64vec4(6792570823528581772ul, 6792570823528581740ul, 6792570823528581800ul, 6792570823528581683ul))) ? 1 : -1] array9;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) - 0ul), u64vec4(80ul, 15ul, 51ul, 0ul))) ? 1 : -1] array10;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) - 3ul), u64vec4(77ul, 12ul, 48ul, 18446744073709551613ul))) ? 1 : -1] array11;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) - 1192ul), u64vec4(18446744073709550504ul, 18446744073709550439ul, 18446744073709550475ul, 18446744073709550424ul))) ? 1 : -1] array12;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) - 1048576ul), u64vec4(18446744073708503120ul, 18446744073708503055ul, 18446744073708503091ul, 18446744073708503040ul))) ? 1 : -1] array13;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) - 4251475ul), u64vec4(18446744073705300221ul, 18446744073705300156ul, 18446744073705300192ul, 18446744073705300141ul))) ? 1 : -1] array14;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) - 29852643761ul), u64vec4(18446744043856907935ul, 18446744043856907870ul, 18446744043856907906ul, 18446744043856907855ul))) ? 1 : -1] array15;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) - 4398046511104ul), u64vec4(18446739675663040592ul, 18446739675663040527ul, 18446739675663040563ul, 18446739675663040512ul))) ? 1 : -1] array16;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) - 3948976685146ul), u64vec4(18446740124732866550ul, 18446740124732866485ul, 18446740124732866521ul, 18446740124732866470ul))) ? 1 : -1] array17;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) - 135763469567146206ul), u64vec4(18310980604142405490ul, 18310980604142405425ul, 18310980604142405461ul, 18310980604142405410ul))) ? 1 : -1] array18;
  float[all(equal((u64vec4(80ul, 15ul, 51ul, 0ul) - 11654173250180970009ul), u64vec4(6792570823528581687ul, 6792570823528581622ul, 6792570823528581658ul, 6792570823528581607ul))) ? 1 : -1] array19;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length() + array18.length() + array19.length());
}
