/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec4(165l, 133l, 193l, 76l) << 0ul) => i64vec4(165l, 133l, 193l, 76l)
 * (i64vec4(165l, 133l, 193l, 76l) << 1ul) => i64vec4(330l, 266l, 386l, 152l)
 * (i64vec4(165l, 133l, 193l, 76l) << 2ul) => i64vec4(660l, 532l, 772l, 304l)
 * (i64vec4(165l, 133l, 193l, 76l) << 5ul) => i64vec4(5280l, 4256l, 6176l, 2432l)
 * (i64vec4(165l, 133l, 193l, 76l) << 25ul) => i64vec4(5536481280l, 4462739456l, 6476005376l, 2550136832l)
 * (i64vec4(165l, 133l, 193l, 76l) << 31ul) => i64vec4(354334801920l, 285615325184l, 414464344064l, 163208757248l)
 * (i64vec4(165l, 133l, 193l, 76l) << 32ul) => i64vec4(708669603840l, 571230650368l, 828928688128l, 326417514496l)
 * (i64vec4(165l, 133l, 193l, 76l) << 47ul) => i64vec4(23221685578629120l, 18718085951258624l, 27162335252578304l, 10696049115004928l)
 * (i64vec4(165l, 133l, 193l, 76l) << 63ul) => i64vec4(-9223372036854775808l, -9223372036854775808l, -9223372036854775808l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << 0ul) => i64vec4(80l, -15l, -51l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << 1ul) => i64vec4(160l, -30l, -102l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << 2ul) => i64vec4(320l, -60l, -204l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << 5ul) => i64vec4(2560l, -480l, -1632l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << 25ul) => i64vec4(2684354560l, -503316480l, -1711276032l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << 31ul) => i64vec4(171798691840l, -32212254720l, -109521666048l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << 32ul) => i64vec4(343597383680l, -64424509440l, -219043332096l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << 47ul) => i64vec4(11258999068426240l, -2111062325329920l, -7177611906121728l, 0l)
 * (i64vec4(80l, -15l, -51l, 0l) << 63ul) => i64vec4(0l, -9223372036854775808l, -9223372036854775808l, 0l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << 0ul), i64vec4(165l, 133l, 193l, 76l))) ? 1 : -1] array0;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << 1ul), i64vec4(330l, 266l, 386l, 152l))) ? 1 : -1] array1;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << 2ul), i64vec4(660l, 532l, 772l, 304l))) ? 1 : -1] array2;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << 5ul), i64vec4(5280l, 4256l, 6176l, 2432l))) ? 1 : -1] array3;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << 25ul), i64vec4(5536481280l, 4462739456l, 6476005376l, 2550136832l))) ? 1 : -1] array4;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << 31ul), i64vec4(354334801920l, 285615325184l, 414464344064l, 163208757248l))) ? 1 : -1] array5;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << 32ul), i64vec4(708669603840l, 571230650368l, 828928688128l, 326417514496l))) ? 1 : -1] array6;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << 47ul), i64vec4(23221685578629120l, 18718085951258624l, 27162335252578304l, 10696049115004928l))) ? 1 : -1] array7;
  float[all(equal((i64vec4(165l, 133l, 193l, 76l) << 63ul), i64vec4(-9223372036854775808l, -9223372036854775808l, -9223372036854775808l, 0l))) ? 1 : -1] array8;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << 0ul), i64vec4(80l, -15l, -51l, 0l))) ? 1 : -1] array9;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << 1ul), i64vec4(160l, -30l, -102l, 0l))) ? 1 : -1] array10;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << 2ul), i64vec4(320l, -60l, -204l, 0l))) ? 1 : -1] array11;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << 5ul), i64vec4(2560l, -480l, -1632l, 0l))) ? 1 : -1] array12;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << 25ul), i64vec4(2684354560l, -503316480l, -1711276032l, 0l))) ? 1 : -1] array13;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << 31ul), i64vec4(171798691840l, -32212254720l, -109521666048l, 0l))) ? 1 : -1] array14;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << 32ul), i64vec4(343597383680l, -64424509440l, -219043332096l, 0l))) ? 1 : -1] array15;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << 47ul), i64vec4(11258999068426240l, -2111062325329920l, -7177611906121728l, 0l))) ? 1 : -1] array16;
  float[all(equal((i64vec4(80l, -15l, -51l, 0l) << 63ul), i64vec4(0l, -9223372036854775808l, -9223372036854775808l, 0l))) ? 1 : -1] array17;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length() + array6.length() + array7.length() + array8.length() + array9.length() + array10.length() + array11.length() + array12.length() + array13.length() + array14.length() + array15.length() + array16.length() + array17.length());
}
