/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.flowframework.transport;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.util.Booleans;
import org.apache.logging.log4j.message.ParameterizedMessageFactory;
import org.opensearch.action.delete.DeleteResponse;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.HandledTransportAction;
import org.opensearch.cluster.service.ClusterService;
import org.opensearch.common.inject.Inject;
import org.opensearch.common.settings.Settings;
import org.opensearch.common.util.concurrent.ThreadContext;
import org.opensearch.commons.authuser.User;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.NamedXContentRegistry;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.flowframework.common.FlowFrameworkSettings;
import org.opensearch.flowframework.exception.FlowFrameworkException;
import org.opensearch.flowframework.indices.FlowFrameworkIndicesHandler;
import org.opensearch.flowframework.transport.WorkflowRequest;
import org.opensearch.flowframework.util.ParseUtils;
import org.opensearch.flowframework.util.TenantAwareHelper;
import org.opensearch.remote.metadata.client.DeleteDataObjectRequest;
import org.opensearch.remote.metadata.client.SdkClient;
import org.opensearch.remote.metadata.common.SdkClientUtils;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportService;
import org.opensearch.transport.client.Client;

public class DeleteWorkflowTransportAction
extends HandledTransportAction<WorkflowRequest, DeleteResponse> {
    private final Logger logger = LogManager.getLogger(DeleteWorkflowTransportAction.class);
    private final FlowFrameworkIndicesHandler flowFrameworkIndicesHandler;
    private final FlowFrameworkSettings flowFrameworkSettings;
    private final Client client;
    private final SdkClient sdkClient;
    private volatile Boolean filterByEnabled;
    private final ClusterService clusterService;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public DeleteWorkflowTransportAction(TransportService transportService, ActionFilters actionFilters, FlowFrameworkIndicesHandler flowFrameworkIndicesHandler, FlowFrameworkSettings flowFrameworkSettings, Client client, SdkClient sdkClient, ClusterService clusterService, NamedXContentRegistry xContentRegistry, Settings settings) {
        super("cluster:admin/opensearch/flow_framework/workflow/delete", transportService, actionFilters, WorkflowRequest::new);
        this.flowFrameworkIndicesHandler = flowFrameworkIndicesHandler;
        this.flowFrameworkSettings = flowFrameworkSettings;
        this.client = client;
        this.sdkClient = sdkClient;
        this.filterByEnabled = (Boolean)FlowFrameworkSettings.FILTER_BY_BACKEND_ROLES.get(settings);
        this.xContentRegistry = xContentRegistry;
        this.clusterService = clusterService;
        clusterService.getClusterSettings().addSettingsUpdateConsumer(FlowFrameworkSettings.FILTER_BY_BACKEND_ROLES, it -> {
            this.filterByEnabled = it;
        });
    }

    protected void doExecute(Task task, WorkflowRequest request, ActionListener<DeleteResponse> listener) {
        if (this.flowFrameworkIndicesHandler.doesIndexExist(".plugins-flow-framework-templates")) {
            String tenantId;
            String string = tenantId = request.getTemplate() == null ? null : request.getTemplate().getTenantId();
            if (!TenantAwareHelper.validateTenantId(this.flowFrameworkSettings.isMultiTenancyEnabled(), tenantId, listener)) {
                return;
            }
            String workflowId = request.getWorkflowId();
            User user = ParseUtils.getUserContext(this.client);
            boolean clearStatus = Booleans.parseBoolean((String)request.getParams().get("clear_status"), (boolean)false);
            ThreadContext.StoredContext context = this.client.threadPool().getThreadContext().stashContext();
            ParseUtils.verifyResourceAccessAndProcessRequest("workflow", () -> this.executeDeleteRequest(request, tenantId, listener, context), () -> ParseUtils.resolveUserAndExecute(user, workflowId, tenantId, this.filterByEnabled, clearStatus, this.flowFrameworkSettings.isMultiTenancyEnabled(), (ActionListener<? extends ActionResponse>)listener, () -> this.executeDeleteRequest(request, tenantId, listener, context), this.client, this.sdkClient, this.clusterService, this.xContentRegistry));
        } else {
            String errorMessage = "There are no templates in the global context";
            this.logger.error(errorMessage);
            listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.NOT_FOUND)));
        }
    }

    private void executeDeleteRequest(WorkflowRequest request, String tenantId, ActionListener<DeleteResponse> listener, ThreadContext.StoredContext context) {
        String workflowId = request.getWorkflowId();
        DeleteDataObjectRequest deleteRequest = ((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)((DeleteDataObjectRequest.Builder)DeleteDataObjectRequest.builder().index(".plugins-flow-framework-templates")).id(workflowId)).tenantId(tenantId)).build();
        this.sdkClient.deleteDataObjectAsync(deleteRequest).whenComplete((r, throwable) -> {
            context.restore();
            if (throwable == null) {
                try {
                    DeleteResponse response = DeleteResponse.fromXContent((XContentParser)r.parser());
                    listener.onResponse((Object)response);
                }
                catch (Exception e) {
                    this.logger.error("Failed to parse delete response", (Throwable)e);
                    listener.onFailure((Exception)((Object)new FlowFrameworkException("Failed to parse delete response", RestStatus.INTERNAL_SERVER_ERROR)));
                }
            } else {
                Exception exception = SdkClientUtils.unwrapAndConvertToException((Throwable)throwable, (Class[])new Class[0]);
                String errorMessage = ParameterizedMessageFactory.INSTANCE.newMessage("Failed to delete template {}", (Object)workflowId).getFormattedMessage();
                this.logger.error(errorMessage, (Throwable)exception);
                listener.onFailure((Exception)((Object)new FlowFrameworkException(errorMessage, RestStatus.INTERNAL_SERVER_ERROR)));
            }
        });
        boolean clearStatus = Booleans.parseBoolean((String)request.getParams().get("clear_status"), (boolean)false);
        ActionListener stateListener = ActionListener.wrap(response -> this.logger.info("Deleted workflow state doc: {}", (Object)workflowId), exception -> this.logger.info("Failed to delete workflow state doc: {}", (Object)workflowId, exception));
        this.flowFrameworkIndicesHandler.canDeleteWorkflowStateDoc(workflowId, tenantId, clearStatus, canDelete -> {
            if (Boolean.TRUE.equals(canDelete)) {
                this.flowFrameworkIndicesHandler.deleteFlowFrameworkSystemIndexDoc(workflowId, tenantId, (ActionListener<DeleteResponse>)stateListener);
            }
        }, stateListener);
    }
}

