/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.ltr.stats;

import java.util.function.Supplier;
import org.opensearch.ltr.stats.suppliers.CounterSupplier;

public class LTRStat<T> {
    private final boolean clusterLevel;
    private final Supplier<T> supplier;

    public LTRStat(Boolean clusterLevel, Supplier<T> supplier) {
        this.clusterLevel = clusterLevel;
        this.supplier = supplier;
    }

    public Boolean isClusterLevel() {
        return this.clusterLevel;
    }

    public T getValue() {
        return this.supplier.get();
    }

    public void increment() {
        if (!(this.supplier instanceof CounterSupplier)) {
            throw new UnsupportedOperationException("cannot increment the supplier: " + this.supplier.getClass().getName());
        }
        ((CounterSupplier)this.supplier).increment();
    }
}

