/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.searchrelevance.judgments.clickmodel.coec;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.action.search.ClearScrollRequest;
import org.opensearch.action.search.SearchRequest;
import org.opensearch.action.search.SearchResponse;
import org.opensearch.action.search.SearchScrollRequest;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.core.action.ActionListener;
import org.opensearch.index.query.BoolQueryBuilder;
import org.opensearch.index.query.QueryBuilder;
import org.opensearch.index.query.QueryBuilders;
import org.opensearch.index.query.RangeQueryBuilder;
import org.opensearch.search.SearchHit;
import org.opensearch.search.aggregations.AggregationBuilder;
import org.opensearch.search.aggregations.AggregationBuilders;
import org.opensearch.search.aggregations.bucket.terms.Terms;
import org.opensearch.search.aggregations.bucket.terms.TermsAggregationBuilder;
import org.opensearch.search.builder.SearchSourceBuilder;
import org.opensearch.searchrelevance.judgments.clickmodel.ClickModel;
import org.opensearch.searchrelevance.judgments.clickmodel.coec.CoecClickModelParameters;
import org.opensearch.searchrelevance.model.ClickthroughRate;
import org.opensearch.searchrelevance.model.ubi.event.UbiEvent;
import org.opensearch.searchrelevance.utils.JsonUtils;
import org.opensearch.transport.client.Client;

public class CoecClickModel
extends ClickModel {
    public static final String CLICK_MODEL_NAME = "coec";
    private static final TimeValue SEARCH_TIMEOUT = TimeValue.timeValueMinutes((long)5L);
    private static final int SCROLL_SIZE = 1000;
    private static final TimeValue SCROLL_TIMEOUT = TimeValue.timeValueMinutes((long)10L);
    private final CoecClickModelParameters parameters;
    private final Client client;
    private static final Logger LOGGER = LogManager.getLogger((String)CoecClickModel.class.getName());

    public CoecClickModel(Client client, CoecClickModelParameters parameters) {
        this.parameters = parameters;
        this.client = client;
    }

    @Override
    public void calculateJudgments(ActionListener<List<Map<String, Object>>> listener) {
        this.getRankAggregatedClickThrough((ActionListener<Map<Integer, Double>>)ActionListener.wrap(rankAggregatedClickThrough -> this.getClickthroughRate((ActionListener<Map<String, Set<ClickthroughRate>>>)ActionListener.wrap(clickthroughRates -> {
            try {
                this.calculateCoecJudgments((Map<Integer, Double>)rankAggregatedClickThrough, (Map<String, Set<ClickthroughRate>>)clickthroughRates, listener);
            }
            catch (Exception e) {
                listener.onFailure(e);
            }
        }, arg_0 -> ((ActionListener)listener).onFailure(arg_0))), arg_0 -> listener.onFailure(arg_0)));
    }

    private void getRankAggregatedClickThrough(ActionListener<Map<Integer, Double>> listener) {
        LOGGER.info("Starting rank aggregated clickthrough calculation");
        String startDate = this.parameters.getStartDate();
        String endDate = this.parameters.getEndDate();
        RangeQueryBuilder dateFilter = QueryBuilders.rangeQuery((String)"timestamp").format("yyyy-MM-dd").lte((Object)(endDate.equals("") ? null : endDate)).gte((Object)(startDate.equals("") ? null : startDate));
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)"event_attributes.position.ordinal").lte((Object)this.parameters.getMaxRank())).must((QueryBuilder)dateFilter);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).size(1000).timeout(SEARCH_TIMEOUT);
        TermsAggregationBuilder actionAgg = (TermsAggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"actions").field("action_name")).subAggregation((AggregationBuilder)((TermsAggregationBuilder)AggregationBuilders.terms((String)"positions").field("event_attributes.position.ordinal")).size(this.parameters.getMaxRank()));
        searchSourceBuilder.aggregation((AggregationBuilder)actionAgg);
        SearchRequest searchRequest = new SearchRequest(new String[]{"ubi_events"}).source(searchSourceBuilder);
        this.client.search(searchRequest, ActionListener.wrap(response -> {
            try {
                HashMap<Integer, Double> rankAggregatedClickThrough = new HashMap<Integer, Double>();
                HashMap<Integer, Long> clickCounts = new HashMap<Integer, Long>();
                HashMap<Integer, Long> impressionCounts = new HashMap<Integer, Long>();
                Terms actionTerms = (Terms)response.getAggregations().get("actions");
                LOGGER.debug("Total buckets in aggregation: {}", (Object)actionTerms.getBuckets().size());
                for (Terms.Bucket actionBucket : actionTerms.getBuckets()) {
                    String action = actionBucket.getKeyAsString();
                    long docCount = actionBucket.getDocCount();
                    LOGGER.debug("Action: {} - Count: {}", (Object)action, (Object)docCount);
                    Terms positionTerms = (Terms)actionBucket.getAggregations().get("positions");
                    for (Terms.Bucket positionBucket : positionTerms.getBuckets()) {
                        int position = Integer.parseInt(positionBucket.getKeyAsString());
                        long count = positionBucket.getDocCount();
                        if ("click".equalsIgnoreCase(action)) {
                            clickCounts.put(position, count);
                            LOGGER.debug("Position {} clicks: {}", (Object)position, (Object)count);
                            continue;
                        }
                        if (!"impression".equalsIgnoreCase(action)) continue;
                        impressionCounts.put(position, count);
                        LOGGER.debug("Position {} impressions: {}", (Object)position, (Object)count);
                    }
                }
                for (int rank = 0; rank < this.parameters.getMaxRank(); ++rank) {
                    long impressions = impressionCounts.getOrDefault(rank, 0L);
                    long clicks = clickCounts.getOrDefault(rank, 0L);
                    LOGGER.debug("Rank {}: {} clicks / {} impressions", (Object)rank, (Object)clicks, (Object)impressions);
                    if (impressions > 0L) {
                        double ctr = (double)clicks / (double)impressions;
                        rankAggregatedClickThrough.put(rank, ctr);
                        LOGGER.debug("CTR for rank {}: {}", (Object)rank, (Object)ctr);
                        continue;
                    }
                    rankAggregatedClickThrough.put(rank, 0.0);
                    LOGGER.debug("No impressions for rank {}, CTR set to 0", (Object)rank);
                }
                listener.onResponse(rankAggregatedClickThrough);
            }
            catch (Exception e) {
                LOGGER.error("Error processing aggregations", (Throwable)e);
                listener.onFailure(e);
            }
        }, e -> {
            LOGGER.error("Search failed", (Throwable)e);
            listener.onFailure(e);
        }));
    }

    private void getClickthroughRate(ActionListener<Map<String, Set<ClickthroughRate>>> listener) {
        LOGGER.info("Starting clickthrough rate calculation");
        ConcurrentHashMap<String, Set<ClickthroughRate>> queriesToClickthroughRates = new ConcurrentHashMap<String, Set<ClickthroughRate>>();
        String startDate = this.parameters.getStartDate();
        String endDate = this.parameters.getEndDate();
        RangeQueryBuilder dateFilter = QueryBuilders.rangeQuery((String)"timestamp").format("yyyy-MM-dd").lte((Object)(endDate.equals("") ? null : endDate)).gte((Object)(startDate.equals("") ? null : startDate));
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)"event_attributes.position.ordinal").lte((Object)this.parameters.getMaxRank())).must((QueryBuilder)dateFilter);
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).size(1000).timeout(SEARCH_TIMEOUT).fetchSource(new String[]{"query_id", "action_name", "user_query", "event_attributes.object.object_id", "event_attributes.position.ordinal"}, null);
        SearchRequest searchRequest = new SearchRequest(new String[]{"ubi_events"}).source(searchSourceBuilder).scroll(SCROLL_TIMEOUT);
        this.processClickthroughSearch(searchRequest, queriesToClickthroughRates, listener);
    }

    private void processClickthroughSearch(SearchRequest searchRequest, final Map<String, Set<ClickthroughRate>> queriesToClickthroughRates, final ActionListener<Map<String, Set<ClickthroughRate>>> listener) {
        this.client.search(searchRequest, (ActionListener)new ActionListener<SearchResponse>(){
            final /* synthetic */ CoecClickModel this$0;
            {
                this.this$0 = this$0;
            }

            public void onResponse(SearchResponse response) {
                SearchHit[] hits = response.getHits().getHits();
                LOGGER.info("Processing batch of {} hits", (Object)hits.length);
                for (SearchHit hit : hits) {
                    try {
                        UbiEvent event = JsonUtils.fromJson(hit.getSourceAsString(), UbiEvent.class);
                        String userQuery = event.getUserQuery();
                        String objectId = event.getEventAttributes().getObject().getObjectId();
                        String action = event.getActionName();
                        int rank = event.getEventAttributes().getPosition().getOrdinal();
                        Set rates = queriesToClickthroughRates.computeIfAbsent(userQuery, k -> ConcurrentHashMap.newKeySet());
                        ClickthroughRate rate = rates.stream().filter(r -> r.getObjectId().equals(objectId)).findFirst().orElseGet(() -> {
                            ClickthroughRate newRate = new ClickthroughRate(objectId);
                            rates.add(newRate);
                            return newRate;
                        });
                        if ("click".equalsIgnoreCase(action)) {
                            rate.logClick();
                            rate.logRank(rank);
                            LOGGER.debug("Logged click for query: {} doc: {} rank: {}", (Object)userQuery, (Object)objectId, (Object)rank);
                            continue;
                        }
                        if (!"impression".equalsIgnoreCase(action)) continue;
                        rate.logImpression();
                        rate.logRank(rank);
                        LOGGER.debug("Logged impression for query: {} doc: {} rank: {}", (Object)userQuery, (Object)objectId, (Object)rank);
                    }
                    catch (Exception e) {
                        LOGGER.warn("Error processing hit: " + hit.getId(), (Throwable)e);
                    }
                }
                if (hits.length == 0) {
                    for (Map.Entry entry : queriesToClickthroughRates.entrySet()) {
                        LOGGER.debug("Query: {} - Number of docs: {}", entry.getKey(), (Object)((Set)entry.getValue()).size());
                        for (ClickthroughRate rate : (Set)entry.getValue()) {
                            LOGGER.debug("Doc: {} - Clicks: {} Impressions: {}", (Object)rate.getObjectId(), (Object)rate.getClicks(), (Object)rate.getImpressions());
                        }
                    }
                    listener.onResponse((Object)queriesToClickthroughRates);
                } else {
                    SearchScrollRequest scrollRequest = new SearchScrollRequest(response.getScrollId()).scroll(SCROLL_TIMEOUT);
                    this.this$0.client.searchScroll(scrollRequest, (ActionListener)this);
                }
            }

            public void onFailure(Exception e) {
                LOGGER.error("Search failed", (Throwable)e);
                listener.onFailure(e);
            }
        });
    }

    private void processClickEvents(Map<Integer, Long> clickCounts, ActionListener<Map<Integer, Long>> listener) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"action_name.keyword", (String)"click")).must((QueryBuilder)QueryBuilders.rangeQuery((String)"event_attributes.position.ordinal").lte((Object)this.parameters.getMaxRank()));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).size(1000).timeout(SEARCH_TIMEOUT);
        SearchRequest searchRequest = new SearchRequest(new String[]{"ubi_events"}).source(searchSourceBuilder).scroll(SCROLL_TIMEOUT);
        LOGGER.debug("Starting click events scroll search");
        this.scrollEvents(searchRequest, null, clickCounts, "click", listener);
    }

    private void processImpressionEvents(Map<Integer, Long> clickCounts, Map<Integer, Long> impressionCounts, ActionListener<Map<Integer, Double>> finalListener) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"action_name.keyword", (String)"impression")).must((QueryBuilder)QueryBuilders.rangeQuery((String)"event_attributes.position.ordinal").lte((Object)this.parameters.getMaxRank()));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).size(1000).timeout(SEARCH_TIMEOUT);
        SearchRequest searchRequest = new SearchRequest(new String[]{"ubi_events"}).source(searchSourceBuilder).scroll(SCROLL_TIMEOUT);
        LOGGER.debug("Starting impression events scroll search");
        this.scrollEvents(searchRequest, null, impressionCounts, "impression", (ActionListener<Map<Integer, Long>>)ActionListener.wrap(impressionCountsResult -> {
            LOGGER.info("Completed processing impression events, calculating CTR");
            this.calculateCTR(clickCounts, (Map<Integer, Long>)impressionCountsResult, finalListener);
        }, e -> {
            LOGGER.error("Failed to process impression events", (Throwable)e);
            finalListener.onFailure(e);
        }));
    }

    private void scrollEvents(SearchRequest initialRequest, String scrollId, final Map<Integer, Long> counts, final String eventType, final ActionListener<Map<Integer, Long>> listener) {
        if (scrollId == null) {
            this.client.search(initialRequest, (ActionListener)new ActionListener<SearchResponse>(){
                final /* synthetic */ CoecClickModel this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(SearchResponse response) {
                    this.this$0.processScrollResponse(response, counts, eventType, (ActionListener<Map<Integer, Long>>)listener);
                }

                public void onFailure(Exception e) {
                    LOGGER.error("Initial search request failed for " + eventType, (Throwable)e);
                    listener.onFailure(e);
                }
            });
        } else {
            SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId).scroll(SCROLL_TIMEOUT);
            this.client.searchScroll(scrollRequest, (ActionListener)new ActionListener<SearchResponse>(){
                final /* synthetic */ CoecClickModel this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(SearchResponse response) {
                    this.this$0.processScrollResponse(response, counts, eventType, (ActionListener<Map<Integer, Long>>)listener);
                }

                public void onFailure(Exception e) {
                    LOGGER.error("Scroll request failed for " + eventType, (Throwable)e);
                    listener.onFailure(e);
                }
            });
        }
    }

    private void processScrollResponse(SearchResponse response, Map<Integer, Long> counts, String eventType, ActionListener<Map<Integer, Long>> listener) {
        try {
            SearchHit[] hits = response.getHits().getHits();
            LOGGER.debug("Processing {} {} events", (Object)hits.length, (Object)eventType);
            if (hits.length == 0) {
                if (response.getScrollId() != null) {
                    ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                    clearScrollRequest.addScrollId(response.getScrollId());
                    this.client.clearScroll(clearScrollRequest, ActionListener.wrap(clearResponse -> {
                        LOGGER.debug("Scroll cleared for {} events", (Object)eventType);
                        listener.onResponse((Object)counts);
                    }, e -> {
                        LOGGER.warn("Failed to clear scroll", (Throwable)e);
                        listener.onResponse((Object)counts);
                    }));
                } else {
                    listener.onResponse(counts);
                }
                return;
            }
            for (SearchHit hit : hits) {
                try {
                    UbiEvent event = JsonUtils.fromJson(hit.getSourceAsString(), UbiEvent.class);
                    int position = event.getEventAttributes().getPosition().getOrdinal();
                    if (position >= this.parameters.getMaxRank()) continue;
                    counts.merge(position, 1L, Long::sum);
                }
                catch (Exception e2) {
                    LOGGER.warn("Error processing hit: " + hit.getId(), (Throwable)e2);
                }
            }
            this.scrollEvents(null, response.getScrollId(), counts, eventType, listener);
        }
        catch (Exception e3) {
            LOGGER.error("Error processing scroll response for " + eventType, (Throwable)e3);
            listener.onFailure(e3);
        }
    }

    private void calculateCTR(Map<Integer, Long> clickCounts, Map<Integer, Long> impressionCounts, ActionListener<Map<Integer, Double>> listener) {
        try {
            HashMap<Integer, Double> rankAggregatedClickThrough = new HashMap<Integer, Double>();
            for (int rank = 0; rank < this.parameters.getMaxRank(); ++rank) {
                long impressions = impressionCounts.getOrDefault(rank, 0L);
                if (impressions > 0L) {
                    double ctr = (double)clickCounts.getOrDefault(rank, 0L).longValue() / (double)impressions;
                    rankAggregatedClickThrough.put(rank, ctr);
                    LOGGER.debug("Rank {}: {} clicks / {} impressions = {} CTR", (Object)rank, (Object)clickCounts.getOrDefault(rank, 0L), (Object)impressions, (Object)ctr);
                    continue;
                }
                rankAggregatedClickThrough.put(rank, 0.0);
                LOGGER.debug("Rank {}: No impressions, CTR = 0.0", (Object)rank);
            }
            LOGGER.info("CTR calculation completed for {} ranks", (Object)rankAggregatedClickThrough.size());
            listener.onResponse(rankAggregatedClickThrough);
        }
        catch (Exception e) {
            LOGGER.error("Error calculating CTR", (Throwable)e);
            listener.onFailure(e);
        }
    }

    private void scrollRankAggregatedData(SearchRequest initialRequest, String scrollId, final Map<Integer, Long> clickCounts, final Map<Integer, Long> impressionCounts, final ActionListener<Map<Integer, Double>> listener) {
        if (scrollId == null) {
            this.client.search(initialRequest, (ActionListener)new ActionListener<SearchResponse>(){
                final /* synthetic */ CoecClickModel this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(SearchResponse response) {
                    this.this$0.processScrolledHits(response, clickCounts, impressionCounts, (ActionListener<Map<Integer, Double>>)listener);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        } else {
            SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId).scroll(SCROLL_TIMEOUT);
            this.client.searchScroll(scrollRequest, (ActionListener)new ActionListener<SearchResponse>(){
                final /* synthetic */ CoecClickModel this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(SearchResponse response) {
                    this.this$0.processScrolledHits(response, clickCounts, impressionCounts, (ActionListener<Map<Integer, Double>>)listener);
                }

                public void onFailure(Exception e) {
                    listener.onFailure(e);
                }
            });
        }
    }

    private void processScrolledHits(SearchResponse response, Map<Integer, Long> clickCounts, Map<Integer, Long> impressionCounts, ActionListener<Map<Integer, Double>> listener) {
        SearchHit[] hits = response.getHits().getHits();
        if (hits.length == 0) {
            HashMap<Integer, Double> rankAggregatedClickThrough = new HashMap<Integer, Double>();
            for (int rank = 0; rank < this.parameters.getMaxRank(); ++rank) {
                long impressions = impressionCounts.getOrDefault(rank, 0L);
                if (impressions > 0L) {
                    double ctr = (double)clickCounts.getOrDefault(rank, 0L).longValue() / (double)impressions;
                    rankAggregatedClickThrough.put(rank, ctr);
                    continue;
                }
                rankAggregatedClickThrough.put(rank, 0.0);
            }
            if (response.getScrollId() != null) {
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                clearScrollRequest.addScrollId(response.getScrollId());
                this.client.clearScroll(clearScrollRequest, ActionListener.wrap(clearResponse -> listener.onResponse((Object)rankAggregatedClickThrough), arg_0 -> listener.onFailure(arg_0)));
            } else {
                listener.onResponse(rankAggregatedClickThrough);
            }
            return;
        }
        for (SearchHit hit : hits) {
            try {
                UbiEvent event = JsonUtils.fromJson(hit.getSourceAsString(), UbiEvent.class);
                int position = event.getEventAttributes().getPosition().getOrdinal();
                if (position >= this.parameters.getMaxRank()) continue;
                if ("click".equalsIgnoreCase(event.getActionName())) {
                    clickCounts.merge(position, 1L, Long::sum);
                    continue;
                }
                if (!"impression".equalsIgnoreCase(event.getActionName())) continue;
                impressionCounts.merge(position, 1L, Long::sum);
            }
            catch (Exception e) {
                LOGGER.warn("Error processing hit: " + hit.getId(), (Throwable)e);
            }
        }
        this.scrollRankAggregatedData(null, response.getScrollId(), clickCounts, impressionCounts, listener);
    }

    private void scrollClickthroughRates(SearchRequest initialRequest, String scrollId, final Map<String, Set<ClickthroughRate>> queriesToClickthroughRates, final ActionListener<Map<String, Set<ClickthroughRate>>> listener) {
        if (scrollId == null) {
            this.client.search(initialRequest, (ActionListener)new ActionListener<SearchResponse>(){
                final /* synthetic */ CoecClickModel this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(SearchResponse response) {
                    this.this$0.processClickthroughBatch(response, queriesToClickthroughRates, (ActionListener<Map<String, Set<ClickthroughRate>>>)listener);
                }

                public void onFailure(Exception e) {
                    LOGGER.error("Initial clickthrough search failed", (Throwable)e);
                    listener.onFailure(e);
                }
            });
        } else {
            SearchScrollRequest scrollRequest = new SearchScrollRequest(scrollId).scroll(SCROLL_TIMEOUT);
            this.client.searchScroll(scrollRequest, (ActionListener)new ActionListener<SearchResponse>(){
                final /* synthetic */ CoecClickModel this$0;
                {
                    this.this$0 = this$0;
                }

                public void onResponse(SearchResponse response) {
                    this.this$0.processClickthroughBatch(response, queriesToClickthroughRates, (ActionListener<Map<String, Set<ClickthroughRate>>>)listener);
                }

                public void onFailure(Exception e) {
                    LOGGER.error("Clickthrough scroll request failed", (Throwable)e);
                    listener.onFailure(e);
                }
            });
        }
    }

    private void processClickthroughBatch(SearchResponse response, Map<String, Set<ClickthroughRate>> queriesToClickthroughRates, ActionListener<Map<String, Set<ClickthroughRate>>> listener) {
        SearchHit[] hits = response.getHits().getHits();
        LOGGER.debug("Processing {} hits for clickthrough rates", (Object)hits.length);
        if (hits.length == 0) {
            if (response.getScrollId() != null) {
                ClearScrollRequest clearScrollRequest = new ClearScrollRequest();
                clearScrollRequest.addScrollId(response.getScrollId());
                this.client.clearScroll(clearScrollRequest, ActionListener.wrap(clearResponse -> {
                    LOGGER.info("Completed clickthrough rate calculation with {} queries", (Object)queriesToClickthroughRates.size());
                    listener.onResponse((Object)queriesToClickthroughRates);
                }, e -> {
                    LOGGER.warn("Failed to clear scroll", (Throwable)e);
                    listener.onResponse((Object)queriesToClickthroughRates);
                }));
            } else {
                listener.onResponse(queriesToClickthroughRates);
            }
            return;
        }
        AtomicInteger pendingHits = new AtomicInteger(hits.length);
        AtomicBoolean hasError = new AtomicBoolean(false);
        for (SearchHit hit : hits) {
            try {
                UbiEvent ubiEvent = JsonUtils.fromJson(hit.getSourceAsString(), UbiEvent.class);
                String queryId = ubiEvent.getQueryId();
                this.getUserQuery(queryId, (ActionListener<String>)ActionListener.wrap(userQuery -> {
                    if (userQuery != null) {
                        Map map = queriesToClickthroughRates;
                        synchronized (map) {
                            Set clickthroughRates = queriesToClickthroughRates.computeIfAbsent((String)userQuery, k -> new HashSet());
                            ClickthroughRate clickthroughRate = clickthroughRates.stream().filter(ctr -> ctr.getObjectId().equals(ubiEvent.getEventAttributes().getObject().getObjectId())).findFirst().orElseGet(() -> new ClickthroughRate(ubiEvent.getEventAttributes().getObject().getObjectId()));
                            if ("click".equalsIgnoreCase(ubiEvent.getActionName())) {
                                clickthroughRate.logClick();
                            } else if ("impression".equalsIgnoreCase(ubiEvent.getActionName())) {
                                clickthroughRate.logImpression();
                            }
                            clickthroughRates.add(clickthroughRate);
                        }
                    }
                    this.checkBatchCompletion(pendingHits, hasError, response.getScrollId(), queriesToClickthroughRates, listener);
                }, e -> {
                    LOGGER.warn("Error processing user query for hit: " + hit.getId(), (Throwable)e);
                    hasError.set(true);
                    this.checkBatchCompletion(pendingHits, hasError, response.getScrollId(), queriesToClickthroughRates, listener);
                }));
            }
            catch (Exception e2) {
                LOGGER.warn("Error processing hit: " + hit.getId(), (Throwable)e2);
                hasError.set(true);
                this.checkBatchCompletion(pendingHits, hasError, response.getScrollId(), queriesToClickthroughRates, listener);
            }
        }
    }

    private void checkBatchCompletion(AtomicInteger pendingHits, AtomicBoolean hasError, String scrollId, Map<String, Set<ClickthroughRate>> queriesToClickthroughRates, ActionListener<Map<String, Set<ClickthroughRate>>> listener) {
        if (pendingHits.decrementAndGet() == 0) {
            if (hasError.get()) {
                listener.onFailure((Exception)new IllegalStateException("Error processing some hits in batch"));
            } else {
                this.scrollClickthroughRates(null, scrollId, queriesToClickthroughRates, listener);
            }
        }
    }

    private void getUserQuery(String queryId, ActionListener<String> listener) {
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder().query((QueryBuilder)QueryBuilders.termQuery((String)"query_id.keyword", (String)queryId)).size(1).fetchSource(new String[]{"user_query"}, null);
        SearchRequest searchRequest = new SearchRequest(new String[]{"ubi_queries"}).source(sourceBuilder);
        this.client.search(searchRequest, ActionListener.wrap(response -> {
            if (response.getHits().getHits().length > 0) {
                SearchHit hit = response.getHits().getHits()[0];
                Map source = hit.getSourceAsMap();
                listener.onResponse((Object)((String)source.get("user_query")));
            } else {
                listener.onResponse(null);
            }
        }, e -> {
            LOGGER.warn("Failed to get user query for queryId: " + queryId, (Throwable)e);
            listener.onResponse(null);
        }));
    }

    private void getQueryCount(String userQuery, String objectId, int rank, ActionListener<Long> listener) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)"action_name", (String)"impression")).must((QueryBuilder)QueryBuilders.termQuery((String)"event_attributes.position.ordinal", (int)rank)).must((QueryBuilder)QueryBuilders.termQuery((String)"event_attributes.object.object_id", (String)objectId));
        SearchSourceBuilder searchSourceBuilder = new SearchSourceBuilder().query((QueryBuilder)queryBuilder).trackTotalHits(true).size(0);
        SearchRequest searchRequest = new SearchRequest(new String[]{"ubi_events"}).source(searchSourceBuilder);
        this.client.search(searchRequest, ActionListener.wrap(response -> listener.onResponse((Object)response.getHits().getTotalHits().value()), arg_0 -> listener.onFailure(arg_0)));
    }

    private void calculateCoecJudgments(Map<Integer, Double> rankAggregatedClickThrough, Map<String, Set<ClickthroughRate>> clickthroughRates, ActionListener<List<Map<String, Object>>> listener) {
        LOGGER.debug("Starting COEC calculation with rank CTR: {}", rankAggregatedClickThrough);
        ArrayList judgmentRatings = new ArrayList();
        for (Map.Entry<String, Set<ClickthroughRate>> entry : clickthroughRates.entrySet()) {
            String userQuery = entry.getKey();
            HashMap<String, String> docScores = new HashMap<String, String>();
            for (ClickthroughRate ctr : entry.getValue()) {
                int observedRank = ctr.getRank();
                double expectedCtrForThisRank = rankAggregatedClickThrough.getOrDefault(observedRank, 0.0);
                double expectedClicksForDocAtRank = expectedCtrForThisRank * (double)ctr.getImpressions();
                double rating = expectedClicksForDocAtRank > 0.0 ? (double)ctr.getClicks() / expectedClicksForDocAtRank : 0.0;
                LOGGER.debug("judgment rating: {}, query: {}, doc: {}, rank: {}", (Object)rating, (Object)userQuery, (Object)ctr.getObjectId(), (Object)observedRank);
                docScores.put(ctr.getObjectId(), String.format(Locale.ROOT, "%.3f", rating));
            }
            if (!docScores.isEmpty()) {
                HashMap<String, Object> queryRating = new HashMap<String, Object>();
                queryRating.put("query", userQuery);
                queryRating.put("ratings", docScores);
                judgmentRatings.add(queryRating);
            }
            LOGGER.debug("Final judgment ratings size - Queries: {}, Total Documents: {}", (Object)judgmentRatings.size(), (Object)judgmentRatings.stream().mapToInt(item -> ((Map)item.get("ratings")).size()).sum());
        }
        LOGGER.debug("Final judgment ratings size - Queries: {}, Total Documents: {}", (Object)judgmentRatings.size(), (Object)judgmentRatings.stream().mapToInt(item -> ((Map)item.get("ratings")).size()).sum());
        listener.onResponse(judgmentRatings);
    }
}

