/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.osgi;

import aQute.bnd.http.HttpClient;
import aQute.bnd.osgi.FileResource;
import aQute.bnd.osgi.URLResource;
import aQute.bnd.osgi.ZipResource;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.CharBuffer;
import java.nio.file.Path;
import java.util.Locale;

public interface Resource
extends Closeable {
    public InputStream openInputStream() throws Exception;

    public void write(OutputStream var1) throws Exception;

    public long lastModified();

    public void setExtra(String var1);

    public String getExtra();

    public long size() throws Exception;

    public ByteBuffer buffer() throws Exception;

    public static Resource fromURL(URL url) throws IOException {
        return Resource.fromURL(url, null);
    }

    public static Resource fromURL(URL url, HttpClient client) throws IOException {
        URLResource.JarURLUtil util;
        URL jarFileURL;
        String protocol = url.getProtocol().toLowerCase(Locale.ROOT);
        if (protocol.equals("file")) {
            URI uri = URI.create(url.toExternalForm());
            Path path = new File(uri.getSchemeSpecificPart()).toPath().toAbsolutePath();
            return new FileResource(path);
        }
        if (protocol.equals("jar") && (jarFileURL = (util = new URLResource.JarURLUtil(url)).getJarFileURL()).getProtocol().equalsIgnoreCase("file")) {
            URI uri = URI.create(jarFileURL.toExternalForm());
            Path path = new File(uri.getSchemeSpecificPart()).toPath().toAbsolutePath();
            String entryName = util.getEntryName();
            if (entryName == null) {
                return new FileResource(path);
            }
            return new ZipResource(path, entryName);
        }
        return new URLResource(url, protocol.equals("jrt") ? null : client);
    }

    public static String encodeExtra(byte[] extra) {
        int length = extra.length;
        if (length > 65535) {
            throw new IllegalArgumentException("extra data too long");
        }
        ByteBuffer bb = ByteBuffer.allocate(2 + length + length % 2).order(ByteOrder.LITTLE_ENDIAN);
        CharBuffer cb = bb.asCharBuffer();
        bb.putShort((short)length);
        bb.put(extra, 0, length);
        return cb.toString();
    }

    public static byte[] decodeExtra(String encoded) {
        ByteBuffer bb = ByteBuffer.allocate(encoded.length() * 2).order(ByteOrder.LITTLE_ENDIAN);
        CharBuffer cb = bb.asCharBuffer();
        cb.put(encoded);
        int length = Short.toUnsignedInt(bb.getShort());
        if (length != bb.remaining() - length % 2) {
            throw new IllegalArgumentException("invalid encoding");
        }
        byte[] extra = new byte[length];
        bb.get(extra, 0, length);
        return extra;
    }
}

