/*
 * Decompiled with CFR 0.152.
 */
package org.apache.aries.jax.rs.whiteboard.internal.utils;

import java.util.Collection;
import java.util.Comparator;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.aries.component.dsl.CachingServiceReference;
import org.apache.aries.component.dsl.OSGi;
import org.apache.aries.jax.rs.whiteboard.internal.utils.LogUtils;
import org.apache.aries.jax.rs.whiteboard.internal.utils.PropertyHolder;
import org.apache.aries.jax.rs.whiteboard.internal.utils.ServiceTuple;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;

public class Utils {
    public static String[] canonicalize(Object propertyValue) {
        if (propertyValue == null) {
            return new String[0];
        }
        if (propertyValue instanceof String[]) {
            return (String[])propertyValue;
        }
        if (propertyValue instanceof Collection) {
            return (String[])((Collection)propertyValue).stream().map(Object::toString).toArray(String[]::new);
        }
        return new String[]{propertyValue.toString()};
    }

    public static String canonicalizeAddress(String address) {
        if (address == null) {
            return "";
        }
        if (address.length() == 0) {
            return address;
        }
        if (!address.startsWith("/")) {
            address = "/" + address;
        }
        if (address.endsWith("/")) {
            address = address.substring(0, address.length() - 1);
        }
        return address;
    }

    public static String generateApplicationName(PropertyHolder propertyHolder) {
        return ".generated.for." + propertyHolder.get("service.id");
    }

    public static Map<String, Object> getApplicationProperties(CachingServiceReference<?> reference) {
        Map<String, Object> properties = Utils.getProperties(reference);
        properties.putIfAbsent("osgi.jaxrs.name", Utils.generateApplicationName(arg_0 -> reference.getProperty(arg_0)));
        return properties;
    }

    public static Map<String, Object> getProperties(CachingServiceReference<?> sref) {
        String[] propertyKeys = sref.getPropertyKeys();
        HashMap<String, Object> properties = new HashMap<String, Object>(propertyKeys.length);
        for (String key : propertyKeys) {
            properties.put(key, sref.getProperty(key));
        }
        return properties;
    }

    public static Map<String, Object> getProperties(ServiceReference<?> sref) {
        String[] propertyKeys = sref.getPropertyKeys();
        HashMap<String, Object> properties = new HashMap<String, Object>(propertyKeys.length);
        for (String key : propertyKeys) {
            properties.put(key, sref.getProperty(key));
        }
        return properties;
    }

    public static String getString(Object string) {
        if (string == null) {
            return "";
        }
        return String.valueOf(string);
    }

    public static <K, T extends Comparable<? super T>> OSGi<T> highestPer(Function<T, OSGi<K>> keySupplier, OSGi<T> program, Consumer<? super T> onAddingShadowed, Consumer<? super T> onRemovedShadowed) {
        return program.splitBy(keySupplier, (__, p) -> org.apache.aries.component.dsl.Utils.highest((OSGi)p, Comparator.naturalOrder(), discards -> discards.effects(onAddingShadowed, onRemovedShadowed).then(OSGi.nothing())));
    }

    public static boolean isAvailable(ServiceReference<?> serviceReference) {
        Bundle bundle = serviceReference.getBundle();
        if (bundle == null) {
            return false;
        }
        for (ServiceReference registeredService : bundle.getRegisteredServices()) {
            if (!registeredService.equals(serviceReference)) continue;
            return true;
        }
        return false;
    }

    public static void mergePropertyMaps(Map<String, Object> receptor, Map<String, ?> map) {
        for (Map.Entry<String, ?> entry : map.entrySet()) {
            String key = entry.getKey();
            if (key.startsWith(".")) continue;
            receptor.putIfAbsent(key, entry.getValue());
        }
    }

    public static <T> OSGi<ServiceTuple<T>> onlyGettables(OSGi<CachingServiceReference<T>> program, Consumer<CachingServiceReference<T>> whenAddedNotGettable, Consumer<CachingServiceReference<T>> whenLeavingNotGettable, Logger log) {
        return OSGi.bundleContext().flatMap(bundleContext -> program.recoverWith((serviceReference, e) -> Utils.notGettableResult(whenAddedNotGettable, whenLeavingNotGettable, serviceReference, log)).flatMap(serviceReference -> {
            ServiceObjects serviceObjects = bundleContext.getServiceObjects(serviceReference.getServiceReference());
            Object service = serviceObjects.getService();
            if (service == null) {
                return Utils.notGettableResult(whenAddedNotGettable, whenLeavingNotGettable, serviceReference, log);
            }
            return OSGi.just(new ServiceTuple<Object>((CachingServiceReference<Object>)serviceReference, (ServiceObjects<Object>)serviceObjects, service)).effects(__ -> {}, ServiceTuple::dispose).effects(LogUtils.ifDebugEnabled(log, () -> "Obtained instance from " + serviceReference), LogUtils.ifDebugEnabled(log, () -> "Released instance from " + serviceReference));
        }));
    }

    public static <T> OSGi<T> service(CachingServiceReference<T> immutableServiceReference) {
        ServiceReference serviceReference = immutableServiceReference.getServiceReference();
        return OSGi.bundleContext().flatMap(bundleContext -> OSGi.effects(() -> {}, () -> bundleContext.ungetService(serviceReference)).then(OSGi.just((Object)bundleContext.getService(serviceReference))));
    }

    public static void updateProperty(ServiceRegistration<?> serviceRegistration, String key, Object value) {
        CachingServiceReference serviceReference = new CachingServiceReference(serviceRegistration.getReference());
        Hashtable<String, Object> properties = new Hashtable<String, Object>();
        for (String propertyKey : serviceReference.getPropertyKeys()) {
            ((Dictionary)properties).put(propertyKey, serviceReference.getProperty(propertyKey));
        }
        ((Dictionary)properties).put(key, value);
        serviceRegistration.setProperties(properties);
    }

    private static <T, S> OSGi<S> notGettableResult(Consumer<CachingServiceReference<T>> whenAddedNotGettable, Consumer<CachingServiceReference<T>> whenLeavingNotGettable, CachingServiceReference<T> immutable, Logger log) {
        return OSGi.effects(() -> whenAddedNotGettable.accept(immutable), () -> whenLeavingNotGettable.accept(immutable)).effects(LogUtils.ifDebugEnabled(log, () -> "Tracked not gettable reference {}"), LogUtils.ifDebugEnabled(log, () -> "Untracked not gettable reference {}")).then(OSGi.nothing());
    }
}

