/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.query;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.commons.LinkButton;
import org.netbeans.modules.bugtracking.commons.NBBugzillaUtils;
import org.netbeans.modules.bugtracking.commons.NoContentPanel;
import org.netbeans.modules.bugtracking.commons.SaveQueryPanel;
import org.netbeans.modules.bugtracking.commons.UIUtils;
import org.netbeans.modules.bugtracking.spi.QueryController;
import org.netbeans.modules.bugtracking.team.TeamRepositories;
import org.netbeans.modules.bugtracking.ui.query.Bundle;
import org.netbeans.modules.bugtracking.ui.query.RepoSelectorPanel;
import org.netbeans.modules.bugtracking.ui.repository.RepositoryComboSupport;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.team.spi.OwnerInfo;
import org.netbeans.modules.team.spi.TeamAccessorUtils;
import org.netbeans.modules.team.spi.TeamProject;
import org.netbeans.spi.actions.AbstractSavable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Cancellable;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class QueryTopComponent
extends TopComponent
implements PropertyChangeListener,
FocusListener {
    private static QueryTopComponent instance;
    private static final Set<QueryTopComponent> openQueries;
    private final RepoSelectorPanel repoPanel;
    private final LinkButton newButton;
    private final JComboBox repositoryComboBox;
    private static final String PREFERRED_ID = "QueryTopComponent";
    private QueryImpl query;
    private final RequestProcessor rp = new RequestProcessor("Bugtracking query", 1, true);
    private RequestProcessor.Task prepareTask;
    private RepositoryComboSupport rs;
    private File context;
    private QueryController.QueryMode mode;
    private final InstanceContent instanceContent = new InstanceContent();
    private JPanel headerPanel;
    private JScrollPane jScrollPane1;
    private JPanel leftRepoPanel;
    private JPanel mainPanel;
    private JPanel queryPanel;
    private JLabel title;

    QueryTopComponent() {
        this.initComponents();
        this.instanceContent.add((Object)this.getActionMap());
        this.associateLookup((Lookup)new AbstractLookup((AbstractLookup.Content)this.instanceContent));
        RepositoryRegistry.getInstance().addPropertyChangeListener(this);
        this.repositoryComboBox = new JComboBox();
        this.newButton = new LinkButton();
        Font titleFont = this.title.getFont();
        this.title.setFont(titleFont.deriveFont(1.7f * (float)titleFont.getSize()));
        this.title.setBorder(BorderFactory.createEmptyBorder(0, QueryTopComponent.getLeftContainerGap(this.title), 0, 0));
        this.leftRepoPanel.setVisible(false);
        this.repoPanel = new RepoSelectorPanel(this.repositoryComboBox, (JComponent)this.newButton);
        GroupLayout layout = (GroupLayout)this.headerPanel.getLayout();
        this.leftRepoPanel.setVisible(true);
        layout.replace(this.leftRepoPanel, this.repoPanel);
        Mnemonics.setLocalizedText((JLabel)this.title, (String)QueryTopComponent.getBundleText("QueryTopComponent.findIssuesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)QueryTopComponent.getBundleText("QueryTopComponent.newButton.text_1"));
        this.repositoryComboBox.getAccessibleContext().setAccessibleDescription(QueryTopComponent.getBundleText("QueryTopComponent.repositoryComboBox.AccessibleContext.accessibleDescription"));
        this.newButton.getAccessibleContext().setAccessibleDescription(QueryTopComponent.getBundleText("QueryTopComponent.newButton.AccessibleContext.accessibleDescription"));
        this.newButton.setEnabled(BugtrackingManager.getInstance().hasRegisteredConnectors());
        Color editorBgColor = UIManager.getDefaults().getColor("EditorPane.background");
        this.repoPanel.setBackground(editorBgColor);
        this.headerPanel.setBackground(editorBgColor);
        this.queryPanel.setBackground(editorBgColor);
        this.mainPanel.setBackground(editorBgColor);
        this.repoPanel.setNextFocusableComponent((Component)this.newButton);
        int unitIncrement = (int)(1.5f * (float)titleFont.getSize() + 0.5f);
        this.jScrollPane1.getHorizontalScrollBar().setUnitIncrement(unitIncrement);
        this.jScrollPane1.getVerticalScrollBar().setUnitIncrement(unitIncrement);
    }

    private static int getLeftContainerGap(JComponent comp) {
        LayoutStyle layoutStyle = LayoutStyle.getInstance();
        return layoutStyle.getContainerGap(comp, 7, null);
    }

    public QueryImpl getQuery() {
        return this.query;
    }

    void setMode(QueryController.QueryMode mode) {
        this.mode = mode;
        QueryController c = this.getController(this.query);
        this.addQueryComponent(c);
    }

    void init(QueryImpl query, RepositoryImpl defaultRepository, File context, boolean suggestedSelectionOnly, QueryController.QueryMode mode, boolean isNew) {
        this.query = query;
        this.context = context;
        this.mode = mode;
        this.setNameAndTooltip();
        if (suggestedSelectionOnly) {
            this.repositoryComboBox.setEnabled(false);
            this.newButton.setVisible(false);
        }
        if (query != null) {
            if (!isNew) {
                TeamProject teamProject;
                RepositoryImpl repoImpl = query.getRepositoryImpl();
                if (repoImpl.isTeamRepository() && (teamProject = TeamRepositories.getInstance().getTeamProject(defaultRepository)) != null) {
                    this.instanceContent.add((Object)query.getQuery());
                    this.instanceContent.add((Object)teamProject);
                }
                this.setSaved();
            } else if (!suggestedSelectionOnly) {
                this.rs = RepositoryComboSupport.setup((JComponent)((Object)this), this.repositoryComboBox, defaultRepository.getRepository());
            }
            QueryController c = this.getController(query);
            this.addQueryComponent(c);
            this.registerListeners();
        } else {
            this.newButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryTopComponent.this.onNewClick();
                }
            });
            this.repositoryComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Object item;
                    if (e.getStateChange() == 1) {
                        Object item2 = e.getItem();
                        if (item2 instanceof Repository) {
                            QueryTopComponent.this.onRepoSelected();
                        }
                    } else if (e.getStateChange() == 2 && (item = e.getItem()) instanceof Repository) {
                        ((Repository)item).removePropertyChangeListener(QueryTopComponent.this);
                    }
                }
            });
            NoContentPanel ncp = new NoContentPanel();
            if (defaultRepository == null) {
                this.rs = RepositoryComboSupport.setup((JComponent)((Object)this), this.repositoryComboBox, true);
                ncp.setText(Bundle.LBL_NoRepositorySelected());
            } else {
                this.rs = RepositoryComboSupport.setup((JComponent)((Object)this), this.repositoryComboBox, defaultRepository.getRepository());
                ncp.setText(Bundle.LBL_RepositoryInit());
            }
            this.queryPanel.add((Component)ncp);
            this.rs.setLocalRepositoryHidden(true);
            this.newButton.addFocusListener((FocusListener)this);
            this.repositoryComboBox.addFocusListener(this);
        }
    }

    private void registerListeners() {
        this.unregisterListeners();
        this.query.addPropertyChangeListener(this);
        this.query.getController().addPropertyChangeListener(this);
        this.query.getRepositoryImpl().addPropertyChangeListener(this);
    }

    private void unregisterListeners() {
        this.query.removePropertyChangeListener(this);
        this.query.getController().removePropertyChangeListener(this);
        this.query.getRepositoryImpl().removePropertyChangeListener(this);
    }

    private QueryController getController(QueryImpl query) {
        return query.getController();
    }

    private static String getBundleText(String key) {
        return NbBundle.getMessage(QueryTopComponent.class, (String)key);
    }

    public static synchronized QueryTopComponent getDefault() {
        if (instance == null) {
            instance = new QueryTopComponent();
        }
        return instance;
    }

    public static synchronized QueryTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(QueryTopComponent.class.getName()).warning("Cannot find QueryTopComponent component. It will not be located properly in the window system.");
            return QueryTopComponent.getDefault();
        }
        if (win instanceof QueryTopComponent) {
            return (QueryTopComponent)win;
        }
        Logger.getLogger(QueryTopComponent.class.getName()).warning("There seem to be multiple components with the 'QueryTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return QueryTopComponent.getDefault();
    }

    public static synchronized QueryTopComponent find(QueryImpl query) {
        QueryTopComponent[] tcs;
        for (QueryTopComponent tc : tcs = QueryTopComponent.getOpenQueries()) {
            if (!query.equals(tc.getQuery())) continue;
            return tc;
        }
        return null;
    }

    public static void closeFor(RepositoryImpl repo) {
        QueryTopComponent[] tcs;
        for (QueryTopComponent itc : tcs = QueryTopComponent.getOpenQueries()) {
            RepositoryImpl tcRepo;
            QueryImpl tcQuery = itc.getQuery();
            if (tcQuery == null || !(tcRepo = tcQuery.getRepositoryImpl()).getId().equals(repo.getId()) || !tcRepo.getConnectorId().equals(repo.getConnectorId())) continue;
            itc.closeInAwt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QueryTopComponent[] getOpenQueries() {
        QueryTopComponent[] tcs;
        Set<QueryTopComponent> set = openQueries;
        synchronized (set) {
            tcs = openQueries.toArray(new QueryTopComponent[0]);
        }
        return tcs;
    }

    public int getPersistenceType() {
        return 2;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("o.n.m.bugtracking.ui.query.QueryTopComponent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentOpened() {
        Set<QueryTopComponent> set = openQueries;
        synchronized (set) {
            openQueries.add(this);
        }
        if (this.query != null) {
            this.getController(this.query).opened();
        }
        BugtrackingManager.LOG.log(Level.FINE, "{0} - {1} opened", new Object[]{this.getClass().getName(), this.query != null ? this.query.getDisplayName() : null});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void componentClosed() {
        Set<QueryTopComponent> set = openQueries;
        synchronized (set) {
            openQueries.remove(this);
        }
        RepositoryRegistry.getInstance().removePropertyChangeListener(this);
        if (this.query != null) {
            this.releaseQuery(!this.isSaved());
        }
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        BugtrackingManager.LOG.log(Level.FINE, "{0} - {1} closed", new Object[]{this.getClass().getName(), this.query != null ? this.query.getDisplayName() : null});
    }

    private void releaseQuery(boolean remove) {
        if (this.query != null) {
            this.unregisterListeners();
            this.getController(this.query).closed();
            if (remove) {
                this.query = null;
            }
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return this.query != null && this.query.getDisplayName() != null ? this.query.getDisplayName() : PREFERRED_ID;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("bugtracking.repository.queries.changed")) {
            if (this.query != null && this.isSaved()) {
                Collection<QueryImpl> queries = this.query.getRepositoryImpl().getQueries();
                boolean stillExists = false;
                for (QueryImpl q : queries) {
                    if (!q.getDisplayName().equals(this.query.getDisplayName())) continue;
                    stillExists = true;
                    break;
                }
                if (!stillExists) {
                    this.queryRemoved();
                }
            }
        } else if (evt.getPropertyName().equals("bugtracking.repositories.changed")) {
            if (this.query != null) {
                Object cOld = evt.getOldValue();
                if (cOld instanceof Collection) {
                    RepositoryImpl thisRepo = this.query.getRepositoryImpl();
                    if (this.contains((Collection)cOld, thisRepo)) {
                        this.queryRemoved();
                    }
                } else if (cOld == null) {
                    RepositoryImpl thisRepo = this.query.getRepositoryImpl();
                    Collection<RepositoryImpl> knownRepos = RepositoryRegistry.getInstance().getKnownRepositories(true);
                    if (!this.contains(knownRepos, thisRepo)) {
                        this.queryRemoved();
                    }
                }
            }
            if (!this.repositoryComboBox.isEnabled()) {
                return;
            }
            UIUtils.runInAWT((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (QueryTopComponent.this.rs != null) {
                        QueryTopComponent.this.rs.refreshRepositoryModel();
                    }
                }
            });
        } else if (evt.getPropertyName().equals("bugtracking.query.changed")) {
            Object o = evt.getNewValue();
            boolean changed = o instanceof Boolean ? ((Boolean)o).booleanValue() : this.getController(this.query).isChanged();
            if (changed) {
                if (this.getLookup().lookup(QuerySavable.class) == null) {
                    this.instanceContent.add((Object)new QuerySavable(this));
                    this.setNameAndTooltip();
                }
            } else {
                QuerySavable savable;
                String qn = this.query.getDisplayName();
                if (qn != null && !"".equals(qn.trim()) && !this.isSaved()) {
                    this.openDashboard();
                    this.setSaved();
                }
                if ((savable = this.getSavable()) != null) {
                    savable.destroy();
                    this.setNameAndTooltip();
                }
            }
        }
    }

    private void queryRemoved() {
        this.closeInAwt();
        this.releaseQuery(true);
    }

    private void openDashboard() {
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                TopComponent tc = WindowManager.getDefault().findTopComponent("DashboardTopComponent");
                if (tc == null) {
                    BugtrackingManager.LOG.fine("No Tasks Dashboard found");
                    return;
                }
                tc.open();
                tc.requestActive();
            }
        });
    }

    private QuerySavable getSavable() {
        return (QuerySavable)((Object)this.getLookup().lookup(QuerySavable.class));
    }

    private boolean contains(Collection c, RepositoryImpl r) {
        for (Object o : c) {
            assert (o instanceof RepositoryImpl);
            if (!((RepositoryImpl)o).getId().equals(r.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean canClose() {
        QuerySavable savable;
        if (this.query != null && (savable = this.getSavable()) != null) {
            JButton save = new JButton(Bundle.CTL_Save());
            JButton discard = new JButton(Bundle.CTL_Discard());
            NotifyDescriptor nd = new NotifyDescriptor((Object)Bundle.MSG_HasChanges(QueryTopComponent.getFQQueryName(this.query)), Bundle.LBL_Question(), 1, 1, new Object[]{save, discard, NotifyDescriptor.CANCEL_OPTION}, null);
            Object ret = DialogDisplayer.getDefault().notify(nd);
            boolean canClose = false;
            if (ret == save) {
                canClose = this.save();
            } else if (ret == discard) {
                canClose = this.query.getController().discardUnsavedChanges();
            }
            if (canClose) {
                savable.destroy();
            }
            return canClose;
        }
        return super.canClose();
    }

    private boolean save() {
        String newName = null;
        if (this.query.getDisplayName() == null && (newName = SaveQueryPanel.show((SaveQueryPanel.QueryNameValidator)new SaveQueryPanel.QueryNameValidator(){

            public String isValid(String name) {
                Collection<QueryImpl> queries = QueryTopComponent.this.query.getRepositoryImpl().getQueries();
                for (QueryImpl q : queries) {
                    if (!name.equals(q.getDisplayName())) continue;
                    return NbBundle.getMessage(QueryTopComponent.class, (String)"MSG_SAME_NAME");
                }
                return null;
            }
        }, null)) == null) {
            return false;
        }
        return this.query.getController().saveChanges(newName);
    }

    @Override
    public void focusGained(FocusEvent e) {
        Component c = e.getComponent();
        if (c instanceof JComponent) {
            Point p = SwingUtilities.convertPoint(c.getParent(), c.getLocation(), this.repoPanel);
            final Rectangle r = new Rectangle(p, c.getSize());
            UIUtils.runInAWT((Runnable)new Runnable(){

                @Override
                public void run() {
                    QueryTopComponent.this.repoPanel.scrollRectToVisible(r);
                }
            });
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private void closeInAwt() {
        UIUtils.runInAWT((Runnable)new Runnable(){

            @Override
            public void run() {
                QueryTopComponent.this.close();
            }
        });
    }

    private void onNewClick() {
        RepositoryImpl repoImpl = BugtrackingUtil.createRepository();
        if (repoImpl != null) {
            Repository repo = repoImpl.getRepository();
            this.repositoryComboBox.addItem(repo);
            this.repositoryComboBox.setSelectedItem(repo);
        }
    }

    private void onRepoSelected() {
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        Cancellable c = new Cancellable(){

            public boolean cancel() {
                if (QueryTopComponent.this.prepareTask != null) {
                    QueryTopComponent.this.prepareTask.cancel();
                }
                return true;
            }
        };
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(QueryTopComponent.class, (String)"CTL_PreparingQuery"), (Cancellable)c);
        this.prepareTask = this.rp.post(new Runnable(){

            @Override
            public void run() {
                try {
                    OwnerInfo ownerInfo;
                    handle.start();
                    RepositoryImpl repo = QueryTopComponent.this.getRepository();
                    if (repo == null) {
                        return;
                    }
                    repo.removePropertyChangeListener(QueryTopComponent.this);
                    repo.addPropertyChangeListener(QueryTopComponent.this);
                    if (QueryTopComponent.this.query != null) {
                        QueryTopComponent.this.unregisterListeners();
                    }
                    QueryTopComponent.this.query = repo.createNewQuery();
                    if (QueryTopComponent.this.query == null) {
                        return;
                    }
                    if (QueryTopComponent.this.context != null && NBBugzillaUtils.isNbRepository((String)repo.getUrl()) && (ownerInfo = TeamAccessorUtils.getOwnerInfo((File)QueryTopComponent.this.context)) != null) {
                        QueryTopComponent.this.query.setContext(ownerInfo);
                    }
                    QueryTopComponent.this.registerListeners();
                    final QueryController addController = QueryTopComponent.this.getController(QueryTopComponent.this.query);
                    UIUtils.runInAWT((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            QueryTopComponent.this.addQueryComponent(addController);
                            QueryTopComponent.this.focusFirstEnabledComponent();
                        }
                    });
                }
                finally {
                    handle.finish();
                    QueryTopComponent.this.prepareTask = null;
                }
            }
        });
    }

    private void addQueryComponent(QueryController controller) {
        JComponent cmp = controller.getComponent(this.mode != null ? this.mode : QueryController.QueryMode.EDIT);
        this.queryPanel.removeAll();
        this.queryPanel.add(cmp);
        controller.opened();
    }

    private RepositoryImpl getRepository() {
        Object item = this.repositoryComboBox.getSelectedItem();
        if (!(item instanceof Repository)) {
            return null;
        }
        return APIAccessor.IMPL.getImpl((Repository)item);
    }

    private void focusFirstEnabledComponent() {
        this.repositoryComboBox.requestFocusInWindow();
        if (!this.repositoryComboBox.isEnabled()) {
            this.newButton.requestFocusInWindow();
            if (!this.newButton.isEnabled()) {
                this.newButton.transferFocus();
            }
        }
    }

    private void setNameAndTooltip() throws MissingResourceException {
        UIUtils.runInAWT((Runnable)new Runnable(){

            @Override
            public void run() {
                if (QueryTopComponent.this.query != null && QueryTopComponent.this.query.getDisplayName() != null) {
                    String name = QueryTopComponent.getFQQueryName(QueryTopComponent.this.query);
                    if (QueryTopComponent.this.getSavable() != null) {
                        name = "<html><b>" + name + "</b></html>";
                    }
                    QueryTopComponent.this.setName(name);
                    QueryTopComponent.this.setToolTipText(NbBundle.getMessage(QueryTopComponent.class, (String)"LBL_QueryName", (Object[])new Object[]{QueryTopComponent.this.query.getRepositoryImpl().getDisplayName(), QueryTopComponent.this.query.getTooltip()}));
                } else {
                    QueryTopComponent.this.setName(NbBundle.getMessage(QueryTopComponent.class, (String)"CTL_QueryTopComponent"));
                    QueryTopComponent.this.setToolTipText(NbBundle.getMessage(QueryTopComponent.class, (String)"HINT_QueryTopComponent"));
                }
            }
        });
    }

    private static String getFQQueryName(QueryImpl query) throws MissingResourceException {
        String repoName = query.getRepositoryImpl().getDisplayName();
        String queryName = query.getDisplayName();
        if (queryName != null) {
            return NbBundle.getMessage(QueryTopComponent.class, (String)"LBL_QueryName", (Object[])new Object[]{repoName, queryName});
        }
        return NbBundle.getMessage(QueryTopComponent.class, (String)"LBL_UnsavedQuery", (Object[])new Object[]{repoName});
    }

    private void setSaved() {
        UIUtils.runInAWT((Runnable)new Runnable(){

            @Override
            public void run() {
                QueryTopComponent.this.headerPanel.setVisible(false);
                QueryTopComponent.this.mainPanel.revalidate();
                QueryTopComponent.this.mainPanel.repaint();
                QueryTopComponent.this.setNameAndTooltip();
            }
        });
    }

    private boolean isSaved() {
        return !this.headerPanel.isVisible();
    }

    public boolean requestFocusInWindow() {
        return this.mainPanel.requestFocusInWindow();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.mainPanel = new JPanel();
        this.headerPanel = new JPanel();
        this.title = new JLabel();
        this.leftRepoPanel = new JPanel();
        this.queryPanel = new JPanel();
        Mnemonics.setLocalizedText((JLabel)this.title, (String)NbBundle.getMessage(QueryTopComponent.class, (String)"QueryTopComponent.findIssuesLabel.text"));
        this.leftRepoPanel.setOpaque(false);
        GroupLayout leftRepoPanelLayout = new GroupLayout(this.leftRepoPanel);
        this.leftRepoPanel.setLayout(leftRepoPanelLayout);
        leftRepoPanelLayout.setHorizontalGroup(leftRepoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 66, Short.MAX_VALUE));
        leftRepoPanelLayout.setVerticalGroup(leftRepoPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 16, Short.MAX_VALUE));
        GroupLayout headerPanelLayout = new GroupLayout(this.headerPanel);
        this.headerPanel.setLayout(headerPanelLayout);
        headerPanelLayout.setHorizontalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addComponent(this.title).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 203, Short.MAX_VALUE).addComponent(this.leftRepoPanel, -2, -1, -2).addContainerGap()));
        headerPanelLayout.setVerticalGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(headerPanelLayout.createSequentialGroup().addContainerGap().addGroup(headerPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.leftRepoPanel, -2, -1, -2).addComponent(this.title)).addContainerGap()));
        this.queryPanel.setLayout(new BorderLayout());
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.headerPanel, -1, -1, Short.MAX_VALUE).addComponent(this.queryPanel, -1, -1, Short.MAX_VALUE));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(mainPanelLayout.createSequentialGroup().addComponent(this.headerPanel, -2, -1, -2).addGap(0, 0, 0).addComponent(this.queryPanel, -1, 222, Short.MAX_VALUE)));
        this.jScrollPane1.setViewportView(this.mainPanel);
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
    }

    static {
        openQueries = new HashSet<QueryTopComponent>();
    }

    private static class QuerySavable
    extends AbstractSavable {
        private final QueryTopComponent tc;

        QuerySavable(QueryTopComponent tc) {
            this.tc = tc;
            this.register();
        }

        protected String findDisplayName() {
            if (this.tc.query != null) {
                return QueryTopComponent.getFQQueryName(this.tc.query);
            }
            return this.tc.getName();
        }

        protected void handleSave() throws IOException {
            if (this.tc.query != null) {
                this.tc.save();
            }
        }

        void destroy() {
            this.tc.instanceContent.remove((Object)this);
            this.unregister();
        }

        public boolean equals(Object obj) {
            if (obj instanceof QuerySavable) {
                return this.tc == ((QuerySavable)((Object)obj)).tc;
            }
            return false;
        }

        public int hashCode() {
            return this.tc.hashCode();
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return QueryTopComponent.getDefault();
        }
    }
}

