/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.palette;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JWindow;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;

public class ScrollPopupMenu
extends JPopupMenu {
    JWindow popWin;
    JScrollPane scrollPane;
    int posX;
    int posY;
    int maxHeight;

    ScrollPopupMenu(int maxH) {
        this.maxHeight = maxH;
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible == this.isVisible()) {
            return;
        }
        if (visible) {
            if (this.getInvoker() != null && !(this.getInvoker() instanceof JMenu)) {
                if (this.getSubElements().length > 0) {
                    me = new MenuElement[]{this, this.getSubElements()[0]};
                    MenuSelectionManager.defaultManager().setSelectedPath(me);
                } else {
                    me = new MenuElement[]{this};
                    MenuSelectionManager.defaultManager().setSelectedPath(me);
                }
            }
            this.firePopupMenuWillBecomeVisible();
            Component comp = this.getInvoker();
            while (comp.getParent() != null) {
                comp = comp.getParent();
            }
            this.popWin = comp instanceof Window ? new JWindow((Window)comp) : new JWindow(new JFrame());
            this.popWin.setLocation(this.posX, this.posY);
            this.pack();
            this.popWin.setVisible(true);
        } else {
            this.getSelectionModel().clearSelection();
            if (this.popWin != null) {
                this.firePopupMenuWillBecomeInvisible();
                this.popWin.dispose();
                this.popWin = null;
                this.scrollPane = null;
            }
        }
    }

    @Override
    public boolean isVisible() {
        return this.popWin != null ? this.popWin.isShowing() : false;
    }

    @Override
    public void setLocation(int x, int y) {
        if (this.popWin != null && this.popWin.isShowing()) {
            this.popWin.setLocation(x, y);
        } else {
            this.posX = x;
            this.posY = y;
        }
    }

    @Override
    public void pack() {
        if (this.popWin == null) {
            return;
        }
        Dimension prefSize = this.getPreferredSize();
        if (this.maxHeight == 0 || prefSize.height <= this.maxHeight) {
            if (this.scrollPane != null) {
                this.popWin.getContentPane().remove(this.scrollPane);
                this.scrollPane = null;
            }
            this.popWin.getContentPane().setLayout(null);
            this.popWin.getContentPane().add(this);
            this.setBounds(0, 0, prefSize.width, prefSize.height);
            this.popWin.setSize(prefSize.width, prefSize.height);
        } else {
            if (this.scrollPane == null) {
                JPanel view = new JPanel(new BorderLayout());
                view.add((Component)this, "Center");
                this.scrollPane = new JScrollPane(view);
                this.scrollPane.setHorizontalScrollBarPolicy(31);
                JScrollBar bar = this.scrollPane.getVerticalScrollBar();
                if (bar != null) {
                    Dimension d = bar.getPreferredSize();
                    d.width = 12;
                    bar.setPreferredSize(d);
                    bar.setUnitIncrement(21);
                }
                this.popWin.getContentPane().add((Component)this.scrollPane, "Center");
            }
            this.popWin.pack();
            this.popWin.setSize(this.popWin.getSize().width + 12, this.maxHeight);
            this.requestFocus();
        }
    }

    public JScrollPane getScrollPane() {
        return this.scrollPane;
    }

    public JScrollBar getScrollBar() {
        return this.scrollPane != null ? this.scrollPane.getVerticalScrollBar() : null;
    }
}

