/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.editor.document;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.document.DocumentServices;
import org.netbeans.modules.editor.document.TextSearchUtils;
import org.netbeans.modules.editor.document.implspi.CharClassifier;
import org.netbeans.spi.editor.document.DocumentFactory;
import org.openide.util.Lookup;

public final class LineDocumentUtils {
    private static final Object NOT_FOUND = new Object();

    private LineDocumentUtils() {
    }

    @Deprecated
    public static int getLineStart(@NonNull LineDocument doc, int offset) {
        return doc.getParagraphElement(offset).getStartOffset();
    }

    @Deprecated
    public static int getLineEnd(@NonNull LineDocument doc, int offset) throws BadLocationException {
        return LineDocumentUtils.getLineEndOffset(doc, offset);
    }

    public static int getLineStartOffset(@NonNull LineDocument doc, int offset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        return doc.getParagraphElement(offset).getStartOffset();
    }

    public static int getLineEndOffset(@NonNull LineDocument doc, int offset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        return doc.getParagraphElement(offset).getEndOffset() - 1;
    }

    public static int getLineFirstNonWhitespace(@NonNull LineDocument doc, int offset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        CharClassifier classifier = LineDocumentUtils.getValidClassifier(doc);
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        Element lineElement = doc.getParagraphElement(offset);
        return TextSearchUtils.getNextNonWhitespace(docText, classifier, lineElement.getStartOffset(), lineElement.getEndOffset() - 1);
    }

    public static int getLineLastNonWhitespace(@NonNull LineDocument doc, int offset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        CharClassifier classifier = LineDocumentUtils.getValidClassifier(doc);
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        Element lineElement = doc.getParagraphElement(offset);
        return TextSearchUtils.getPreviousNonWhitespace(docText, classifier, lineElement.getEndOffset() - 1, lineElement.getStartOffset());
    }

    public static int getWordStart(@NonNull LineDocument doc, int offset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        CharClassifier classifier = LineDocumentUtils.getValidClassifier(doc);
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        return TextSearchUtils.getWordStart(docText, classifier, offset);
    }

    public static int getWordEnd(@NonNull LineDocument doc, int offset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        CharClassifier classifier = LineDocumentUtils.getValidClassifier(doc);
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        return TextSearchUtils.getWordEnd(docText, classifier, offset);
    }

    public static String getWord(@NonNull LineDocument doc, int wordStartOffset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, wordStartOffset);
        CharClassifier classifier = LineDocumentUtils.getValidClassifier(doc);
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        return TextSearchUtils.getWord(docText, classifier, wordStartOffset).toString();
    }

    public static int getNextWordStart(@NonNull LineDocument doc, int offset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        CharClassifier classifier = LineDocumentUtils.getValidClassifier(doc);
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        return TextSearchUtils.getNextWordStart(docText, classifier, offset);
    }

    public static int getPreviousWordEnd(@NonNull LineDocument doc, int offset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        CharClassifier classifier = LineDocumentUtils.getValidClassifier(doc);
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        return TextSearchUtils.getPreviousWordEnd(docText, classifier, offset);
    }

    public static int getPreviousWordStart(@NonNull LineDocument doc, int offset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        CharClassifier classifier = LineDocumentUtils.getValidClassifier(doc);
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        return TextSearchUtils.getPreviousWordStart(docText, classifier, offset);
    }

    public static int getNextWhitespace(@NonNull LineDocument doc, int offset) throws BadLocationException {
        return LineDocumentUtils.getNextWhitespace(doc, offset, doc.getLength() + 1);
    }

    public static int getNextWhitespace(@NonNull LineDocument doc, int offset, int limitOffset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        CharClassifier classifier = LineDocumentUtils.getValidClassifier(doc);
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        return TextSearchUtils.getNextWhitespace(docText, classifier, offset, limitOffset);
    }

    public static int getPreviousWhitespace(@NonNull LineDocument doc, int offset) throws BadLocationException {
        return LineDocumentUtils.getPreviousWhitespace(doc, offset, 0);
    }

    public static int getPreviousWhitespace(@NonNull LineDocument doc, int offset, int limitOffset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        CharClassifier classifier = LineDocumentUtils.getValidClassifier(doc);
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        return TextSearchUtils.getPreviousWhitespace(docText, classifier, offset, limitOffset);
    }

    public static int getNextNonWhitespace(@NonNull LineDocument doc, int offset) throws BadLocationException {
        return LineDocumentUtils.getNextNonWhitespace(doc, offset, doc.getLength() + 1);
    }

    public static int getNextNonWhitespace(@NonNull LineDocument doc, int offset, int limitOffset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        CharClassifier classifier = LineDocumentUtils.getValidClassifier(doc);
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        return TextSearchUtils.getNextNonWhitespace(docText, classifier, offset, limitOffset);
    }

    public static int getPreviousNonWhitespace(@NonNull LineDocument doc, int offset) throws BadLocationException {
        return LineDocumentUtils.getPreviousNonWhitespace(doc, offset, 0);
    }

    public static int getPreviousNonWhitespace(@NonNull LineDocument doc, int offset, int limitOffset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        CharClassifier classifier = LineDocumentUtils.getValidClassifier(doc);
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        return TextSearchUtils.getPreviousNonWhitespace(docText, classifier, offset, limitOffset);
    }

    public static int getLineIndex(@NonNull LineDocument doc, int offset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        Element lineRoot = doc.getParagraphElement(0).getParentElement();
        return lineRoot.getElementIndex(offset);
    }

    public static int getLineStartFromIndex(@NonNull LineDocument doc, int lineIndex) {
        Element lineRoot = doc.getParagraphElement(0).getParentElement();
        if (lineIndex < 0 || lineIndex >= lineRoot.getElementCount()) {
            return -1;
        }
        return lineRoot.getElement(lineIndex).getStartOffset();
    }

    public static boolean isLineEmpty(@NonNull LineDocument doc, int offset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        return TextSearchUtils.isLineEmpty(docText, offset);
    }

    public static boolean isLineWhitespace(@NonNull LineDocument doc, int offset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        return LineDocumentUtils.getLineFirstNonWhitespace(doc, offset) == -1;
    }

    public static int getNextNonNewline(@NonNull LineDocument doc, int offset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        return TextSearchUtils.getNextNonNewline(docText, offset, doc.getLength() + 1);
    }

    public static int getPreviousNonNewline(@NonNull LineDocument doc, int offset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(doc, offset);
        CharSequence docText = DocumentUtilities.getText((Document)doc);
        return TextSearchUtils.getPreviousNonNewline(docText, offset, 0);
    }

    public static int getLineCount(@NonNull LineDocument doc) {
        return doc.getParagraphElement(0).getParentElement().getElementCount();
    }

    public static int getLineCount(@NonNull LineDocument doc, int startOffset, int endOffset) {
        if (startOffset > endOffset) {
            return 0;
        }
        Element lineRoot = doc.getParagraphElement(0).getParentElement();
        return lineRoot.getElementIndex(endOffset) - lineRoot.getElementIndex(startOffset) + 1;
    }

    private static void checkOffsetValid(Document doc, int offset) throws BadLocationException {
        LineDocumentUtils.checkOffsetValid(offset, doc.getLength() + 1);
    }

    private static void checkOffsetValid(int offset, int limitOffset) throws BadLocationException {
        if (offset < 0 || offset > limitOffset) {
            throw new BadLocationException("Invalid offset=" + offset + " not within <0, " + limitOffset + ">", offset);
        }
    }

    private static CharClassifier getValidClassifier(Document doc) {
        CharClassifier cc = LineDocumentUtils.as(doc, CharClassifier.class);
        return cc != null ? cc : TextSearchUtils.DEFAULT_CLASSIFIER;
    }

    @CheckForNull
    public static <T> T as(@NullAllowed Document d, Class<T> documentService) {
        if (d == null) {
            return null;
        }
        return LineDocumentUtils.as(d, documentService, false);
    }

    @NonNull
    public static <T> T asRequired(@NonNull Document d, Class<T> documentService) {
        return LineDocumentUtils.as(d, documentService, true);
    }

    @CheckForNull
    private static <T> T as(@NonNull Document d, Class<T> documentService, boolean useStub) {
        Lookup lkp;
        if (d == null) {
            throw new NullPointerException("null document");
        }
        if (documentService.isInstance(d)) {
            Document res = d;
            return (T)res;
        }
        Object serv = d.getProperty(documentService);
        if (serv != null) {
            if (serv instanceof V) {
                if (useStub) {
                    Object res = ((V)serv).delegate;
                    if (res == null) {
                        throw new IllegalArgumentException();
                    }
                    return res;
                }
                return null;
            }
            if (serv == NOT_FOUND) {
                if (!useStub) {
                    return null;
                }
            } else {
                Object res = serv;
                return (T)res;
            }
        }
        if ((serv = (lkp = DocumentServices.getInstance().getLookup(d)).lookup(documentService)) == null) {
            if (useStub) {
                lkp = DocumentServices.getInstance().getStubLookup(d);
                serv = lkp.lookup(documentService);
                d.putProperty(documentService, new V<Object>(serv));
                if (serv == null) {
                    throw new IllegalArgumentException();
                }
            }
        } else {
            d.putProperty(documentService, serv);
        }
        Object res = serv;
        return (T)res;
    }

    @NonNull
    public static LineDocument createDocument(String mimeType) {
        DocumentFactory f = (DocumentFactory)MimeLookup.getLookup((String)mimeType).lookup(DocumentFactory.class);
        if (f == null) {
            throw new IllegalArgumentException("No document available for MIME type: " + mimeType);
        }
        Document doc = f.createDocument(mimeType);
        if (doc == null) {
            throw new IllegalArgumentException("Could not create document for MIME type: " + mimeType);
        }
        LineDocument ldoc = LineDocumentUtils.as(doc, LineDocument.class);
        if (ldoc == null) {
            throw new IllegalArgumentException("Could not create document for MIME type: " + mimeType);
        }
        return ldoc;
    }

    private static class V<T> {
        final T delegate;

        public V(T delegate) {
            this.delegate = delegate;
        }
    }
}

