/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.api.beans.model;

import java.io.File;
import java.io.IOException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.ConfigFileGroup;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.beans.SpringConfigModelAccessor;
import org.netbeans.modules.spring.beans.SpringScopeAccessor;
import org.netbeans.modules.spring.beans.model.SpringConfigFileModelController;
import org.netbeans.modules.spring.beans.model.SpringConfigFileModelManager;
import org.netbeans.modules.spring.beans.model.SpringConfigModelController;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionRef;

public final class SpringConfigModel {
    private final SpringConfigModelController controller;

    public static SpringConfigModel forFileObject(FileObject file) {
        SpringScope scope = SpringScope.getSpringScope(file);
        if (scope != null) {
            return SpringScopeAccessor.getDefault().getConfigModel(scope, file);
        }
        return null;
    }

    private SpringConfigModel(SpringConfigFileModelManager fileModelManager, ConfigFileGroup configFileGroup) {
        this.controller = new SpringConfigModelController(fileModelManager, configFileGroup);
    }

    public void runReadAction(Action<SpringBeans> action) throws IOException {
        this.controller.runReadAction(action);
    }

    public void runDocumentAction(Action<DocumentAccess> action) throws IOException {
        this.controller.runDocumentAction(action);
    }

    static {
        SpringConfigModelAccessor.setDefault(new SpringConfigModelAccessor(){

            @Override
            public SpringConfigModel createSpringConfigModel(SpringConfigFileModelManager fileModelManager, ConfigFileGroup configFileGroup) {
                return new SpringConfigModel(fileModelManager, configFileGroup);
            }

            @Override
            public DocumentAccess createDocumentAccess(SpringBeans springBeans, File file, SpringConfigFileModelController.LockedDocument lockedDoc) {
                return new DocumentAccess(springBeans, file, lockedDoc);
            }

            @Override
            public ConfigFileGroup getConfigFileGroup(SpringConfigModel model) {
                return model.controller.getConfigFileGroup();
            }
        });
    }

    public static final class DocumentAccess {
        private final SpringBeans springBeans;
        private final SpringConfigFileModelController.LockedDocument lockedDoc;
        private final File file;

        private DocumentAccess(SpringBeans springBeans, File file, SpringConfigFileModelController.LockedDocument lockedDoc) {
            this.springBeans = springBeans;
            this.lockedDoc = lockedDoc;
            this.file = file;
        }

        public SpringBeans getSpringBeans() {
            return this.springBeans;
        }

        public Document getDocument() {
            return this.lockedDoc.getDocument();
        }

        public File getFile() {
            return this.file;
        }

        public FileObject getFileObject() {
            return NbEditorUtilities.getFileObject((Document)this.lockedDoc.getDocument());
        }

        public PositionRef createPositionRef(int offset, Position.Bias bias) {
            return this.lockedDoc.createPositionRef(offset, bias);
        }
    }
}

