/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.actions;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.spi.debugger.ui.BreakpointType;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class AddBreakpointPanel
extends JPanel
implements HelpCtx.Provider {
    public static final String PROP_TYPE = "type";
    private static String lastSelectedCategory;
    private boolean doNotRefresh = false;
    private Set<String> cathegories = new TreeSet<String>();
    private ArrayList<BreakpointType> types = new ArrayList();
    private BreakpointType type;
    private JComponent customizer;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JComboBox cbCathegory;
    private JComboBox cbEvents;
    private JPanel pEvent;
    private HelpCtx helpCtx;
    private List<? extends BreakpointType> breakpointTypes = DebuggerManager.getDebuggerManager().lookup(null, BreakpointType.class);

    public AddBreakpointPanel() {
        String def = null;
        for (BreakpointType breakpointType : this.breakpointTypes) {
            String dn = breakpointType.getCategoryDisplayName();
            if (!this.cathegories.contains(dn)) {
                this.cathegories.add(dn);
            }
            if (!breakpointType.isDefault()) continue;
            def = dn;
        }
        this.cbCathegory = new JComboBox<Object>(this.cathegories.toArray());
        this.initComponents();
        if (def != null) {
            this.cbCathegory.setSelectedItem(def);
            this.selectCathegory(def);
        } else if (this.breakpointTypes.size() > 0) {
            if (lastSelectedCategory != null && this.cathegories.contains(lastSelectedCategory)) {
                this.cbCathegory.setSelectedItem(lastSelectedCategory);
            } else {
                this.cbCathegory.setSelectedIndex(0);
            }
            this.selectCathegory((String)this.cbCathegory.getSelectedItem());
        }
    }

    public BreakpointType getType() {
        return this.type;
    }

    Controller getController() {
        if (this.type != null) {
            Controller c = this.type.getController();
            if (c == null && this.customizer instanceof Controller) {
                return (Controller)((Object)this.customizer);
            }
            return c;
        }
        return null;
    }

    boolean isNoValidityController() {
        return this.type.getController() == null && this.customizer instanceof Controller;
    }

    private void initComponents() {
        GridBagConstraints gridBagConstraints1;
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddBreakpointPanel.class, (String)"ACSD_AddBreakpointPanel"));
        this.setLayout(new GridBagLayout());
        if (this.cathegories.size() > 1) {
            this.jLabel1 = new JLabel();
            Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(AddBreakpointPanel.class, (String)"CTL_Breakpoint_cathegory"));
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.insets = new Insets(12, 12, 0, 0);
            this.add((Component)this.jLabel1, gridBagConstraints1);
            this.cbCathegory.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    AddBreakpointPanel.this.cbCathegoryActionPerformed(evt);
                }
            });
            this.cbCathegory.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddBreakpointPanel.class, (String)"ACSD_CTL_Breakpoint_cathegory"));
            this.jLabel1.setLabelFor(this.cbCathegory);
            gridBagConstraints1 = new GridBagConstraints();
            gridBagConstraints1.gridwidth = 2;
            gridBagConstraints1.insets = new Insets(12, 12, 0, 0);
            gridBagConstraints1.anchor = 17;
            this.add((Component)this.cbCathegory, gridBagConstraints1);
        }
        this.jLabel2 = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(AddBreakpointPanel.class, (String)"CTL_Breakpoint_type"));
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 2;
        gridBagConstraints1.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.jLabel2, gridBagConstraints1);
        this.cbEvents = new JComboBox();
        this.cbEvents.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AddBreakpointPanel.this.cbEventsActionPerformed();
            }
        });
        this.cbEvents.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(AddBreakpointPanel.class, (String)"ACSD_CTL_Breakpoint_type"));
        this.cbEvents.setMaximumRowCount(12);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new Insets(12, 12, 0, 12);
        gridBagConstraints1.anchor = 17;
        this.add((Component)this.cbEvents, gridBagConstraints1);
        this.jLabel2.setLabelFor(this.cbEvents);
        this.pEvent = new JPanel();
        this.pEvent.setLayout(new BorderLayout());
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 0;
        gridBagConstraints1.insets = new Insets(9, 9, 0, 9);
        gridBagConstraints1.fill = 1;
        gridBagConstraints1.weightx = 1.0;
        gridBagConstraints1.weighty = 1.0;
        this.add((Component)this.pEvent, gridBagConstraints1);
    }

    private void cbEventsActionPerformed() {
        if (this.doNotRefresh) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean pv = AddBreakpointPanel.this.cbEvents.isPopupVisible();
                int j = AddBreakpointPanel.this.cbEvents.getSelectedIndex();
                if (j < 0) {
                    return;
                }
                AddBreakpointPanel.this.update((BreakpointType)AddBreakpointPanel.this.types.get(j));
                if (pv) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            AddBreakpointPanel.this.cbEvents.setPopupVisible(true);
                        }
                    });
                }
            }
        });
    }

    private void cbCathegoryActionPerformed(ActionEvent evt) {
        if (this.doNotRefresh) {
            return;
        }
        String c = (String)this.cbCathegory.getSelectedItem();
        if (c == null) {
            return;
        }
        this.selectCathegory(c);
    }

    private void selectCathegory(String c) {
        lastSelectedCategory = c;
        this.doNotRefresh = true;
        this.cbEvents.removeAllItems();
        this.types.clear();
        int defIndex = 0;
        for (BreakpointType breakpointType : this.breakpointTypes) {
            if (!breakpointType.getCategoryDisplayName().equals(c)) continue;
            this.cbEvents.addItem(breakpointType.getTypeDisplayName());
            this.types.add(breakpointType);
            if (!breakpointType.isDefault()) continue;
            defIndex = this.cbEvents.getItemCount() - 1;
        }
        this.doNotRefresh = false;
        if (defIndex < this.cbEvents.getItemCount()) {
            this.cbEvents.setSelectedIndex(defIndex);
        }
    }

    public HelpCtx getHelpCtx() {
        return this.helpCtx;
    }

    private void update(BreakpointType t) {
        if (this.type == t) {
            return;
        }
        this.pEvent.removeAll();
        DebuggerManager d = DebuggerManager.getDebuggerManager();
        BreakpointType old = this.type;
        this.type = t;
        this.customizer = this.type.getCustomizer();
        if (this.customizer == null) {
            return;
        }
        String hid = (String)this.customizer.getClientProperty("HelpID_AddBreakpointPanel");
        this.helpCtx = hid != null ? new HelpCtx(hid) : HelpCtx.findHelp((Component)this.customizer);
        this.pEvent.add((Component)this.customizer, "Center");
        this.pEvent.getAccessibleContext().setAccessibleDescription(this.customizer.getAccessibleContext().getAccessibleDescription());
        this.customizer.getAccessibleContext().setAccessibleName(this.pEvent.getAccessibleContext().getAccessibleName());
        this.revalidate();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Window w = SwingUtilities.windowForComponent(AddBreakpointPanel.this);
                if (w == null) {
                    return;
                }
                w.pack();
            }
        });
        this.firePropertyChange(PROP_TYPE, old, this.type);
    }
}

