/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.docker.ConnectionListener;
import org.netbeans.modules.docker.DockerActionAccessor;
import org.netbeans.modules.docker.Endpoint;
import org.netbeans.modules.docker.api.DockerAction;
import org.netbeans.modules.docker.api.DockerEvent;
import org.netbeans.modules.docker.api.DockerException;
import org.netbeans.modules.docker.api.DockerInstance;
import org.openide.util.RequestProcessor;

public class DockerEventBus
implements Closeable,
DockerEvent.Listener,
ConnectionListener {
    private static final Logger LOGGER = Logger.getLogger(DockerEventBus.class.getName());
    private static final long INTERVAL = 5000L;
    private final RequestProcessor processor = new RequestProcessor(DockerEventBus.class);
    private final DockerInstance instance;
    private final List<DockerInstance.ConnectionListener> connectionListeners = new ArrayList<DockerInstance.ConnectionListener>();
    private final List<DockerEvent.Listener> imageListeners = new ArrayList<DockerEvent.Listener>();
    private final List<DockerEvent.Listener> containerListeners = new ArrayList<DockerEvent.Listener>();
    private Endpoint endpoint;
    private DockerEvent lastEvent;
    private boolean stop;
    private boolean blocked;

    public DockerEventBus(DockerInstance instance) {
        this.instance = instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectionListener(DockerInstance.ConnectionListener listener) {
        DockerEventBus dockerEventBus = this;
        synchronized (dockerEventBus) {
            this.checkStart();
            this.connectionListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnectionListener(DockerInstance.ConnectionListener listener) {
        DockerEventBus dockerEventBus = this;
        synchronized (dockerEventBus) {
            this.connectionListeners.remove(listener);
            this.checkStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImageListener(DockerEvent.Listener listener) {
        DockerEventBus dockerEventBus = this;
        synchronized (dockerEventBus) {
            this.checkStart();
            this.imageListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeImageListener(DockerEvent.Listener listener) {
        DockerEventBus dockerEventBus = this;
        synchronized (dockerEventBus) {
            this.imageListeners.remove(listener);
            this.checkStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addContainerListener(DockerEvent.Listener listener) {
        DockerEventBus dockerEventBus = this;
        synchronized (dockerEventBus) {
            this.checkStart();
            this.containerListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeContainerListener(DockerEvent.Listener listener) {
        DockerEventBus dockerEventBus = this;
        synchronized (dockerEventBus) {
            this.containerListeners.remove(listener);
            this.checkStop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendEvent(DockerEvent event) {
        ArrayList<DockerEvent.Listener> toFire;
        DockerEventBus dockerEventBus = this;
        synchronized (dockerEventBus) {
            toFire = event.getStatus().isContainer() ? new ArrayList<DockerEvent.Listener>(this.containerListeners) : new ArrayList<DockerEvent.Listener>(this.imageListeners);
        }
        LOGGER.log(Level.FINE, event.toString());
        for (DockerEvent.Listener l : toFire) {
            l.onEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEvent(DockerEvent event) {
        ArrayList<DockerEvent.Listener> toFire;
        DockerEventBus dockerEventBus = this;
        synchronized (dockerEventBus) {
            if (this.blocked) {
                if (event.equals(this.lastEvent)) {
                    this.blocked = false;
                    return;
                }
                if (this.lastEvent == null || this.lastEvent.getTime() < event.getTime()) {
                    this.blocked = false;
                } else {
                    return;
                }
            }
            this.lastEvent = event;
            toFire = event.getStatus().isContainer() ? new ArrayList<DockerEvent.Listener>(this.containerListeners) : new ArrayList<DockerEvent.Listener>(this.imageListeners);
        }
        LOGGER.log(Level.FINE, event.toString());
        for (DockerEvent.Listener l : toFire) {
            l.onEvent(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onConnect(Endpoint e) {
        ArrayList<DockerInstance.ConnectionListener> toFire;
        DockerEventBus dockerEventBus = this;
        synchronized (dockerEventBus) {
            this.endpoint = e;
            toFire = new ArrayList<DockerInstance.ConnectionListener>(this.connectionListeners);
        }
        for (DockerInstance.ConnectionListener l : toFire) {
            l.onConnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDisconnect() {
        ArrayList<DockerInstance.ConnectionListener> toFire;
        DockerEventBus dockerEventBus = this;
        synchronized (dockerEventBus) {
            toFire = new ArrayList<DockerInstance.ConnectionListener>(this.connectionListeners);
        }
        for (DockerInstance.ConnectionListener l : toFire) {
            l.onDisconnect();
        }
    }

    @Override
    public void close() {
        this.stop();
    }

    private void checkStart() {
        if (this.connectionListeners.isEmpty() && this.imageListeners.isEmpty() && this.containerListeners.isEmpty()) {
            this.start();
        }
    }

    private void checkStop() {
        if (this.connectionListeners.isEmpty() && this.imageListeners.isEmpty() && this.containerListeners.isEmpty()) {
            this.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start() {
        DockerEventBus dockerEventBus = this;
        synchronized (dockerEventBus) {
            this.stop = false;
            this.blocked = false;
            this.lastEvent = null;
            this.processor.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DockerAction remote = new DockerAction(DockerEventBus.this.instance);
                    while (true) {
                        try {
                            if (Thread.currentThread().isInterrupted()) {
                                return;
                            }
                            DockerEventBus dockerEventBus = DockerEventBus.this;
                            synchronized (dockerEventBus) {
                                if (DockerEventBus.this.stop) {
                                    return;
                                }
                            }
                            DockerActionAccessor.getDefault().events(remote, DockerEventBus.this.lastEvent != null ? Long.valueOf(DockerEventBus.this.lastEvent.getTime()) : null, DockerEventBus.this, DockerEventBus.this);
                        }
                        catch (DockerException ex) {
                            DockerEventBus dockerEventBus = DockerEventBus.this;
                            synchronized (dockerEventBus) {
                                if (DockerEventBus.this.stop) {
                                    return;
                                }
                            }
                            LOGGER.log(Level.INFO, null, ex);
                        }
                        DockerEventBus.this.blocked = true;
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (InterruptedException ex) {
                            LOGGER.log(Level.INFO, null, ex);
                            Thread.currentThread().interrupt();
                            return;
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        Endpoint current;
        DockerEventBus dockerEventBus = this;
        synchronized (dockerEventBus) {
            this.stop = true;
            current = this.endpoint;
            this.endpoint = null;
        }
        try {
            if (current != null) {
                current.close();
            }
        }
        catch (IOException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
    }
}

