/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.lsp.server.input;

import java.util.Objects;
import org.eclipse.lsp4j.jsonrpc.util.Preconditions;
import org.eclipse.lsp4j.jsonrpc.validation.NonNull;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.util.ToStringBuilder;
import org.netbeans.modules.java.lsp.server.input.ShowInputBoxParams;

public final class InputBoxStep
extends ShowInputBoxParams {
    private int totalSteps;
    @NonNull
    private String stepId;

    public InputBoxStep() {
        this.totalSteps = 0;
    }

    public InputBoxStep(int totalSteps, @NonNull String stepId, @NonNull String prompt, @NonNull String value) {
        super(prompt, value);
        this.totalSteps = totalSteps;
        this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (String)"stepId");
    }

    public InputBoxStep(int totalSteps, @NonNull String stepId, String title, @NonNull String prompt, @NonNull String value, boolean password) {
        super(title, prompt, value, password);
        this.totalSteps = totalSteps;
        this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (String)"stepId");
    }

    @Pure
    public int getTotalSteps() {
        return this.totalSteps;
    }

    public void setTotalSteps(int totalSteps) {
        this.totalSteps = totalSteps;
    }

    @Pure
    @NonNull
    public String getStepId() {
        return this.stepId;
    }

    public void setStepId(@NonNull String stepId) {
        this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (String)"stepId");
    }

    @Override
    @Pure
    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this);
        b.add("totalSteps", (Object)this.totalSteps);
        b.add("stepId", (Object)this.stepId);
        b.add("title", (Object)this.getTitle());
        b.add("prompt", (Object)this.getPrompt());
        b.add("value", (Object)this.getValue());
        b.add("password", (Object)this.isPassword());
        return b.toString();
    }

    @Override
    @Pure
    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + this.totalSteps;
        hash = 97 * hash + Objects.hashCode(this.stepId);
        hash = 97 * hash + Objects.hashCode(this.getTitle());
        hash = 97 * hash + Objects.hashCode(this.getPrompt());
        hash = 97 * hash + Objects.hashCode(this.getValue());
        hash = 97 * hash + (this.isPassword() ? 1 : 0);
        return hash;
    }

    @Override
    @Pure
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        InputBoxStep other = (InputBoxStep)obj;
        if (this.totalSteps != other.totalSteps) {
            return false;
        }
        if (this.isPassword() != other.isPassword()) {
            return false;
        }
        if (!Objects.equals(this.stepId, other.stepId)) {
            return false;
        }
        if (!Objects.equals(this.getTitle(), other.getTitle())) {
            return false;
        }
        if (!Objects.equals(this.getPrompt(), other.getPrompt())) {
            return false;
        }
        return Objects.equals(this.getValue(), other.getValue());
    }
}

