/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.analysis.analyzer;

import java.util.HashSet;
import java.util.List;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;

public final class AnnotationUtil {
    public static final String ANY = "javax.enterprise.inject.Any";
    public static final String ANY_JAKARTA = "jakarta.enterprise.inject.Any";
    public static final String VALUE = "value";
    public static final String INJECT = "Inject";
    public static final String INJECT_FQN = "javax.inject.Inject";
    public static final String INJECT_FQN_JAKARTA = "jakarta.inject.Inject";
    public static final String DECORATOR = "javax.decorator.Decorator";
    public static final String DECORATOR_JAKARTA = "jakarta.decorator.Decorator";
    public static final String PRODUCES = "Produces";
    public static final String PRODUCES_FQN = "javax.enterprise.inject.Produces";
    public static final String PRODUCES_FQN_JAKARTA = "jakarta.enterprise.inject.Produces";
    public static final String INTERCEPTOR_BINDING = "InterceptorBinding";
    public static final String INTERCEPTOR_BINDING_FQN = "javax.interceptor.InterceptorBinding";
    public static final String INTERCEPTOR_BINDING_FQN_JAKARTA = "jakarta.interceptor.InterceptorBinding";
    public static final String INTERCEPTOR = "javax.interceptor.Interceptor";
    public static final String INTERCEPTOR_JAKARTA = "jakarta.interceptor.Interceptor";
    public static final String NORMAL_SCOPE = "NormalScope";
    public static final String NORMAL_SCOPE_FQN = "javax.enterprise.context.NormalScope";
    public static final String NORMAL_SCOPE_FQN_JAKARTA = "jakarta.enterprise.context.NormalScope";
    public static final String SCOPE = "Scope";
    public static final String SCOPE_FQN = "javax.inject.Scope";
    public static final String SCOPE_FQN_JAKARTA = "jakarta.inject.Scope";
    public static final String REQUEST_SCOPE_FQN = "javax.enterprise.context.RequestScoped";
    public static final String REQUEST_SCOPE_FQN_JAKARTA = "jakarta.enterprise.context.RequestScoped";
    public static final String SESSION_SCOPE_FQN = "javax.enterprise.context.SessionScoped";
    public static final String SESSION_SCOPE_FQN_JAKARTA = "jakarta.enterprise.context.SessionScoped";
    public static final String APPLICATION_SCOPE_FQN = "javax.enterprise.context.ApplicationScoped";
    public static final String APPLICATION_SCOPE_FQN_JAKARTA = "jakarta.enterprise.context.ApplicationScoped";
    public static final String CONVERSATION_SCOPE_FQN = "javax.enterprise.context.ConversationScoped";
    public static final String CONVERSATION_SCOPE_FQN_JAKARTA = "jakarta.enterprise.context.ConversationScoped";
    public static final String DEPENDENT_SCOPE_FQN = "javax.enterprise.context.Dependent";
    public static final String DEPENDENT_SCOPE_FQN_JAKARTA = "jakarta.enterprise.context.Dependent";
    public static final String DISPOSES = "Disposes";
    public static final String DISPOSES_FQN = "javax.enterprise.inject.Disposes";
    public static final String DISPOSES_FQN_JAKARTA = "jakarta.enterprise.inject.Disposes";
    public static final String OBSERVES = "Observes";
    public static final String OBSERVES_FQN = "javax.enterprise.event.Observes";
    public static final String OBSERVES_FQN_JAKARTA = "jakarta.enterprise.event.Observes";
    public static final String STATELESS = "javax.ejb.Stateless";
    public static final String STATELESS_JAKARTA = "jakarta.ejb.Stateless";
    public static final String STATEFUL = "javax.ejb.Stateful";
    public static final String STATEFUL_JAKARTA = "jakarta.ejb.Stateful";
    public static final String SINGLETON = "javax.ejb.Singleton";
    public static final String SINGLETON_JAKARTA = "jakarta.ejb.Singleton";
    public static final String CDISINGLETON = "javax.inject.Singleton";
    public static final String CDISINGLETON_JAKARTA = "jakarta.inject.Singleton";
    public static final String APPLICATION_SCOPED = "javax.enterprise.context.ApplicationScoped";
    public static final String APPLICATION_SCOPED_JAKARTA = "jakarta.enterprise.context.ApplicationScoped";
    public static final String DEPENDENT = "javax.enterprise.context.Dependent";
    public static final String DEPENDENT_JAKARTA = "jakarta.enterprise.context.Dependent";
    public static final String STEREOTYPE = "Stereotype";
    public static final String STEREOTYPE_FQN = "javax.enterprise.inject.Stereotype";
    public static final String STEREOTYPE_FQN_JAKARTA = "jakarta.enterprise.inject.Stereotype";
    public static final String NAMED = "javax.inject.Named";
    public static final String NAMED_JAKARTA = "jakarta.inject.Named";
    public static final String QUALIFIER = "Qualifier";
    public static final String QUALIFIER_FQN = "javax.inject.Qualifier";
    public static final String QUALIFIER_FQN_JAKARTA = "jakarta.inject.Qualifier";
    public static final String DELEGATE_FQN = "javax.decorator.Delegate";
    public static final String DELEGATE_FQN_JAKARTA = "jakarta.decorator.Delegate";
    public static final String SPECIALIZES = "javax.enterprise.inject.Specializes";
    public static final String SPECIALIZES_JAKARTA = "jakarta.enterprise.inject.Specializes";
    public static final String INJECTION_POINT = "javax.enterprise.inject.spi.InjectionPoint";
    public static final String INJECTION_POINT_JAKARTA = "jakarta.enterprise.inject.spi.InjectionPoint";
    public static final String DEFAULT_FQN = "javax.enterprise.inject.Default";
    public static final String DEFAULT_FQN_JAKARTA = "jakarta.enterprise.inject.Default";
    public static final String POST_CONSTRUCT = "javax.annotation.PostConstruct";
    public static final String POST_CONSTRUCT_JAKARTA = "jakarta.annotation.PostConstruct";
    public static final String PRE_DESTROY = "javax.annotation.PreDestroy";
    public static final String PRE_DESTROY_JAKARTA = "jakarta.annotation.PreDestroy";
    public static final String POST_ACTIVATE = "javax.ejb.PostActivate";
    public static final String POST_ACTIVATE_JAKARTA = "jakarta.ejb.PostActivate";
    public static final String PRE_PASSIVATE = "javax.ejb.PrePassivate";
    public static final String PRE_PASSIVATE_JAKARTA = "jakarta.ejb.PrePassivate";
    public static final String CONTEXT = "javax.enterprise.context.spi.Context";
    public static final String CONTEXT_JAKARTA = "jakarta.enterprise.context.spi.Context";
    public static final String CONVERSATION = "javax.enterprise.context.Conversation";
    public static final String CONVERSATION_JAKARTA = "jakarta.enterprise.context.Conversation";
    public static final String ALTERNATVE = "javax.enterprise.inject.Alternative";
    public static final String ALTERNATVE_JAKARTA = "jakarta.enterprise.inject.Alternative";
    public static final String TYPED = "javax.enterprise.inject.Typed";
    public static final String TYPED_JAKARTA = "jakarta.enterprise.inject.Typed";
    public static final String NON_BINDING = "javax.enterprise.util.Nonbinding";
    public static final String NON_BINDING_JAKARTA = "jakarta.enterprise.util.Nonbinding";
    public static final String PASSIVATING = "passivating";
    public static final String PROVIDER = "javax.inject.Provider";
    public static final String PROVIDER_JAKARTA = "jakarta.inject.Provider";

    private AnnotationUtil() {
    }

    public static boolean hasAnnotation(Element element, CompilationInfo info, String ... annotationFqns) {
        return AnnotationUtil.getAnnotationMirror(element, info, annotationFqns) != null;
    }

    public static boolean hasAnnotation(Element element, WebBeansModel model, String ... annotationFqns) {
        return AnnotationUtil.hasAnnotation(element, (CompilationInfo)model.getCompilationController(), annotationFqns);
    }

    /*
     * WARNING - void declaration
     */
    public static AnnotationMirror getAnnotationMirror(Element element, CompilationInfo info, String ... annotationFqns) {
        void var7_9;
        HashSet<TypeElement> set = new HashSet<TypeElement>();
        Elements els = info.getElements();
        String[] stringArray = annotationFqns;
        int n = stringArray.length;
        boolean bl = false;
        while (var7_9 < n) {
            String annotation = stringArray[var7_9];
            TypeElement annotationElement = els.getTypeElement(annotation);
            if (annotationElement != null) {
                set.add(annotationElement);
            }
            ++var7_9;
        }
        List<? extends AnnotationMirror> annotations = els.getAllAnnotationMirrors(element);
        for (AnnotationMirror annotationMirror : annotations) {
            Element declaredAnnotation = info.getTypes().asElement(annotationMirror.getAnnotationType());
            if (!set.contains(declaredAnnotation)) continue;
            return annotationMirror;
        }
        return null;
    }

    public static boolean isSessionBean(Element element, CompilationInfo compInfo) {
        return AnnotationUtil.hasAnnotation(element, compInfo, STATEFUL, STATELESS, SINGLETON, STATEFUL_JAKARTA, STATELESS_JAKARTA, SINGLETON_JAKARTA);
    }

    public static boolean isDelegate(Element element, TypeElement parent, WebBeansModel model) {
        return AnnotationUtil.hasAnnotation(element, model, DELEGATE_FQN) && AnnotationUtil.hasAnnotation((Element)parent, model, DECORATOR) || AnnotationUtil.hasAnnotation(element, model, DELEGATE_FQN_JAKARTA) && AnnotationUtil.hasAnnotation((Element)parent, model, DECORATOR_JAKARTA);
    }

    public static boolean isLifecycleCallback(ExecutableElement element, CompilationInfo info) {
        return AnnotationUtil.hasAnnotation((Element)element, info, POST_ACTIVATE, POST_CONSTRUCT, PRE_DESTROY, PRE_PASSIVATE, POST_ACTIVATE_JAKARTA, POST_CONSTRUCT_JAKARTA, PRE_DESTROY_JAKARTA, PRE_PASSIVATE_JAKARTA);
    }
}

