/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.netbeans.modules.project.ui.actions.ActionsUtil;
import org.netbeans.modules.project.ui.actions.Bundle;
import org.netbeans.modules.project.ui.actions.LookupSensitiveAction;
import org.netbeans.modules.project.ui.actions.ProjectAction;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Actions;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.WeakListeners;

public class MainProjectAction
extends LookupSensitiveAction
implements PropertyChangeListener {
    private String command;
    private ProjectActionPerformer performer;
    private String name;

    public MainProjectAction(ProjectActionPerformer performer, String name, Icon icon) {
        this(null, performer, name, icon, null);
    }

    public MainProjectAction(String command, String name, Icon icon) {
        this(command, null, name, icon, null);
    }

    MainProjectAction(String command, ProjectActionPerformer performer, String name, Icon icon, Lookup lookup) {
        super(icon, lookup, new Class[]{Project.class, DataObject.class});
        this.command = command;
        this.performer = performer;
        this.name = name;
        String presenterName = "";
        if (name != null) {
            presenterName = MessageFormat.format(name, -1);
        }
        this.setDisplayName(presenterName);
        if (icon != null) {
            this.setSmallIcon(icon);
        }
        OpenProjectList.getDefault().addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)OpenProjectList.getDefault()));
    }

    @Override
    protected boolean init() {
        boolean needsInit = super.init();
        if (needsInit) {
            this.refreshView(null, true);
        }
        return needsInit;
    }

    @Override
    public void actionPerformed(final Lookup context) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                Project mainProject = OpenProjectList.getDefault().getMainProject();
                final Project[] projects = MainProjectAction.this.selection(mainProject, context);
                if (projects.length == 0) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)Bundle.MainProjectAction_no_main(), 2));
                    return;
                }
                Runnable r2 = new Runnable(){

                    @Override
                    public void run() {
                        if (MainProjectAction.this.command != null && projects.length > 0) {
                            ProjectAction.runSequentially(new LinkedList<Project>(Arrays.asList(projects)), MainProjectAction.this, MainProjectAction.this.command);
                        } else if (MainProjectAction.this.performer != null && projects.length == 1) {
                            MainProjectAction.this.performer.perform(projects[0]);
                        }
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    r2.run();
                } else {
                    SwingUtilities.invokeLater(r2);
                }
            }
        };
        if (Boolean.getBoolean("sync.project.execution")) {
            r.run();
        } else {
            RP.post(r);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String prop = evt.getPropertyName();
        if (prop == null) {
            return;
        }
        switch (prop) {
            case "MainProject": 
            case "OpenProjects": {
                this.refreshView(null, false);
            }
        }
    }

    private Project[] selection(Project mainProject, Lookup context) {
        Project[] projects;
        if (mainProject != null) {
            return new Project[]{mainProject};
        }
        Lookup theContext = context;
        if (theContext == null) {
            theContext = LookupSensitiveAction.LastActivatedWindowLookup.INSTANCE;
        }
        if (theContext != null && (projects = ActionsUtil.getProjectsFromLookup(theContext, this.command)).length > 0) {
            return projects;
        }
        projects = OpenProjects.getDefault().getOpenProjects();
        if (projects.length == 1) {
            return projects;
        }
        return new Project[0];
    }

    private void refreshView(final Lookup context, boolean immediate) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                boolean enabled;
                Project mainProject = OpenProjectList.getDefault().getMainProject();
                final Project[] projects = MainProjectAction.this.selection(mainProject, context);
                final String presenterName = MainProjectAction.this.getPresenterName(MainProjectAction.this.name, mainProject, projects);
                if (MainProjectAction.this.command == null) {
                    enabled = projects.length == 1 && MainProjectAction.this.performer.enable(projects[0]);
                } else if (projects.length == 0) {
                    enabled = false;
                } else {
                    boolean e = true;
                    for (Project p : projects) {
                        if (ActionsUtil.commandSupported(p, MainProjectAction.this.command, Lookup.EMPTY)) continue;
                        e = false;
                        break;
                    }
                    enabled = e;
                }
                Mutex.EVENT.writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        MainProjectAction.this.putValue("selectedProjects", projects);
                        MainProjectAction.this.putValue("menuText", presenterName);
                        MainProjectAction.this.putValue("ShortDescription", Actions.cutAmpersand((String)presenterName));
                        MainProjectAction.this.setEnabled(enabled);
                    }
                });
            }
        };
        if (immediate) {
            r.run();
        } else {
            RP.post(r);
        }
    }

    private String getPresenterName(String name, Project mPrj, Project[] cPrj) {
        if (name == null) {
            return "";
        }
        if (mPrj == null) {
            return ActionsUtil.formatProjectSensitiveName(name, cPrj);
        }
        return MessageFormat.format(name, -1);
    }

    @Override
    protected void refresh(Lookup context, boolean immediate) {
        this.refreshView(context, immediate);
    }
}

