/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.registry.uddi;

import com.sun.xml.registry.uddi.UDDIMapper;
import com.sun.xml.registry.uddi.UDDIMapperCallback;
import com.sun.xml.registry.uddi.UDDIPrincipal;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import javax.security.auth.spi.LoginModule;
import javax.xml.registry.JAXRException;

public class UDDILoginModule
implements LoginModule {
    Logger logger = (Logger)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Logger.getLogger("javax.enterprise.resource.webservices.registry.uddi");
        }
    });
    private Subject subject;
    private CallbackHandler callbackHandler;
    private Map sharedState;
    private Map options;
    private boolean debug = false;
    private boolean succeeded = false;
    private boolean commitSucceeded = false;
    private String username;
    private char[] password;
    private UDDIPrincipal userPrincipal;
    private PasswordAuthentication pa;
    private String authToken;
    private UDDIMapper mapper;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        this.subject = subject;
        this.callbackHandler = callbackHandler;
        this.sharedState = sharedState;
        this.options = options;
        this.debug = "true".equalsIgnoreCase((String)options.get("debug"));
    }

    @Override
    public boolean login() throws LoginException {
        if (this.callbackHandler == null) {
            throw new LoginException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDILoginModule:Error:_no_CallbackHandler_available_to_garner_authentication_information_from_the_user"));
        }
        Callback[] callbacks = new Callback[]{new NameCallback("UDDI Registry username: "), new PasswordCallback("UDDI Registry password: ", false), new UDDIMapperCallback()};
        try {
            this.callbackHandler.handle(callbacks);
            this.username = ((NameCallback)callbacks[0]).getName();
            char[] tmpPassword = ((PasswordCallback)callbacks[1]).getPassword();
            if (tmpPassword == null) {
                tmpPassword = new char[]{};
            }
            this.password = new char[tmpPassword.length];
            System.arraycopy(tmpPassword, 0, this.password, 0, tmpPassword.length);
            ((PasswordCallback)callbacks[1]).clearPassword();
            this.mapper = ((UDDIMapperCallback)callbacks[2]).getUDDIMapper();
        }
        catch (IOException ioe) {
            LoginException le = new LoginException(ioe.toString());
            le.initCause(ioe);
            throw le;
        }
        catch (UnsupportedCallbackException uce) {
            LoginException le = new LoginException(ResourceBundle.getBundle("com/sun/xml/registry/uddi/LocalStrings").getString("UDDILoginModule:Error:_not_available_to_garner_authentication_information_from_the_user"));
            le.initCause(uce);
            throw le;
        }
        if (this.debug) {
            this.logger.finest("\t\t[SampleLoginModule] user entered username: " + this.username);
            this.logger.finest("\t\t[SampleLoginModule] user entered password: ");
            for (int i = 0; i < this.password.length; ++i) {
            }
        }
        this.pa = new PasswordAuthentication(this.username, this.password);
        HashSet<PasswordAuthentication> credentials = new HashSet<PasswordAuthentication>();
        credentials.add(this.pa);
        try {
            this.authToken = this.mapper.getAuthorizationToken(credentials);
            this.succeeded = true;
            return true;
        }
        catch (JAXRException jex) {
            if (this.debug) {
                this.logger.finest("\t\t[SampleLoginModule] authentication failed");
            }
            this.succeeded = false;
            this.username = null;
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
            this.pa = null;
            throw new FailedLoginException("");
        }
    }

    @Override
    public boolean commit() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        this.userPrincipal = new UDDIPrincipal(this.username);
        if (!this.subject.getPrincipals().contains(this.userPrincipal)) {
            this.subject.getPrincipals().add(this.userPrincipal);
        }
        if (this.debug) {
            this.logger.finest("\t\t[SampleLoginModule] added SamplePrincipal to Subject");
        }
        this.subject.getPrivateCredentials().add(this.pa);
        this.subject.getPrivateCredentials().add(this.authToken);
        this.username = null;
        for (int i = 0; i < this.password.length; ++i) {
            this.password[i] = 32;
        }
        this.password = null;
        this.commitSucceeded = true;
        return true;
    }

    @Override
    public boolean abort() throws LoginException {
        if (!this.succeeded) {
            return false;
        }
        if (this.succeeded && !this.commitSucceeded) {
            this.succeeded = false;
            this.username = null;
            if (this.password != null) {
                for (int i = 0; i < this.password.length; ++i) {
                    this.password[i] = 32;
                }
                this.password = null;
            }
            this.userPrincipal = null;
            this.pa = null;
        } else {
            this.logout();
        }
        return true;
    }

    @Override
    public boolean logout() throws LoginException {
        this.subject.getPrincipals().remove(this.userPrincipal);
        this.succeeded = false;
        this.succeeded = this.commitSucceeded;
        this.username = null;
        if (this.password != null) {
            for (int i = 0; i < this.password.length; ++i) {
                this.password[i] = 32;
            }
            this.password = null;
        }
        this.userPrincipal = null;
        return true;
    }
}

