/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetBootVolumeRequest
extends BmcRequest<Void> {
    private String bootVolumeId;

    public String getBootVolumeId() {
        return this.bootVolumeId;
    }

    public Builder toBuilder() {
        return new Builder().bootVolumeId(this.bootVolumeId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",bootVolumeId=").append(String.valueOf(this.bootVolumeId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetBootVolumeRequest)) {
            return false;
        }
        GetBootVolumeRequest other = (GetBootVolumeRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.bootVolumeId, other.bootVolumeId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.bootVolumeId == null ? 43 : this.bootVolumeId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetBootVolumeRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String bootVolumeId = null;

        public Builder bootVolumeId(String bootVolumeId) {
            this.bootVolumeId = bootVolumeId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetBootVolumeRequest o) {
            this.bootVolumeId(o.getBootVolumeId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetBootVolumeRequest build() {
            GetBootVolumeRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetBootVolumeRequest buildWithoutInvocationCallback() {
            GetBootVolumeRequest request = new GetBootVolumeRequest();
            request.bootVolumeId = this.bootVolumeId;
            return request;
        }
    }
}

