/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spellchecker.completion;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.document.LineDocument;
import org.netbeans.api.editor.document.LineDocumentUtils;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.spellchecker.ComponentPeer;
import org.netbeans.modules.spellchecker.completion.AddToDictionaryCompletionItem;
import org.netbeans.modules.spellchecker.completion.WordCompletionItem;
import org.netbeans.modules.spellchecker.spi.dictionary.Dictionary;
import org.netbeans.modules.spellchecker.spi.dictionary.ValidityType;
import org.netbeans.modules.spellchecker.spi.language.TokenList;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionProvider;
import org.netbeans.spi.editor.completion.CompletionResultSet;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.AsyncCompletionQuery;
import org.netbeans.spi.editor.completion.support.AsyncCompletionTask;
import org.openide.ErrorManager;

public class WordCompletion
implements CompletionProvider {
    public CompletionTask createTask(int queryType, JTextComponent component) {
        if (queryType == 1) {
            return new AsyncCompletionTask((AsyncCompletionQuery)new Query(), component);
        }
        return null;
    }

    public int getAutoQueryTypes(JTextComponent component, String typedText) {
        return 0;
    }

    private static class Query
    extends AsyncCompletionQuery {
        private Query() {
        }

        protected void query(CompletionResultSet resultSet, Document document, final int caretOffset) {
            Dictionary dictionary = ComponentPeer.getDictionary(document);
            final TokenList l = ComponentPeer.ACCESSOR.lookupTokenList(document);
            if (dictionary != null && l != null && document instanceof BaseDocument) {
                final BaseDocument bdoc = (BaseDocument)document;
                final String[] text = new String[2];
                document.render(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            int lineStart = LineDocumentUtils.getLineStartOffset((LineDocument)bdoc, (int)caretOffset);
                            l.setStartOffset(lineStart);
                            while (l.nextWord()) {
                                int start = l.getCurrentWordStartOffset();
                                int end = l.getCurrentWordStartOffset() + l.getCurrentWordText().length();
                                if (start >= caretOffset || end < caretOffset) continue;
                                text[0] = l.getCurrentWordText().subSequence(0, caretOffset - start).toString();
                                text[1] = l.getCurrentWordText().toString();
                                return;
                            }
                        }
                        catch (BadLocationException e) {
                            ErrorManager.getDefault().notify(1, (Throwable)e);
                        }
                    }
                });
                if (text[0] != null) {
                    int i = 0;
                    for (String proposal : dictionary.findValidWordsForPrefix((CharSequence)text[0])) {
                        resultSet.addItem((CompletionItem)new WordCompletionItem(caretOffset - text[0].length(), proposal));
                        if (i == 8) break;
                        ++i;
                    }
                    if (dictionary.validateWord((CharSequence)text[1]) != ValidityType.VALID) {
                        resultSet.addItem((CompletionItem)new AddToDictionaryCompletionItem(text[1], true));
                        resultSet.addItem((CompletionItem)new AddToDictionaryCompletionItem(text[1], false));
                    }
                }
            }
            resultSet.finish();
        }
    }
}

