/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.disco;

import eu.hansolo.jdktools.ArchiveType;
import eu.hansolo.jdktools.PackageType;
import eu.hansolo.jdktools.ReleaseStatus;
import eu.hansolo.jdktools.TermOfSupport;
import eu.hansolo.jdktools.versioning.Semver;
import io.foojay.api.discoclient.pkg.Distribution;
import io.foojay.api.discoclient.pkg.Pkg;
import java.util.List;
import java.util.function.Function;
import javax.swing.table.AbstractTableModel;
import org.checkerframework.checker.index.qual.NonNegative;
import org.checkerframework.checker.nullness.qual.NonNull;

public class BundleTableModel
extends AbstractTableModel {
    private static final Column[] COLUMNS = Column.values();
    private List<Pkg> bundles;

    public BundleTableModel(List<Pkg> bundles) {
        this.bundles = bundles;
    }

    public List<Pkg> getBundles() {
        return this.bundles;
    }

    public void setBundles(List<Pkg> bundles) {
        this.bundles = bundles;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.bundles == null ? 0 : this.bundles.size();
    }

    @Override
    public int getColumnCount() {
        return COLUMNS.length;
    }

    @Override
    public @NonNull String getColumnName(int col) {
        return BundleTableModel.COLUMNS[col].colname;
    }

    @Override
    public @NonNull Class<?> getColumnClass(int col) {
        return BundleTableModel.COLUMNS[col].type;
    }

    @Override
    public @NonNull Object getValueAt(@NonNegative int row, @NonNegative int col) {
        return COLUMNS[col].getValueFor(this.bundles.get(row));
    }

    private static enum Column {
        VERSION("Version", Semver.class, bundle -> bundle.getJavaVersion()),
        DISTRIBUTION("Distribution", Distribution.class, bundle -> bundle.getDistribution().getUiString()),
        ARCHITECTURE("Architecture", String.class, bundle -> bundle.getArchitecture().getUiString()),
        LIBC("LibC", String.class, bundle -> bundle.getLibCType().getUiString()),
        BUNDLE("Bundle", PackageType.class, bundle -> bundle.getPackageType().getUiString()),
        SUPPORT("Support", String.class, bundle -> Column.toString(bundle.getTermOfSupport())),
        STATUS("Release Status", ReleaseStatus.class, bundle -> bundle.getReleaseStatus().name()),
        EXTENSION("Extension", ArchiveType.class, bundle -> bundle.getArchiveType().getUiString());

        private final String colname;
        private final Class<?> type;
        private final Function<Pkg, Object> valueMapping;

        private static String toString(TermOfSupport tos) {
            switch (tos) {
                case LTS: {
                    return "LTS";
                }
                case MTS: {
                    return "MTS";
                }
                case STS: {
                    return "STS";
                }
            }
            return "";
        }

        private Column(String name, Class<?> type, Function<Pkg, Object> valueMapping) {
            this.colname = name;
            this.type = type;
            this.valueMapping = valueMapping;
        }

        private Object getValueFor(Pkg bundle) {
            return this.valueMapping.apply(bundle);
        }
    }
}

