/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.cmd;

import io.quarkus.builder.BuildResult;
import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import io.quarkus.deployment.cmd.RunCommandActionBuildItem;
import io.quarkus.deployment.cmd.RunCommandActionResultBuildItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

public class StartDevServicesAndRunCommandHandler
implements BiConsumer<Object, BuildResult> {
    @Override
    public void accept(Object o, BuildResult buildResult) {
        RunCommandActionResultBuildItem runCommandActionResult = (RunCommandActionResultBuildItem)buildResult.consume(RunCommandActionResultBuildItem.class);
        DevServicesLauncherConfigResultBuildItem devServicesLauncherConfigResult = (DevServicesLauncherConfigResultBuildItem)buildResult.consume(DevServicesLauncherConfigResultBuildItem.class);
        Consumer consumer = (Consumer)o;
        HashMap cmds = new HashMap();
        for (RunCommandActionBuildItem item : runCommandActionResult.getCommands()) {
            ArrayList itemList = new ArrayList();
            this.addLaunchCommand(itemList, item, devServicesLauncherConfigResult.getConfig());
            cmds.put(item.getCommandName(), itemList);
        }
        consumer.accept(cmds);
    }

    private void addLaunchCommand(List list, RunCommandActionBuildItem item, Map<String, String> devServicesProperties) {
        List<String> effectiveArgs;
        List<String> originalArgs = item.getArgs();
        if (devServicesProperties.isEmpty()) {
            effectiveArgs = originalArgs;
        } else {
            effectiveArgs = new ArrayList<String>(originalArgs.size() + devServicesProperties.size());
            int jarArgIndex = -1;
            for (int i = 0; i < originalArgs.size(); ++i) {
                if (!originalArgs.get(i).trim().equals("-jar")) continue;
                jarArgIndex = i;
                break;
            }
            if (jarArgIndex == -1) {
                effectiveArgs = originalArgs;
            } else {
                effectiveArgs.addAll(originalArgs.subList(0, jarArgIndex));
                for (Map.Entry<String, String> devServiceConfigEntry : devServicesProperties.entrySet()) {
                    effectiveArgs.add("-D" + devServiceConfigEntry.getKey() + "=" + devServiceConfigEntry.getValue());
                }
                effectiveArgs.addAll(originalArgs.subList(jarArgIndex, originalArgs.size()));
            }
        }
        list.add(effectiveArgs);
        list.add(item.getWorkingDirectory());
        list.add(item.getStartedExpression());
        list.add(item.isNeedsLogfile());
        list.add(item.getLogFile());
    }
}

