/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.models.internal;

import java.util.Map;
import org.hibernate.models.internal.TypeDetailsSwitchSupport;
import org.hibernate.models.internal.TypeDetailsSwitcher;
import org.hibernate.models.spi.ClassDetails;
import org.hibernate.models.spi.ClassTypeDetails;
import org.hibernate.models.spi.ParameterizedTypeDetails;
import org.hibernate.models.spi.StandardTypeDetails;
import org.hibernate.models.spi.TypeDetails;
import org.hibernate.models.spi.TypeVariableDetails;
import org.hibernate.models.spi.TypeVariableReferenceDetails;
import org.hibernate.models.spi.WildcardTypeDetails;

public class MapKeySwitch
extends TypeDetailsSwitchSupport<TypeDetails> {
    private final TypeDetails memberTypeDetails;

    public static TypeDetails extractMapKeyType(TypeDetails memberType) {
        TypeDetails typeDetails;
        assert (memberType.isImplementor(Map.class));
        ClassDetails rawClassDetails = memberType.determineRawClass();
        MapKeySwitch mapKeySwitch = new MapKeySwitch(memberType);
        if (rawClassDetails.getGenericSuperType() != null && (typeDetails = TypeDetailsSwitcher.switchType(rawClassDetails.getGenericSuperType(), mapKeySwitch)) != null) {
            return typeDetails;
        }
        for (TypeDetails implementedInterface : rawClassDetails.getImplementedInterfaces()) {
            TypeDetails typeDetails2 = TypeDetailsSwitcher.switchType(implementedInterface, mapKeySwitch);
            if (typeDetails2 == null) continue;
            return typeDetails2;
        }
        return StandardTypeDetails.OBJECT_TYPE_DETAILS;
    }

    private MapKeySwitch(TypeDetails memberTypeDetails) {
        this.memberTypeDetails = memberTypeDetails;
    }

    @Override
    public TypeDetails caseClass(ClassTypeDetails classType) {
        if (classType.isImplementor(Map.class) && classType.getClassDetails().getGenericSuperType() != null) {
            return TypeDetailsSwitcher.switchType(classType.getClassDetails().getGenericSuperType(), this);
        }
        return null;
    }

    @Override
    public TypeDetails caseParameterizedType(ParameterizedTypeDetails parameterizedType) {
        if (parameterizedType.isImplementor(Map.class)) {
            return parameterizedType.getArguments().get(0);
        }
        return null;
    }

    @Override
    public TypeDetails caseWildcardType(WildcardTypeDetails wildcardType) {
        if (wildcardType.isImplementor(Map.class)) {
            return wildcardType.getBound();
        }
        return null;
    }

    @Override
    public TypeDetails caseTypeVariable(TypeVariableDetails typeVariable) {
        if (typeVariable.isImplementor(Map.class)) {
            return this.memberTypeDetails.resolveTypeVariable(typeVariable);
        }
        return null;
    }

    @Override
    public TypeDetails caseTypeVariableReference(TypeVariableReferenceDetails typeVariableReference) {
        if (typeVariableReference.isImplementor(Map.class)) {
            return this.memberTypeDetails.resolveTypeVariable(typeVariableReference.getTarget());
        }
        return null;
    }
}

