/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.util.Collection;
import org.jboss.invocation.ChainedInterceptor;
import org.jboss.invocation.ChainedInterceptorFactory;
import org.jboss.invocation.InitialInterceptor;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InterceptorFactory;
import org.jboss.invocation.InvocationMessages;
import org.jboss.invocation.InvokingInterceptor;
import org.jboss.invocation.TerminalInterceptor;
import org.jboss.invocation.WeavedInterceptor;

public final class Interceptors {
    private Interceptors() {
    }

    public static Interceptor getInitialInterceptor() {
        return InitialInterceptor.INSTANCE;
    }

    public static InterceptorFactory getInitialInterceptorFactory() {
        return InitialInterceptor.FACTORY;
    }

    public static Interceptor getTerminalInterceptor() {
        return TerminalInterceptor.INSTANCE;
    }

    public static InterceptorFactory getTerminalInterceptorFactory() {
        return TerminalInterceptor.FACTORY;
    }

    public static Interceptor getInvokingInterceptor() {
        return InvokingInterceptor.INSTANCE;
    }

    public static InterceptorFactory getInvokingInterceptorFactory() {
        return InvokingInterceptor.FACTORY;
    }

    public static Interceptor getChainedInterceptor(Interceptor ... instances) {
        return instances.length == 1 ? instances[0] : new ChainedInterceptor(instances);
    }

    public static Interceptor getChainedInterceptor(Collection<Interceptor> instances) {
        int size = instances.size();
        return size == 1 ? instances.iterator().next() : new ChainedInterceptor(instances.toArray(Interceptor.EMPTY_ARRAY));
    }

    public static InterceptorFactory getChainedInterceptorFactory(InterceptorFactory ... instances) {
        return instances.length == 1 ? instances[0] : new ChainedInterceptorFactory(instances);
    }

    public static InterceptorFactory getChainedInterceptorFactory(Collection<InterceptorFactory> instances) {
        int size = instances.size();
        return size == 1 ? instances.iterator().next() : new ChainedInterceptorFactory(instances.toArray(InterceptorFactory.EMPTY_ARRAY));
    }

    public static Interceptor getWeavedInterceptor(Interceptor ... interceptors) {
        return new WeavedInterceptor(interceptors);
    }

    public static Exception rethrow(Throwable throwable) throws Error {
        try {
            throw throwable;
        }
        catch (Error error) {
            throw error;
        }
        catch (Exception exception) {
            return exception;
        }
        catch (Throwable throwable2) {
            return InvocationMessages.msg.undeclaredThrowable(throwable2);
        }
    }
}

