/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.index;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Set;

public class ConstPoolScanner {
    static final int CONSTANT_UTF8_TAG = 1;
    static final int CONSTANT_INTEGER_TAG = 3;
    static final int CONSTANT_FLOAT_TAG = 4;
    static final int CONSTANT_LONG_TAG = 5;
    static final int CONSTANT_DOUBLE_TAG = 6;
    static final int CONSTANT_CLASS_TAG = 7;
    static final int CONSTANT_STRING_TAG = 8;
    static final int CONSTANT_FIELDREF_TAG = 9;
    static final int CONSTANT_METHODREF_TAG = 10;
    static final int CONSTANT_INTERFACE_METHODREF_TAG = 11;
    static final int CONSTANT_NAME_AND_TYPE_TAG = 12;
    static final int CONSTANT_METHOD_HANDLE_TAG = 15;
    static final int CONSTANT_METHOD_TYPE_TAG = 16;
    static final int CONSTANT_DYNAMIC_TAG = 17;
    static final int CONSTANT_INVOKE_DYNAMIC_TAG = 18;
    static final int CONSTANT_MODULE_TAG = 19;
    static final int CONSTANT_PACKAGE_TAG = 20;

    public static boolean constPoolEntryPresent(byte[] classBody, Set<String> namesToLookFor) {
        ByteBuffer data = ByteBuffer.wrap(classBody);
        if (data.getInt() != -889275714) {
            return false;
        }
        data.getShort();
        data.getShort();
        int constantPoolCount = data.getShort();
        int currentCpInfoIndex = 1;
        while (currentCpInfoIndex < constantPoolCount) {
            int cpInfoSize;
            ++currentCpInfoIndex;
            switch (data.get()) {
                case 3: 
                case 4: 
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    cpInfoSize = 4;
                    break;
                }
                case 17: {
                    cpInfoSize = 4;
                    break;
                }
                case 18: {
                    cpInfoSize = 4;
                    break;
                }
                case 5: 
                case 6: {
                    cpInfoSize = 8;
                    ++currentCpInfoIndex;
                    break;
                }
                case 1: {
                    int strLength = 0xFFFF & data.getShort();
                    cpInfoSize = 0;
                    byte[] str = new byte[strLength];
                    data.get(str);
                    if (!namesToLookFor.contains(new String(str, StandardCharsets.UTF_8))) break;
                    return true;
                }
                case 15: {
                    cpInfoSize = 3;
                    break;
                }
                case 7: 
                case 8: 
                case 16: 
                case 19: 
                case 20: {
                    cpInfoSize = 2;
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
            for (int j = 0; j < cpInfoSize; ++j) {
                data.get();
            }
        }
        return false;
    }
}

