/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.theme;

import java.io.IOException;
import java.util.Locale;
import java.util.Properties;
import org.keycloak.theme.Theme;

public abstract class FileBasedTheme
implements Theme {
    protected abstract void loadBundle(String var1, Locale var2, Properties var3) throws IOException;

    public Properties getMessages(String baseBundlename, Locale locale) throws IOException {
        if (locale == null) {
            return null;
        }
        Properties m = new Properties();
        this.loadBundle(baseBundlename, locale, m);
        if (locale.getLanguage().equals("zh") && !locale.getCountry().isEmpty()) {
            Locale l;
            switch (locale.getCountry()) {
                case "TW": {
                    Locale locale2 = Locale.forLanguageTag("zh-Hant");
                    break;
                }
                case "CN": {
                    Locale locale2 = Locale.forLanguageTag("zh-Hans");
                    break;
                }
                default: {
                    Locale locale2 = l = null;
                }
            }
            if (l != null) {
                this.loadBundle(baseBundlename, l, m);
            }
        }
        return m;
    }

    public String toBundleName(String baseName, Locale locale) {
        if (locale == Locale.ROOT) {
            return baseName;
        }
        String language = locale.getLanguage();
        String script = locale.getScript();
        String country = locale.getCountry();
        String variant = locale.getVariant();
        if (language.isEmpty() && country.isEmpty() && variant.isEmpty()) {
            return baseName;
        }
        StringBuilder sb = new StringBuilder(baseName);
        sb.append('_');
        if (!script.isEmpty()) {
            if (!variant.isEmpty()) {
                sb.append(language).append('_').append(script).append('_').append(country).append('_').append(variant);
            } else if (!country.isEmpty()) {
                sb.append(language).append('_').append(script).append('_').append(country);
            } else {
                sb.append(language).append('_').append(script);
            }
        } else if (!variant.isEmpty()) {
            sb.append(language).append('_').append(country).append('_').append(variant);
        } else if (!country.isEmpty()) {
            sb.append(language).append('_').append(country);
        } else {
            sb.append(language);
        }
        return sb.toString();
    }
}

