/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.resources.admin;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.UriInfo;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.eclipse.microprofile.openapi.annotations.extensions.Extension;
import org.eclipse.microprofile.openapi.annotations.parameters.Parameter;
import org.eclipse.microprofile.openapi.annotations.responses.APIResponse;
import org.eclipse.microprofile.openapi.annotations.tags.Tag;
import org.jboss.resteasy.reactive.NoCache;
import org.keycloak.events.admin.OperationType;
import org.keycloak.events.admin.ResourceType;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.ScopeContainerModel;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.idm.ClientMappingsRepresentation;
import org.keycloak.representations.idm.MappingsRepresentation;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.ScopeMappedClientResource;
import org.keycloak.services.resources.admin.fgap.AdminPermissionEvaluator;
import org.keycloak.services.util.ScopeMappedUtil;

@Extension(name="x-smallrye-profile-admin", value="")
public class ScopeMappedResource {
    protected RealmModel realm;
    protected AdminPermissionEvaluator auth;
    protected AdminPermissionEvaluator.RequirePermissionCheck managePermission;
    protected AdminPermissionEvaluator.RequirePermissionCheck viewPermission;
    protected ScopeContainerModel scopeContainer;
    protected KeycloakSession session;
    protected AdminEventBuilder adminEvent;

    public ScopeMappedResource(RealmModel realm, AdminPermissionEvaluator auth, ScopeContainerModel scopeContainer, KeycloakSession session, AdminEventBuilder adminEvent, AdminPermissionEvaluator.RequirePermissionCheck managePermission, AdminPermissionEvaluator.RequirePermissionCheck viewPermission) {
        this.realm = realm;
        this.auth = auth;
        this.scopeContainer = scopeContainer;
        this.session = session;
        this.adminEvent = adminEvent.resource(ResourceType.REALM_SCOPE_MAPPING);
        this.managePermission = managePermission;
        this.viewPermission = viewPermission;
    }

    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Deprecated
    @Tag(name="Scope Mappings")
    @Operation(summary="Get all scope mappings for the client", deprecated=true)
    public MappingsRepresentation getScopeMappings() {
        Stream clients;
        Map clientMappings;
        this.viewPermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        MappingsRepresentation all = new MappingsRepresentation();
        List realmRep = this.scopeContainer.getRealmScopeMappingsStream().map(ModelToRepresentation::toBriefRepresentation).collect(Collectors.toList());
        if (!realmRep.isEmpty()) {
            all.setRealmMappings(realmRep);
        }
        if (!(clientMappings = (clients = this.realm.getClientsStream()).map(c -> ScopeMappedUtil.toClientMappingsRepresentation(c, this.scopeContainer)).filter(Objects::nonNull).collect(Collectors.toMap(ClientMappingsRepresentation::getClient, Function.identity()))).isEmpty()) {
            all.setClientMappings(clientMappings);
        }
        return all;
    }

    @Path(value="realm")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Scope Mappings")
    @Operation(summary="Get realm-level roles associated with the client's scope")
    public Stream<RoleRepresentation> getRealmScopeMappings() {
        this.viewPermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        return this.scopeContainer.getRealmScopeMappingsStream().map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="realm/available")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Scope Mappings")
    @Operation(summary="Get realm-level roles that are available to attach to this client's scope")
    public Stream<RoleRepresentation> getAvailableRealmScopeMappings() {
        this.viewPermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        return this.realm.getRolesStream().filter(((Predicate<RoleModel>)arg_0 -> ((ScopeContainerModel)this.scopeContainer).hasDirectScope(arg_0)).negate()).filter(this.auth.roles()::canMapClientScope).map(ModelToRepresentation::toBriefRepresentation);
    }

    @Path(value="realm/composite")
    @GET
    @Produces(value={"application/json"})
    @NoCache
    @Tag(name="Scope Mappings")
    @Operation(summary="Get effective realm-level roles associated with the client\u2019s scope What this does is recurse any composite roles associated with the client\u2019s scope and adds the roles to this lists.", description="The method is really to show a comprehensive total view of realm-level roles associated with the client.")
    public Stream<RoleRepresentation> getCompositeRealmScopeMappings(@Parameter(description="if false, return roles with their attributes") @QueryParam(value="briefRepresentation") @DefaultValue(value="true") boolean briefRepresentation) {
        this.viewPermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        Function<RoleModel, RoleRepresentation> toBriefRepresentation = briefRepresentation ? ModelToRepresentation::toBriefRepresentation : ModelToRepresentation::toRepresentation;
        return this.realm.getRolesStream().filter(arg_0 -> ((ScopeContainerModel)this.scopeContainer).hasScope(arg_0)).map(toBriefRepresentation);
    }

    @Path(value="realm")
    @POST
    @Consumes(value={"application/json"})
    @Tag(name="Scope Mappings")
    @Operation(summary="Add a set of realm-level roles to the client's scope")
    @APIResponse(responseCode="204", description="No Content")
    public void addRealmScopeMappings(List<RoleRepresentation> roles) {
        this.managePermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        for (RoleRepresentation role : roles) {
            RoleModel roleModel = this.realm.getRoleById(role.getId());
            if (roleModel == null) {
                throw new NotFoundException("Role not found");
            }
            this.scopeContainer.addScopeMapping(roleModel);
        }
        this.adminEvent.operation(OperationType.CREATE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(roles).success();
    }

    @Path(value="realm")
    @DELETE
    @Consumes(value={"application/json"})
    @Tag(name="Scope Mappings")
    @Operation(summary="Remove a set of realm-level roles from the client's scope")
    public void deleteRealmScopeMappings(List<RoleRepresentation> roles) {
        this.managePermission.require();
        if (this.scopeContainer == null) {
            throw new NotFoundException("Could not find client");
        }
        if (roles == null) {
            roles = this.scopeContainer.getRealmScopeMappingsStream().peek(arg_0 -> ((ScopeContainerModel)this.scopeContainer).deleteScopeMapping(arg_0)).map(ModelToRepresentation::toBriefRepresentation).collect(Collectors.toList());
        } else {
            for (RoleRepresentation role : roles) {
                RoleModel roleModel = this.realm.getRoleById(role.getId());
                if (roleModel == null) {
                    throw new NotFoundException("Role not found");
                }
                this.scopeContainer.deleteScopeMapping(roleModel);
            }
        }
        this.adminEvent.operation(OperationType.DELETE).resourcePath((UriInfo)this.session.getContext().getUri()).representation(roles).success();
    }

    @Path(value="clients/{client}")
    public ScopeMappedClientResource getClientByIdScopeMappings(@PathParam(value="client") String client) {
        ClientModel clientModel = this.realm.getClientById(client);
        if (clientModel == null) {
            throw new NotFoundException("Could not find client");
        }
        return new ScopeMappedClientResource(this.realm, this.auth, this.scopeContainer, this.session, clientModel, this.adminEvent, this.managePermission, this.viewPermission);
    }
}

