/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.vertx.codegen.lang;

import io.smallrye.mutiny.vertx.codegen.lang.CodeGenHelper;
import io.smallrye.mutiny.vertx.codegen.lang.ConditionalCodeWriter;
import io.vertx.codegen.ClassModel;
import io.vertx.codegen.Helper;
import io.vertx.codegen.TypeParamInfo;
import java.io.PrintWriter;
import java.util.List;

public class ConstructorWithObjectDelegateCodeWriter
implements ConditionalCodeWriter {
    private final String constructor;

    public ConstructorWithObjectDelegateCodeWriter(String constructor) {
        this.constructor = constructor;
    }

    public ConstructorWithObjectDelegateCodeWriter() {
        this.constructor = null;
    }

    @Override
    public void generate(ClassModel model, PrintWriter writer) {
        String cst = this.constructor;
        if (cst == null) {
            cst = model.getIfaceSimpleName();
        }
        List typeParams = model.getTypeParams();
        writer.print("  public ");
        writer.print(cst);
        writer.print("(Object delegate");
        for (TypeParamInfo.Class typeParam : typeParams) {
            writer.print(", TypeArg<");
            writer.print(typeParam.getName());
            writer.print("> typeArg_");
            writer.print(typeParam.getIndex());
        }
        writer.println(") {");
        if (CodeGenHelper.hasParentClass(model)) {
            writer.print("    super((");
            writer.print(Helper.getNonGenericType((String)model.getIfaceFQCN()));
            writer.println(")delegate);");
        }
        writer.print("    this.delegate = (");
        writer.print(Helper.getNonGenericType((String)model.getIfaceFQCN()));
        writer.println(")delegate;");
        for (TypeParamInfo.Class typeParam : typeParams) {
            writer.print("    this.__typeArg_");
            writer.print(typeParam.getIndex());
            writer.print(" = typeArg_");
            writer.print(typeParam.getIndex());
            writer.println(";");
        }
        writer.println("  }");
        writer.println();
    }

    @Override
    public boolean test(ClassModel classModel) {
        return classModel.isConcrete();
    }
}

