/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine;

import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.execution.ui.layout.PlaceInGrid;
import com.intellij.execution.ui.layout.impl.RunnerContentUi;
import com.intellij.execution.ui.layout.impl.RunnerLayoutUiImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.service.execution.ExternalSystemRunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XSuspendContext;
import com.intellij.xdebugger.impl.FrontendXDebuggerManagerListener;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.frame.XDebugSessionProxy;
import com.intellij.xdebugger.impl.rpc.XDebugSessionId;
import com.intellij.xdebugger.impl.ui.XDebugSessionTab;
import com.intellij.xdebugger.impl.util.MonolithUtils;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutineAgentConnector;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CreateContentParams;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CreateContentParamsProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.view.CoroutineView;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 .2\u00020\u00012\u00020\u0002:\u0001.B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\n2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001f\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\"\u0010 \u001a\u0004\u0018\u00010\u00022\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0002J\b\u0010&\u001a\u00020\nH\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0002J\b\u0010-\u001a\u00020\u001bH\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/DebuggerConnection;", "Lcom/intellij/xdebugger/impl/FrontendXDebuggerManagerListener;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "configuration", "Lcom/intellij/execution/configurations/RunConfigurationBase;", "params", "Lcom/intellij/execution/configurations/JavaParameters;", "shouldAttachCoroutineAgent", "", "alwaysShowPanel", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/RunConfigurationBase;Lcom/intellij/execution/configurations/JavaParameters;ZZ)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getConfiguration", "()Lcom/intellij/execution/configurations/RunConfigurationBase;", "getParams", "()Lcom/intellij/execution/configurations/JavaParameters;", "getAlwaysShowPanel", "()Z", "connection", "Lcom/intellij/util/messages/MessageBusConnection;", "coroutineAgentAttached", "isDisposed", "sessionStarted", "", "session", "Lcom/intellij/xdebugger/impl/frame/XDebugSessionProxy;", "coroutinePanelIsRegistered", "sessionStopped", "registerXCoroutinesPanel", "sessionProxy", "javaDebugProcess", "Lcom/intellij/debugger/engine/JavaDebugProcess;", "monolithSession", "Lcom/intellij/xdebugger/XDebugSession;", "coroutinesPanelShouldBeShown", "createContent", "Lcom/intellij/ui/content/Content;", "ui", "Lcom/intellij/execution/ui/RunnerLayoutUi;", "createContentParamProvider", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/util/CreateContentParamsProvider;", "dispose", "Companion", "intellij.kotlin.jvm.debugger.coroutines"})
public final class DebuggerConnection
implements FrontendXDebuggerManagerListener,
Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private final RunConfigurationBase<?> configuration;
    @Nullable
    private final JavaParameters params;
    private final boolean alwaysShowPanel;
    @Nullable
    private MessageBusConnection connection;
    private final boolean coroutineAgentAttached;
    private boolean isDisposed;
    @NotNull
    private static final ReadOnlyProperty<Object, Logger> log$delegate = ProvidersKt.getLogger();

    public DebuggerConnection(@NotNull Project project, @Nullable RunConfigurationBase<?> configuration2, @Nullable JavaParameters params, boolean shouldAttachCoroutineAgent, boolean alwaysShowPanel) {
        block2: {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            this.project = project;
            this.configuration = configuration2;
            this.params = params;
            this.alwaysShowPanel = alwaysShowPanel;
            if (this.params != null && shouldAttachCoroutineAgent) {
                this.coroutineAgentAttached = CoroutineAgentConnector.INSTANCE.attachCoroutineAgent(this.project, this.configuration, this.params);
            } else {
                this.coroutineAgentAttached = false;
                DebuggerConnection.Companion.getLog().debug("Coroutine debugger disabled.");
            }
            MessageBusConnection messageBusConnection = this.connection = this.project.getMessageBus().connect();
            if (messageBusConnection == null) break block2;
            messageBusConnection.subscribe(FrontendXDebuggerManagerListener.TOPIC, (Object)this);
        }
    }

    public /* synthetic */ DebuggerConnection(Project project, RunConfigurationBase runConfigurationBase, JavaParameters javaParameters, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x10) != 0) {
            bl2 = false;
        }
        this(project, runConfigurationBase, javaParameters, bl, bl2);
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Nullable
    public final RunConfigurationBase<?> getConfiguration() {
        return this.configuration;
    }

    @Nullable
    public final JavaParameters getParams() {
        return this.params;
    }

    public final boolean getAlwaysShowPanel() {
        return this.alwaysShowPanel;
    }

    public void sessionStarted(@NotNull XDebugSessionProxy session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        XDebugSessionImpl xDebugSessionImpl = MonolithUtils.findSessionById((XDebugSessionId)session2.getId());
        if (xDebugSessionImpl == null) {
            return;
        }
        XDebugSessionImpl monolithSession = xDebugSessionImpl;
        BuildersKt.launch$default((CoroutineScope)session2.getCoroutineScope(), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(session2, monolithSession, this, null){
            int label;
            final /* synthetic */ XDebugSessionProxy $session;
            final /* synthetic */ XDebugSessionImpl $monolithSession;
            final /* synthetic */ DebuggerConnection this$0;
            {
                this.$session = $session;
                this.$monolithSession = $monolithSession;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var7_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        v0 = this.$session.getSessionTabWhenInitialized().await((Continuation)this);
                        if (v0 == var7_2) {
                            return var7_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        if ((debugProcess = this.$monolithSession.getDebugProcess()) instanceof JavaDebugProcess && !DebuggerConnection.access$isDisposed$p(this.this$0) && DebuggerConnection.access$coroutinesPanelShouldBeShown(this.this$0) && !DebuggerConnection.access$coroutinePanelIsRegistered(this.this$0, this.$session)) {
                            v1 = DebuggerConnection.access$registerXCoroutinesPanel(this.this$0, this.$session, (JavaDebugProcess)debugProcess, (XDebugSession)this.$monolithSession);
                            if (v1 != null) {
                                var3_4 = v1;
                                var4_5 = this.this$0;
                                it = var3_4;
                                $i$a$-let-DebuggerConnection$sessionStarted$1$1 = false;
                                Disposer.register((Disposable)var4_5, (Disposable)it);
                            }
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null);
    }

    private final boolean coroutinePanelIsRegistered(XDebugSessionProxy session2) {
        XDebugSessionTab xDebugSessionTab = session2.getSessionTab();
        RunnerLayoutUi runnerLayoutUi = xDebugSessionTab != null ? xDebugSessionTab.getUi() : null;
        RunnerLayoutUiImpl runnerLayoutUiImpl = runnerLayoutUi instanceof RunnerLayoutUiImpl ? (RunnerLayoutUiImpl)runnerLayoutUi : null;
        if (runnerLayoutUiImpl == null) {
            return false;
        }
        RunnerLayoutUiImpl ui = runnerLayoutUiImpl;
        RunnerContentUi runnerContentUi = ui.getContentUI();
        Intrinsics.checkNotNullExpressionValue((Object)runnerContentUi, (String)"getContentUI(...)");
        RunnerContentUi contentUi = runnerContentUi;
        Content content = (Content)ActionsKt.invokeAndWaitIfNeeded$default(null, () -> DebuggerConnection.coroutinePanelIsRegistered$lambda$0(contentUi), (int)1, null);
        return content != null;
    }

    public void sessionStopped(@NotNull XDebugSessionProxy session2) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        ApplicationManager.getApplication().invokeLater(() -> DebuggerConnection.sessionStopped$lambda$0(this));
    }

    private final Disposable registerXCoroutinesPanel(XDebugSessionProxy sessionProxy, JavaDebugProcess javaDebugProcess, XDebugSession monolithSession) {
        XDebugSessionTab xDebugSessionTab = sessionProxy.getSessionTab();
        if (xDebugSessionTab == null || (xDebugSessionTab = xDebugSessionTab.getUi()) == null) {
            return null;
        }
        XDebugSessionTab ui = xDebugSessionTab;
        CoroutineView coroutineThreadView = new CoroutineView(this.project, javaDebugProcess);
        Content framesContent = this.createContent((RunnerLayoutUi)ui, coroutineThreadView);
        framesContent.setCloseable(false);
        ui.addContent(framesContent, 0, PlaceInGrid.right, true);
        ui.addListener(new ContentManagerListener(framesContent, monolithSession, coroutineThreadView){
            final /* synthetic */ Content $framesContent;
            final /* synthetic */ XDebugSession $monolithSession;
            final /* synthetic */ CoroutineView $coroutineThreadView;
            {
                this.$framesContent = $framesContent;
                this.$monolithSession = $monolithSession;
                this.$coroutineThreadView = $coroutineThreadView;
            }

            public void selectionChanged(ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Content content = event.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)content, (String)"getContent(...)");
                Content content2 = content;
                if (Intrinsics.areEqual((Object)content2, (Object)this.$framesContent) && content2.isSelected()) {
                    XSuspendContext suspendContext = this.$monolithSession.getSuspendContext();
                    if (suspendContext instanceof SuspendContextImpl) {
                        this.$coroutineThreadView.renewRoot((SuspendContextImpl)suspendContext);
                    } else {
                        this.$coroutineThreadView.resetRoot();
                    }
                }
            }
        }, (Disposable)this);
        monolithSession.addSessionListener(coroutineThreadView.debugSessionListener(monolithSession));
        sessionProxy.rebuildViews();
        return coroutineThreadView;
    }

    private final boolean coroutinesPanelShouldBeShown() {
        return this.alwaysShowPanel || this.configuration instanceof ExternalSystemRunConfiguration || this.coroutineAgentAttached;
    }

    private final Content createContent(RunnerLayoutUi ui, CreateContentParamsProvider createContentParamProvider) {
        CreateContentParams param = createContentParamProvider.createContentParams();
        Content content = ui.createContent(param.getId(), param.getComponent(), param.getDisplayName(), param.getIcon(), param.getParentComponent());
        Intrinsics.checkNotNullExpressionValue((Object)content, (String)"createContent(...)");
        return content;
    }

    public void dispose() {
        this.isDisposed = true;
        MessageBusConnection messageBusConnection = this.connection;
        if (messageBusConnection != null) {
            messageBusConnection.disconnect();
        }
        this.connection = null;
    }

    private static final Content coroutinePanelIsRegistered$lambda$0(RunnerContentUi $contentUi) {
        return $contentUi.findContent("XCoroutineThreadsContent");
    }

    private static final void sessionStopped$lambda$0(DebuggerConnection this$0) {
        Disposer.dispose((Disposable)this$0);
    }

    public static final /* synthetic */ boolean access$isDisposed$p(DebuggerConnection $this) {
        return $this.isDisposed;
    }

    public static final /* synthetic */ boolean access$coroutinesPanelShouldBeShown(DebuggerConnection $this) {
        return $this.coroutinesPanelShouldBeShown();
    }

    public static final /* synthetic */ boolean access$coroutinePanelIsRegistered(DebuggerConnection $this, XDebugSessionProxy session2) {
        return $this.coroutinePanelIsRegistered(session2);
    }

    public static final /* synthetic */ Disposable access$registerXCoroutinesPanel(DebuggerConnection $this, XDebugSessionProxy sessionProxy, JavaDebugProcess javaDebugProcess, XDebugSession monolithSession) {
        return $this.registerXCoroutinesPanel(sessionProxy, javaDebugProcess, monolithSession);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/DebuggerConnection$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "intellij.kotlin.jvm.debugger.coroutines"})
    public static final class Companion {
        static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;

        private Companion() {
        }

        private final Logger getLog() {
            return (Logger)log$delegate.getValue((Object)this, $$delegatedProperties[0]);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        static {
            KProperty[] kPropertyArray = new KProperty[]{Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0)))};
            $$delegatedProperties = kPropertyArray;
        }
    }
}

