/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.performancePlugin.commands;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ModalityKt;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.util.system.OS;
import com.intellij.util.ui.ImageUtil;
import com.intellij.util.ui.StartupUiUtil;
import com.jetbrains.performancePlugin.commands.TakeScreenshotCommand;
import com.jetbrains.performancePlugin.commands.TakeScreenshotCommandKt;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\t\u001a\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086@\u00a2\u0006\u0002\u0010\u0010\u001a\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u000f\u001a\u0014\u0010\u0013\u001a\u00020\u00072\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0000\u001a\u0016\u0010\u0015\u001a\u0004\u0018\u00010\t2\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0000\u001a\u001a\u0010\u0016\u001a\u00020\u00072\n\b\u0002\u0010\u0014\u001a\u0004\u0018\u00010\tH\u0080@\u00a2\u0006\u0002\u0010\u0017\u001a\u0010\u0010\u0018\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "getLOG", "()Lcom/intellij/openapi/diagnostic/Logger;", "screenshotSequence", "Ljava/util/concurrent/atomic/AtomicInteger;", "takeScreenshotWithAwtRobot", "", "fullPathToFile", "", "formatName", "captureComponent", "component", "Ljava/awt/Component;", "file", "Ljava/io/File;", "(Ljava/awt/Component;Ljava/io/File;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getNextFolder", "base", "takeScreenshotOfAllWindowsBlocking", "childFolder", "takeFullScreenshot", "takeScreenshotOfAllWindows", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "toLoggedImageLink", "intellij.performanceTesting"})
@SourceDebugExtension(value={"SMAP\nTakeScreenshotCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TakeScreenshotCommand.kt\ncom/jetbrains/performancePlugin/commands/TakeScreenshotCommandKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,164:1\n13#2:165\n*S KotlinDebug\n*F\n+ 1 TakeScreenshotCommand.kt\ncom/jetbrains/performancePlugin/commands/TakeScreenshotCommandKt\n*L\n23#1:165\n*E\n"})
public final class TakeScreenshotCommandKt {
    @NotNull
    private static final AtomicInteger screenshotSequence = new AtomicInteger(1);

    private static final Logger getLOG() {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(TakeScreenshotCommand.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    public static final void takeScreenshotWithAwtRobot(@NotNull String fullPathToFile, @NotNull String formatName) {
        Intrinsics.checkNotNullParameter((Object)fullPathToFile, (String)"fullPathToFile");
        Intrinsics.checkNotNullParameter((Object)formatName, (String)"formatName");
        Rectangle rectangle = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        try {
            Robot robot = new Robot();
            BufferedImage img = robot.createScreenCapture(rectangle);
            File screenshotFile = new File(fullPathToFile);
            ImageIO.write((RenderedImage)img, formatName, screenshotFile);
            if (screenshotFile.exists()) {
                TakeScreenshotCommandKt.getLOG().info("Screenshot saved: " + fullPathToFile);
            }
        }
        catch (AWTException e) {
            TakeScreenshotCommandKt.getLOG().info("Exceptions occurs at attempt to create Robot for taking screenshot");
            TakeScreenshotCommandKt.getLOG().info((Throwable)e);
        }
        catch (IOException e) {
            TakeScreenshotCommandKt.getLOG().info("Exceptions occurs at attempt to write screenshot to file");
            TakeScreenshotCommandKt.getLOG().info((Throwable)e);
        }
    }

    public static /* synthetic */ void takeScreenshotWithAwtRobot$default(String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "jpg";
        }
        TakeScreenshotCommandKt.takeScreenshotWithAwtRobot(string, string2);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object captureComponent(@NotNull Component component, @NotNull File file, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof captureComponent.1)) ** GOTO lbl-1000
        var6_3 = $completion;
        if ((var6_3.label & -2147483648) != 0) {
            var6_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TakeScreenshotCommandKt.captureComponent(null, null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var7_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (component.getWidth() == 0 || component.getHeight() == 0) {
                    TakeScreenshotCommandKt.getLOG().info(component.getName() + " has zero size, skipping");
                    TakeScreenshotCommandKt.getLOG().info(component.getClass().toString());
                    return Unit.INSTANCE;
                }
                v0 = ImageUtil.createImage((int)component.getWidth(), (int)component.getHeight(), (int)2);
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"createImage(...)");
                image = v0;
                v1 = image.createGraphics();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"createGraphics(...)");
                g = v1;
                component.paint(g);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)component);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)file);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)image);
                $continuation.L$3 = g;
                $continuation.label = 1;
                v2 = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getIO()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Object>, Object>(image, file, null){
                    int label;
                    final /* synthetic */ BufferedImage $image;
                    final /* synthetic */ File $file;
                    {
                        this.$image = $image;
                        this.$file = $file;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object $result) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                Object object;
                                ResultKt.throwOnFailure((Object)$result);
                                try {
                                    object = Boxing.boxBoolean((boolean)ImageIO.write((RenderedImage)this.$image, "png", this.$file));
                                }
                                catch (IOException e) {
                                    TakeScreenshotCommandKt.access$getLOG().info((Throwable)e);
                                    object = Unit.INSTANCE;
                                }
                                return object;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<Object> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v2 == var7_5) {
                    return var7_5;
                }
                ** GOTO lbl39
            }
            case 1: {
                g = (Graphics2D)$continuation.L$3;
                image = (BufferedImage)$continuation.L$2;
                file = (File)$continuation.L$1;
                component = (Component)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v2 = $result;
lbl39:
                // 2 sources

                g.dispose();
                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    @NotNull
    public static final File getNextFolder(@NotNull File base) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        String string = "%03d";
        Object[] objectArray = new Object[]{screenshotSequence.getAndIncrement()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String counter = string2;
        String name = counter + "_" + base.getName();
        File folder = new File(base.getParentFile(), name);
        folder.mkdirs();
        return folder;
    }

    public static final void takeScreenshotOfAllWindowsBlocking(@Nullable String childFolder) {
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(childFolder, null){
            int label;
            final /* synthetic */ String $childFolder;
            {
                this.$childFolder = $childFolder;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = TakeScreenshotCommandKt.takeScreenshotOfAllWindows(this.$childFolder, (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
    }

    public static /* synthetic */ void takeScreenshotOfAllWindowsBlocking$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        TakeScreenshotCommandKt.takeScreenshotOfAllWindowsBlocking(string);
    }

    @Nullable
    public static final String takeFullScreenshot(@Nullable String childFolder) {
        if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return null;
        }
        if (StartupUiUtil.isWayland()) {
            return null;
        }
        String string = PathManager.getLogPath();
        String string2 = childFolder;
        if (string2 == null) {
            string2 = "default";
        }
        File screenshotPath = new File(string + "/screenshots/" + string2);
        screenshotPath = TakeScreenshotCommandKt.getNextFolder(screenshotPath);
        File screenshotPathWithFile = FilesKt.resolve((File)screenshotPath, (String)"full_screen.png");
        String string3 = screenshotPathWithFile.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
        TakeScreenshotCommandKt.takeScreenshotWithAwtRobot(string3, "png");
        if (screenshotPathWithFile.exists()) {
            return screenshotPathWithFile.getAbsolutePath();
        }
        return null;
    }

    public static /* synthetic */ String takeFullScreenshot$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return TakeScreenshotCommandKt.takeFullScreenshot(string);
    }

    /*
     * Unable to fully structure code
     */
    @Nullable
    public static final Object takeScreenshotOfAllWindows(@Nullable String childFolder, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof takeScreenshotOfAllWindows.1)) ** GOTO lbl-1000
        var9_2 = $completion;
        if ((var9_2.label & -2147483648) != 0) {
            var9_2.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl($completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                int I$1;
                /* synthetic */ Object result;
                int label;

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TakeScreenshotCommandKt.takeScreenshotOfAllWindows(null, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (ApplicationManager.getApplication().isHeadlessEnvironment()) {
                    return Unit.INSTANCE;
                }
                v0 = ProjectManager.getInstance().getOpenProjects();
                Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getOpenProjects(...)");
                projects = v0;
                screenshotPath = new Ref.ObjectRef();
                v1 = PathManager.getLogPath();
                v2 = childFolder;
                if (v2 == null) {
                    v2 = "default";
                }
                screenshotPath.element = new File(v1 + "/screenshots/" + v2);
                screenshotPath.element = TakeScreenshotCommandKt.getNextFolder((File)screenshotPath.element);
                var4_7 = 0;
                var5_8 = projects.length;
lbl26:
                // 2 sources

                while (var4_7 < var5_8) {
                    var7_10 = projects[var4_7];
                    Intrinsics.checkNotNull((Object)var7_10);
                    project = var7_10;
                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)childFolder);
                    $continuation.L$1 = projects;
                    $continuation.L$2 = screenshotPath;
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.I$0 = var4_7;
                    $continuation.I$1 = var5_8;
                    $continuation.label = 1;
                    v3 = TimeoutKt.withTimeout-KLykuaI((long)DurationKt.toDuration((int)30, (DurationUnit)DurationUnit.SECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(projects, project, (Ref.ObjectRef<File>)screenshotPath, null){
                        int label;
                        final /* synthetic */ Project[] $projects;
                        final /* synthetic */ Project $project;
                        final /* synthetic */ Ref.ObjectRef<File> $screenshotPath;
                        {
                            this.$projects = $projects;
                            this.$project = $project;
                            this.$screenshotPath = $screenshotPath;
                            super(2, $completion);
                        }

                        /*
                         * Enabled force condition propagation
                         * Lifted jumps to return sites
                         */
                        public final Object invokeSuspend(Object $result) {
                            Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    CoroutineContext coroutineContext = CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE);
                                    ModalityState modalityState = ModalityState.any();
                                    Intrinsics.checkNotNullExpressionValue((Object)modalityState, (String)"any(...)");
                                    this.label = 1;
                                    Object object2 = BuildersKt.withContext((CoroutineContext)coroutineContext.plus(ModalityKt.asContextElement((ModalityState)modalityState)), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$projects, this.$project, this.$screenshotPath, null){
                                        Object L$0;
                                        Object L$1;
                                        Object L$2;
                                        Object L$3;
                                        int I$0;
                                        int I$1;
                                        int label;
                                        final /* synthetic */ Project[] $projects;
                                        final /* synthetic */ Project $project;
                                        final /* synthetic */ Ref.ObjectRef<File> $screenshotPath;
                                        {
                                            this.$projects = $projects;
                                            this.$project = $project;
                                            this.$screenshotPath = $screenshotPath;
                                            super(2, $completion);
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        public final Object invokeSuspend(Object $result) {
                                            var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch (this.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    prefix = this.$projects.length == 1 ? "" : this.$project.getName() + "_";
                                                    v0 = Window.getWindows();
                                                    Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"getWindows(...)");
                                                    var3_4 = v0;
                                                    var4_5 = 0;
                                                    var5_6 = var3_4.length;
lbl11:
                                                    // 2 sources

                                                    while (var4_5 < var5_6) {
                                                        it = var3_4[var4_5];
                                                        TakeScreenshotCommandKt.access$getLOG().info("Capturing screenshot of " + it.getClass());
                                                        file = new File((File)this.$screenshotPath.element, prefix + it.getName() + ".png");
                                                        Intrinsics.checkNotNull((Object)it);
                                                        this.L$0 = prefix;
                                                        this.L$1 = var3_4;
                                                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)it);
                                                        this.L$3 = file;
                                                        this.I$0 = var4_5;
                                                        this.I$1 = var5_6;
                                                        this.label = 1;
                                                        v1 = TakeScreenshotCommandKt.captureComponent(it, file, (Continuation<? super Unit>)((Continuation)this));
                                                        if (v1 == var8_2) {
                                                            return var8_2;
                                                        }
                                                        ** GOTO lbl37
                                                    }
                                                    break;
                                                }
                                                case 1: {
                                                    var5_6 = this.I$1;
                                                    var4_5 = this.I$0;
                                                    file = (File)this.L$3;
                                                    it = (Window)this.L$2;
                                                    var3_4 = (Window[])this.L$1;
                                                    prefix = (String)this.L$0;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v1 = $result;
lbl37:
                                                    // 2 sources

                                                    TakeScreenshotCommandKt.access$getLOG().warn("Screenshot saved to:\n" + TakeScreenshotCommandKt.access$toLoggedImageLink(file));
                                                    ++var4_5;
                                                    ** GOTO lbl11
                                                }
                                            }
                                            return Unit.INSTANCE;
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }

                                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                        }

                                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                        }
                                    }), (Continuation)((Continuation)this));
                                    if (object2 != object) return Unit.INSTANCE;
                                    return object;
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    Object object2 = $result;
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (Continuation)$continuation);
                    ** if (v3 != var10_4) goto lbl43
lbl42:
                    // 1 sources

                    return var10_4;
lbl43:
                    // 1 sources

                    ** GOTO lbl59
                }
                break;
            }
            case 1: {
                var5_8 = $continuation.I$1;
                var4_7 = $continuation.I$0;
                project = (Project)$continuation.L$3;
                screenshotPath = (Ref.ObjectRef)$continuation.L$2;
                projects = (Project[])$continuation.L$1;
                childFolder = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v3 = $result;
                }
                catch (TimeoutCancellationException e) {
                    TakeScreenshotCommandKt.getLOG().info((Throwable)e);
                }
lbl59:
                // 3 sources

                ++var4_7;
                ** GOTO lbl26
            }
        }
        return Unit.INSTANCE;
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object takeScreenshotOfAllWindows$default(String string, Continuation continuation, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        return TakeScreenshotCommandKt.takeScreenshotOfAllWindows(string, (Continuation<? super Unit>)continuation);
    }

    private static final String toLoggedImageLink(File file) {
        if (OS.CURRENT == OS.Windows) {
            String string = file.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            return "file:///" + StringsKt.replace$default((String)string, (char)'\\', (char)'/', (boolean)false, (int)4, null);
        }
        return "file://" + file.getAbsolutePath();
    }

    public static final /* synthetic */ Logger access$getLOG() {
        return TakeScreenshotCommandKt.getLOG();
    }

    public static final /* synthetic */ String access$toLoggedImageLink(File file) {
        return TakeScreenshotCommandKt.toLoggedImageLink(file);
    }
}

