/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.Feature;
import jogamp.graph.font.typecast.ot.table.Lookup;
import jogamp.graph.font.typecast.ot.table.LookupSubtableFactory;

public class LookupList {
    private int _lookupCount;
    private int[] _lookupOffsets;
    private Lookup[] _lookups;

    public LookupList(DataInputStream dataInputStream, int n, LookupSubtableFactory lookupSubtableFactory) throws IOException {
        int n2;
        dataInputStream.reset();
        dataInputStream.skipBytes(n);
        this._lookupCount = dataInputStream.readUnsignedShort();
        this._lookupOffsets = new int[this._lookupCount];
        this._lookups = new Lookup[this._lookupCount];
        for (n2 = 0; n2 < this._lookupCount; ++n2) {
            this._lookupOffsets[n2] = dataInputStream.readUnsignedShort();
        }
        for (n2 = 0; n2 < this._lookupCount; ++n2) {
            this._lookups[n2] = new Lookup(lookupSubtableFactory, dataInputStream, n + this._lookupOffsets[n2]);
        }
    }

    public int getLookupCount() {
        return this._lookupCount;
    }

    public int getLookupOffset(int n) {
        return this._lookupOffsets[n];
    }

    public Lookup getLookup(int n) {
        return this._lookups[n];
    }

    public Lookup getLookup(Feature feature, int n) {
        if (feature.getLookupCount() > n) {
            int n2 = feature.getLookupListIndex(n);
            return this._lookups[n2];
        }
        return null;
    }
}

