/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.List;
import java.util.Locale;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.TileType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.server.model.ServerUnit;
import net.sf.freecol.util.test.FreeColTestCase;

public class GoodsTest
extends FreeColTestCase {
    private static final GoodsType bellsType = GoodsTest.spec().getGoodsType("model.goods.bells");
    private static final GoodsType clothType = GoodsTest.spec().getGoodsType("model.goods.cloth");
    private static final GoodsType cottonType = GoodsTest.spec().getGoodsType("model.goods.cotton");
    private static final GoodsType crossesType = GoodsTest.spec().getGoodsType("model.goods.crosses");
    private static final GoodsType fishType = GoodsTest.spec().getGoodsType("model.goods.fish");
    private static final GoodsType foodType = GoodsTest.spec().getPrimaryFoodType();
    private static final GoodsType grainType = GoodsTest.spec().getGoodsType("model.goods.grain");
    private static final GoodsType hammersType = GoodsTest.spec().getGoodsType("model.goods.hammers");
    private static final GoodsType horsesType = GoodsTest.spec().getGoodsType("model.goods.horses");
    private static final GoodsType lumberType = GoodsTest.spec().getGoodsType("model.goods.lumber");
    private static final GoodsType musketsType = GoodsTest.spec().getGoodsType("model.goods.muskets");
    private static final GoodsType oreType = GoodsTest.spec().getGoodsType("model.goods.ore");
    private static final GoodsType toolsType = GoodsTest.spec().getGoodsType("model.goods.tools");
    private static final GoodsType tradeGoodsType = GoodsTest.spec().getGoodsType("model.goods.tradeGoods");
    private static final TileType plainsType = GoodsTest.spec().getTileType("model.tile.plains");
    private static final UnitType privateerType = GoodsTest.spec().getUnitType("model.unit.privateer");
    private static final UnitType veteranSoldierType = GoodsTest.spec().getUnitType("model.unit.veteranSoldier");
    private static final UnitType wagonTrainType = GoodsTest.spec().getUnitType("model.unit.wagonTrain");

    public void testGoodsGameLocationIntInt() {
        Map map = GoodsTest.getTestMap(plainsType);
        ServerUnit wagon = new ServerUnit(GoodsTest.getGame(), map.getTile(9, 10), this.dutch(), wagonTrainType);
        Goods g = new Goods(GoodsTest.getGame(), wagon, cottonType, 75);
        GoodsTest.assertEquals((Object)wagon, (Object)g.getLocation());
        GoodsTest.assertEquals((Object)cottonType, (Object)g.getType());
        GoodsTest.assertEquals((int)75, (int)g.getAmount());
    }

    public void testSetOwner() {
        try {
            Map map = GoodsTest.getTestMap(plainsType);
            ServerUnit wagon = new ServerUnit(GoodsTest.getGame(), map.getTile(9, 10), this.dutch(), wagonTrainType);
            Goods g = new Goods(GoodsTest.getGame(), wagon, cottonType, 75);
            g.setOwner(GoodsTest.getGame().getCurrentPlayer());
            GoodsTest.fail((String)"Should not allow setOwner");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public void testToString() {
        Messages.loadMessageBundle(Locale.ENGLISH);
        Map map = GoodsTest.getTestMap(plainsType);
        ServerUnit wagon = new ServerUnit(GoodsTest.getGame(), map.getTile(9, 10), this.dutch(), wagonTrainType);
        Goods g = new Goods(GoodsTest.getGame(), wagon, cottonType, 75);
        GoodsTest.assertEquals((String)"75 cotton", (String)g.toString());
    }

    public void testGetName() {
        Locale.setDefault(Locale.ENGLISH);
        Goods g = new Goods(GoodsTest.getGame(), null, cottonType, 75);
        GoodsTest.assertEquals((String)"75 Cotton", (String)Messages.message(g.getLabel(true)));
        GoodsTest.assertEquals((String)"75 Cotton (boycotted)", (String)Messages.message(g.getLabel(false)));
    }

    public void testGetInputType() {
        GoodsTest.assertEquals(null, (Object)cottonType.getInputType());
        GoodsTest.assertEquals((Object)cottonType, (Object)clothType.getInputType());
    }

    public void testGetOutputType() {
        GoodsTest.assertEquals(null, (Object)clothType.getOutputType());
        GoodsTest.assertEquals((Object)clothType, (Object)cottonType.getOutputType());
    }

    public void testIsFarmedGoods() {
        GoodsTest.assertFalse((boolean)bellsType.isFarmed());
        GoodsTest.assertTrue((boolean)cottonType.isFarmed());
        GoodsTest.assertFalse((boolean)clothType.isFarmed());
    }

    public void testMilitaryGoods() {
        GoodsTest.assertFalse((boolean)bellsType.getMilitary());
        GoodsTest.assertFalse((boolean)crossesType.getMilitary());
        GoodsTest.assertFalse((boolean)clothType.getMilitary());
        GoodsTest.assertFalse((boolean)cottonType.getMilitary());
        GoodsTest.assertTrue((boolean)horsesType.getMilitary());
        GoodsTest.assertTrue((boolean)musketsType.getMilitary());
    }

    public void testBuildingMaterials() {
        GoodsTest.assertTrue((boolean)horsesType.isBuildingMaterial());
        GoodsTest.assertTrue((boolean)musketsType.isBuildingMaterial());
        GoodsTest.assertTrue((boolean)hammersType.isBuildingMaterial());
        GoodsTest.assertTrue((boolean)toolsType.isBuildingMaterial());
        GoodsTest.assertFalse((boolean)bellsType.isBuildingMaterial());
        GoodsTest.assertFalse((boolean)crossesType.isBuildingMaterial());
        GoodsTest.assertFalse((boolean)clothType.isBuildingMaterial());
        GoodsTest.assertFalse((boolean)cottonType.isBuildingMaterial());
        GoodsTest.assertFalse((boolean)fishType.isBuildingMaterial());
        GoodsTest.assertFalse((boolean)oreType.isBuildingMaterial());
        GoodsTest.assertFalse((boolean)lumberType.isBuildingMaterial());
        GoodsTest.assertTrue((boolean)oreType.isRawBuildingMaterial());
        GoodsTest.assertTrue((boolean)lumberType.isRawBuildingMaterial());
        GoodsTest.assertFalse((boolean)toolsType.isRawBuildingMaterial());
        GoodsTest.assertFalse((boolean)foodType.isRawBuildingMaterial());
        GoodsTest.assertTrue((boolean)grainType.isRawBuildingMaterial());
        GoodsTest.assertFalse((boolean)fishType.isRawBuildingMaterial());
        GoodsTest.assertFalse((boolean)horsesType.isRawBuildingMaterial());
        GoodsTest.assertFalse((boolean)musketsType.isRawBuildingMaterial());
        GoodsTest.assertFalse((boolean)hammersType.isRawBuildingMaterial());
        GoodsTest.assertFalse((boolean)bellsType.isRawBuildingMaterial());
        GoodsTest.assertFalse((boolean)crossesType.isRawBuildingMaterial());
        GoodsTest.assertFalse((boolean)clothType.isRawBuildingMaterial());
        GoodsTest.assertFalse((boolean)cottonType.isRawBuildingMaterial());
    }

    public void testTradeGoods() {
        GoodsTest.assertTrue((boolean)tradeGoodsType.isTradeGoods());
    }

    public void testGetTakeSpace() {
        Map map = GoodsTest.getTestMap(plainsType, true);
        ServerUnit wagon = new ServerUnit(GoodsTest.getGame(), map.getTile(9, 10), this.dutch(), wagonTrainType);
        Goods cotton = new Goods(GoodsTest.getGame(), wagon, cottonType, 75);
        GoodsTest.assertEquals((int)1, (int)cotton.getSpaceTaken());
    }

    public void testSetGetAmount() {
        Map map = GoodsTest.getTestMap(plainsType, true);
        ServerUnit wagon = new ServerUnit(GoodsTest.getGame(), map.getTile(9, 10), this.dutch(), wagonTrainType);
        Goods cotton = new Goods(GoodsTest.getGame(), wagon, cottonType, 75);
        GoodsTest.assertEquals((int)75, (int)cotton.getAmount());
        cotton.setAmount(-10);
        GoodsTest.assertEquals((int)-10, (int)cotton.getAmount());
        cotton.setAmount(100000);
        GoodsTest.assertEquals((int)100000, (int)cotton.getAmount());
    }

    public Player dutch() {
        return GoodsTest.getGame().getPlayerByNationId("model.nation.dutch");
    }

    public void testAdjustAmount() {
        Map map = GoodsTest.getTestMap(plainsType, true);
        ServerUnit wagon = new ServerUnit(GoodsTest.getGame(), map.getTile(9, 10), this.dutch(), wagonTrainType);
        Goods cotton = new Goods(GoodsTest.getGame(), wagon, cottonType, 75);
        GoodsTest.assertEquals((int)75, (int)cotton.getAmount());
        cotton.adjustAmount();
        cotton.setAmount(-10);
        GoodsTest.assertEquals((int)-10, (int)cotton.getAmount());
        cotton.setAmount(100000);
        GoodsTest.assertEquals((int)100000, (int)cotton.getAmount());
    }

    public void testProductionChain() {
        List<GoodsType> chain = hammersType.getProductionChain();
        GoodsTest.assertEquals((Object)lumberType, (Object)chain.get(0));
        GoodsTest.assertEquals((Object)hammersType, (Object)chain.get(1));
        chain = musketsType.getProductionChain();
        GoodsTest.assertEquals((Object)oreType, (Object)chain.get(0));
        GoodsTest.assertEquals((Object)toolsType, (Object)chain.get(1));
        GoodsTest.assertEquals((Object)musketsType, (Object)chain.get(2));
    }
}

