/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.sqlserver.jdbc;

import com.microsoft.sqlserver.jdbc.FetchBuffer;
import com.microsoft.sqlserver.jdbc.ResultSetCursor;
import com.microsoft.sqlserver.jdbc.SQLServerException;

abstract class PositionedCursor
extends ResultSetCursor {
    FetchBuffer fetchBuffer;
    static final int BEFORE_FIRST_ROW = -1;
    static final int AFTER_LAST_ROW = -2;
    int currentRow = -1;

    abstract int getRowCount() throws SQLServerException;

    abstract boolean isResultSetEmpty() throws SQLServerException;

    PositionedCursor(FetchBuffer fetchBuffer) {
        this.fetchBuffer = fetchBuffer;
    }

    void close() throws SQLServerException {
        this.fetchBuffer.close();
    }

    boolean isOnValidRow() {
        return -1 != this.currentRow && -2 != this.currentRow;
    }

    void getterRefreshCurrentRow() throws SQLServerException {
        this.fetchBuffer.getterRefreshCurrentRow();
    }

    void beforeFirst() throws SQLServerException {
        this.fetchBuffer.beforeFirst();
        this.currentRow = -1;
    }

    boolean isBeforeFirst() throws SQLServerException {
        return !this.isResultSetEmpty() && -1 == this.currentRow;
    }

    boolean first() throws SQLServerException {
        return this.positionedAbsolute(1);
    }

    boolean isFirst() throws SQLServerException {
        return 1 == this.currentRow;
    }

    void afterLast() throws SQLServerException {
        this.fetchBuffer.afterLast();
        this.currentRow = -2;
    }

    boolean isAfterLast() throws SQLServerException {
        return !this.isResultSetEmpty() && -2 == this.currentRow;
    }

    boolean last() throws SQLServerException {
        return this.positionedAbsolute(-1);
    }

    boolean isLast() throws SQLServerException {
        return this.getRowCount() == this.currentRow;
    }

    int getRow() throws SQLServerException {
        return this.isOnValidRow() ? this.currentRow : 0;
    }

    boolean next() throws SQLServerException {
        return this.positionedRelative(1);
    }

    boolean previous() throws SQLServerException {
        return this.positionedRelative(-1);
    }

    boolean relative(int n) throws SQLServerException {
        return this.positionedRelative(n);
    }

    private final boolean positionedRelative(int n) throws SQLServerException {
        if (this.fetchBuffer.relative(n)) {
            this.currentRow = -1 == this.currentRow ? n : (-2 == this.currentRow ? this.getRowCount() + 1 + n : (this.currentRow += n));
        } else if (n > 0) {
            this.currentRow = -2;
        } else if (n < 0) {
            this.currentRow = -1;
        }
        return this.isOnValidRow();
    }

    boolean absolute(int n) throws SQLServerException {
        return this.positionedAbsolute(n);
    }

    private final boolean positionedAbsolute(int n) throws SQLServerException {
        if (0 == n) {
            this.beforeFirst();
            return false;
        }
        this.currentRow = this.fetchBuffer.absolute(n) ? (n < 0 ? n + this.getRowCount() + 1 : n) : (n < 0 ? -1 : -2);
        return this.isOnValidRow();
    }
}

