/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import java.util.TimeZone;
import org.traccar.Protocol;
import org.traccar.StringProtocolEncoder;
import org.traccar.model.Command;

public class MiniFinderProtocolEncoder
extends StringProtocolEncoder
implements StringProtocolEncoder.ValueFormatter {
    public MiniFinderProtocolEncoder(Protocol protocol) {
        super(protocol);
    }

    @Override
    public String formatValue(String key, Object value) {
        return switch (key) {
            case "enable" -> {
                if (((Boolean)value).booleanValue()) {
                    yield "1";
                }
                yield "0";
            }
            case "timezone" -> String.format("%+03d", TimeZone.getTimeZone((String)value).getRawOffset() / 3600000);
            case "index" -> {
                switch (((Number)value).intValue()) {
                    case 0: {
                        yield "A";
                    }
                    case 1: {
                        yield "B";
                    }
                    case 2: {
                        yield "C";
                    }
                }
                yield null;
            }
            default -> null;
        };
    }

    @Override
    protected Object encodeCommand(Command command) {
        this.initDevicePassword(command, "123456");
        return switch (command.getType()) {
            case "setTimezone" -> this.formatCommand(command, "%sL%s", this, "devicePassword", "timezone");
            case "voiceMonitoring" -> this.formatCommand(command, "%sP%s", this, "devicePassword", "enable");
            case "alarmSpeed" -> this.formatCommand(command, "%sJ1%s", "devicePassword", "data");
            case "alarmGeofence" -> this.formatCommand(command, "%sR1%s", "devicePassword", "radius");
            case "alarmVibration" -> this.formatCommand(command, "%sW1,%s", "devicePassword", "data");
            case "setAgps" -> this.formatCommand(command, "%sAGPS%s", this, "devicePassword", "enable");
            case "alarmFall" -> this.formatCommand(command, "%sF%s", this, "devicePassword", "enable");
            case "modePowerSaving" -> this.formatCommand(command, "%sSP%s", this, "devicePassword", "enable");
            case "modeDeepSleep" -> this.formatCommand(command, "%sDS%s", this, "devicePassword", "enable");
            case "sosNumber" -> this.formatCommand(command, "%s%s1,%s", this, "devicePassword", "index", "phone");
            case "setIndicator" -> this.formatCommand(command, "%sLED%s", "devicePassword", "data");
            default -> null;
        };
    }
}

