/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.kafka.common.GroupType;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.ListGroupsRequestData;
import org.apache.kafka.common.message.ListGroupsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.ListGroupsResponse;

public class ListGroupsRequest
extends AbstractRequest {
    private final ListGroupsRequestData data;

    public ListGroupsRequest(ListGroupsRequestData data, short version) {
        super(ApiKeys.LIST_GROUPS, version);
        this.data = data;
    }

    @Override
    public ListGroupsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        ListGroupsResponseData listGroupsResponseData = new ListGroupsResponseData().setGroups(Collections.emptyList()).setErrorCode(Errors.forException(e).code());
        if (this.version() >= 1) {
            listGroupsResponseData.setThrottleTimeMs(throttleTimeMs);
        }
        return new ListGroupsResponse(listGroupsResponseData);
    }

    public static ListGroupsRequest parse(Readable readable, short version) {
        return new ListGroupsRequest(new ListGroupsRequestData(readable, version), version);
    }

    @Override
    public ListGroupsRequestData data() {
        return this.data;
    }

    public static class Builder
    extends AbstractRequest.Builder<ListGroupsRequest> {
        private final ListGroupsRequestData data;

        public Builder(ListGroupsRequestData data) {
            super(ApiKeys.LIST_GROUPS);
            this.data = data;
        }

        @Override
        public ListGroupsRequest build(short version) {
            if (!this.data.statesFilter().isEmpty() && version < 4) {
                throw new UnsupportedVersionException("The broker only supports ListGroups v" + version + ", but we need v4 or newer to request groups by states.");
            }
            if (!this.data.typesFilter().isEmpty() && version < 5) {
                HashSet<String> typesCopy = new HashSet<String>(this.data.typesFilter());
                boolean containedClassic = typesCopy.remove(GroupType.CLASSIC.toString());
                boolean containedConsumer = typesCopy.remove(GroupType.CONSUMER.toString());
                if (!typesCopy.isEmpty() || !containedClassic && containedConsumer) {
                    throw new UnsupportedVersionException("The broker only supports ListGroups v" + version + ", but we need v5 or newer to request groups by type. Requested group types: [" + String.join((CharSequence)", ", this.data.typesFilter()) + "].");
                }
                return new ListGroupsRequest(this.data.duplicate().setTypesFilter(List.of()), version);
            }
            return new ListGroupsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

