/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.common.message.DescribeShareGroupOffsetsRequestData;
import org.apache.kafka.common.message.DescribeShareGroupOffsetsResponseData;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.Readable;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.DescribeShareGroupOffsetsResponse;

public class DescribeShareGroupOffsetsRequest
extends AbstractRequest {
    private final DescribeShareGroupOffsetsRequestData data;

    public DescribeShareGroupOffsetsRequest(DescribeShareGroupOffsetsRequestData data, short version) {
        super(ApiKeys.DESCRIBE_SHARE_GROUP_OFFSETS, version);
        this.data = data;
    }

    public List<String> groupIds() {
        return this.data.groups().stream().map(DescribeShareGroupOffsetsRequestData.DescribeShareGroupOffsetsRequestGroup::groupId).collect(Collectors.toList());
    }

    public List<DescribeShareGroupOffsetsRequestData.DescribeShareGroupOffsetsRequestGroup> groups() {
        return this.data.groups();
    }

    @Override
    public DescribeShareGroupOffsetsResponse getErrorResponse(int throttleTimeMs, Throwable e) {
        return new DescribeShareGroupOffsetsResponse(throttleTimeMs, this.groupIds(), e);
    }

    @Override
    public DescribeShareGroupOffsetsRequestData data() {
        return this.data;
    }

    public static DescribeShareGroupOffsetsRequest parse(Readable readable, short version) {
        return new DescribeShareGroupOffsetsRequest(new DescribeShareGroupOffsetsRequestData(readable, version), version);
    }

    public static DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseGroup getErrorDescribedGroup(String groupId, Errors error) {
        return new DescribeShareGroupOffsetsResponseData.DescribeShareGroupOffsetsResponseGroup().setGroupId(groupId).setErrorCode(error.code()).setErrorMessage(error.message());
    }

    public static class Builder
    extends AbstractRequest.Builder<DescribeShareGroupOffsetsRequest> {
        private final DescribeShareGroupOffsetsRequestData data;

        public Builder(DescribeShareGroupOffsetsRequestData data) {
            super(ApiKeys.DESCRIBE_SHARE_GROUP_OFFSETS);
            this.data = data;
        }

        @Override
        public DescribeShareGroupOffsetsRequest build(short version) {
            return new DescribeShareGroupOffsetsRequest(this.data, version);
        }

        public String toString() {
            return this.data.toString();
        }
    }
}

