/*
 * Decompiled with CFR 0.152.
 */
package scala.concurrent;

import java.util.concurrent.TimeUnit;
import scala.None$;
import scala.Option;
import scala.Some$;

public class SyncVar<A> {
    private boolean isDefined = false;
    private A value;

    public A get() {
        A a;
        SyncVar syncVar = this;
        synchronized (syncVar) {
            while (!this.isDefined) {
                this.wait();
            }
            a = this.value;
        }
        return a;
    }

    private long waitMeasuringElapsed(long timeout) {
        if (timeout <= 0L) {
            return 0L;
        }
        long start = System.nanoTime();
        this.wait(timeout);
        long elapsed = System.nanoTime() - start;
        if (elapsed < 0L) {
            return 0L;
        }
        return TimeUnit.NANOSECONDS.toMillis(elapsed);
    }

    public Option<A> get(long timeout) {
        None$ none$;
        SyncVar syncVar = this;
        synchronized (syncVar) {
            long elapsed;
            for (long rest = timeout; !this.isDefined && rest > 0L; rest -= elapsed) {
                elapsed = this.waitMeasuringElapsed(rest);
            }
            none$ = this.isDefined ? Some$.MODULE$.apply(this.value) : None$.MODULE$;
        }
        return none$;
    }

    public A take() {
        A a;
        SyncVar syncVar = this;
        synchronized (syncVar) {
            A a2;
            try {
                a2 = this.get();
            }
            finally {
                this.unsetVal();
            }
            a = a2;
        }
        return a;
    }

    public A take(long timeout) {
        A a;
        SyncVar syncVar = this;
        synchronized (syncVar) {
            A a2;
            try {
                a2 = this.get(timeout).get();
            }
            finally {
                this.unsetVal();
            }
            a = a2;
        }
        return a;
    }

    public void put(A x) {
        SyncVar syncVar = this;
        synchronized (syncVar) {
            while (this.isDefined) {
                this.wait();
            }
            this.setVal(x);
        }
    }

    public boolean isSet() {
        boolean bl;
        SyncVar syncVar = this;
        synchronized (syncVar) {
            bl = this.isDefined;
        }
        return bl;
    }

    private void setVal(A x) {
        SyncVar syncVar = this;
        synchronized (syncVar) {
            this.isDefined = true;
            this.value = x;
            this.notifyAll();
        }
    }

    private void unsetVal() {
        SyncVar syncVar = this;
        synchronized (syncVar) {
            this.isDefined = false;
            this.value = null;
            this.notifyAll();
        }
    }
}

