/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.AbstractIterator;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.Iterator;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.generic.DefaultSerializationProxy;
import scala.collection.immutable.ArraySeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.AbstractIterable;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Cloneable;
import scala.collection.mutable.Growable;
import scala.collection.mutable.PriorityQueue$;
import scala.collection.mutable.Queue;
import scala.collection.mutable.Queue$;
import scala.math.Ordering;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public class PriorityQueue<A>
extends AbstractIterable<A>
implements StrictOptimizedIterableOps<A, scala.collection.mutable.Iterable, PriorityQueue<A>>,
Builder<A, PriorityQueue<A>>,
Cloneable<PriorityQueue<A>>,
Serializable {
    private final Ordering<A> ord;
    private final ResizableArrayAccess<A> resarr;

    public static Object apply(Seq seq, Object object) {
        return PriorityQueue$.MODULE$.apply(seq, object);
    }

    public static Factory evidenceIterableFactory(Object object) {
        return PriorityQueue$.MODULE$.evidenceIterableFactory(object);
    }

    public static Object fill(int n, Function0 function0, Object object) {
        return PriorityQueue$.MODULE$.fill(n, function0, object);
    }

    public static <E> PriorityQueue<E> from(IterableOnce<E> iterableOnce, Ordering<E> ordering) {
        return PriorityQueue$.MODULE$.from(iterableOnce, ordering);
    }

    public static Object iterate(Object object, int n, Function1 function1, Object object2) {
        return PriorityQueue$.MODULE$.iterate(object, n, function1, object2);
    }

    public static <A> Builder<A, PriorityQueue<A>> newBuilder(Ordering<A> ordering) {
        return PriorityQueue$.MODULE$.newBuilder(ordering);
    }

    public static Object tabulate(int n, Function1 function1, Object object) {
        return PriorityQueue$.MODULE$.tabulate(n, function1, object);
    }

    public static Object unfold(Object object, Function1 function1, Object object2) {
        return PriorityQueue$.MODULE$.unfold(object, function1, object2);
    }

    public PriorityQueue(Ordering<A> ord) {
        this.ord = ord;
        StrictOptimizedIterableOps.$init$(this);
        Growable.$init$(this);
        Builder.$init$(this);
        Cloneable.$init$(this);
        this.resarr = new ResizableArrayAccess();
        this.scala$collection$mutable$PriorityQueue$$resarr().p_size0_$eq(this.scala$collection$mutable$PriorityQueue$$resarr().p_size0() + 1);
    }

    @Override
    public Tuple2<PriorityQueue<A>, PriorityQueue<A>> partition(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public Tuple2<PriorityQueue<A>, PriorityQueue<A>> span(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.span$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.mutable.Iterable<A1>, scala.collection.mutable.Iterable<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<scala.collection.mutable.Iterable<A1>, scala.collection.mutable.Iterable<A2>, scala.collection.mutable.Iterable<A3>> unzip3(Function1<A, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<A, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<A, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<A, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<A, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<A, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.mutable.Iterable<A1>, scala.collection.mutable.Iterable<A2>> partitionMap(Function1<A, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public Object takeRight(int n) {
        return StrictOptimizedIterableOps.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public final Growable $plus$eq(Object elem) {
        return Growable.$plus$eq$(this, elem);
    }

    @Override
    public final Growable $plus$eq(Object elem1, Object elem2, Seq elems) {
        return Growable.$plus$eq$(this, elem1, elem2, elems);
    }

    @Override
    public final Growable $plus$plus$eq(IterableOnce elems) {
        return Growable.$plus$plus$eq$(this, elems);
    }

    @Override
    public void sizeHint(int size) {
        Builder.sizeHint$(this, size);
    }

    @Override
    public final void sizeHint(IterableOnce<?> coll, int delta) {
        Builder.sizeHint$(this, coll, delta);
    }

    @Override
    public int sizeHint$default$2() {
        return Builder.sizeHint$default$2$(this);
    }

    @Override
    public final void sizeHintBounded(int size, Iterable<?> boundingColl) {
        Builder.sizeHintBounded$(this, size, boundingColl);
    }

    @Override
    public <NewTo> Builder<A, NewTo> mapResult(Function1<PriorityQueue<A>, NewTo> f) {
        return Builder.mapResult$(this, f);
    }

    @Override
    public /* synthetic */ Object scala$collection$mutable$Cloneable$$super$clone() {
        return super.clone();
    }

    public Ordering<A> ord() {
        return this.ord;
    }

    public ResizableArrayAccess<A> scala$collection$mutable$PriorityQueue$$resarr() {
        return this.resarr;
    }

    public int length() {
        return this.scala$collection$mutable$PriorityQueue$$resarr().length() - 1;
    }

    @Override
    public int size() {
        return this.length();
    }

    @Override
    public int knownSize() {
        return this.length();
    }

    @Override
    public boolean isEmpty() {
        return this.scala$collection$mutable$PriorityQueue$$resarr().p_size0() < 2;
    }

    @Override
    public PriorityQueue<A> fromSpecific(IterableOnce<A> coll) {
        return PriorityQueue$.MODULE$.from(coll, this.ord());
    }

    @Override
    public Builder<A, PriorityQueue<A>> newSpecificBuilder() {
        return PriorityQueue$.MODULE$.newBuilder(this.ord());
    }

    @Override
    public PriorityQueue<A> empty() {
        return PriorityQueue$.MODULE$.empty(this.ord());
    }

    public PriorityQueue<A> mapInPlace(Function1<A, A> f) {
        this.scala$collection$mutable$PriorityQueue$$resarr().mapInPlace((Function1)f);
        this.scala$collection$mutable$PriorityQueue$$heapify(1);
        return this;
    }

    @Override
    public PriorityQueue<A> result() {
        return this;
    }

    public A scala$collection$mutable$PriorityQueue$$toA(Object x) {
        return (A)x;
    }

    public void fixUp(Object[] as, int m) {
        for (int k = m; k > 1 && this.ord().lt(this.scala$collection$mutable$PriorityQueue$$toA(as[k / 2]), this.scala$collection$mutable$PriorityQueue$$toA(as[k])); k /= 2) {
            this.scala$collection$mutable$PriorityQueue$$resarr().p_swap(k, k / 2);
        }
    }

    public boolean fixDown(Object[] as, int m, int n) {
        int k = m;
        while (n >= 2 * k) {
            int j = 2 * k;
            if (j < n && this.ord().lt(this.scala$collection$mutable$PriorityQueue$$toA(as[j]), this.scala$collection$mutable$PriorityQueue$$toA(as[j + 1]))) {
                ++j;
            }
            if (this.ord().gteq(this.scala$collection$mutable$PriorityQueue$$toA(as[k]), this.scala$collection$mutable$PriorityQueue$$toA(as[j]))) {
                return k != m;
            }
            Object h = as[k];
            as[k] = as[j];
            as[j] = h;
            k = j;
        }
        return k != m;
    }

    @Override
    public PriorityQueue<A> addOne(A elem) {
        this.scala$collection$mutable$PriorityQueue$$resarr().p_ensureAdditionalSize(1);
        this.scala$collection$mutable$PriorityQueue$$resarr().p_array()[this.scala$collection$mutable$PriorityQueue$$resarr().p_size0()] = elem;
        this.fixUp(this.scala$collection$mutable$PriorityQueue$$resarr().p_array(), this.scala$collection$mutable$PriorityQueue$$resarr().p_size0());
        this.scala$collection$mutable$PriorityQueue$$resarr().p_size0_$eq(this.scala$collection$mutable$PriorityQueue$$resarr().p_size0() + 1);
        return this;
    }

    @Override
    public PriorityQueue<A> addAll(IterableOnce<A> xs) {
        int from = this.scala$collection$mutable$PriorityQueue$$resarr().p_size0();
        xs.iterator().foreach(x -> this.scala$collection$mutable$PriorityQueue$$unsafeAdd(x));
        this.scala$collection$mutable$PriorityQueue$$heapify(from);
        return this;
    }

    public void scala$collection$mutable$PriorityQueue$$unsafeAdd(A elem) {
        this.scala$collection$mutable$PriorityQueue$$resarr().p_ensureAdditionalSize(1);
        this.scala$collection$mutable$PriorityQueue$$resarr().p_array()[this.scala$collection$mutable$PriorityQueue$$resarr().p_size0()] = elem;
        this.scala$collection$mutable$PriorityQueue$$resarr().p_size0_$eq(this.scala$collection$mutable$PriorityQueue$$resarr().p_size0() + 1);
    }

    public void scala$collection$mutable$PriorityQueue$$heapify(int from) {
        int n = this.length();
        if (from <= 2) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(n / 2), 1).by(-1).foreach((Function1<Object, Boolean> & Serializable)(Object i) -> this.heapify$$anonfun$1(n, BoxesRunTime.unboxToInt(i)));
            return;
        }
        if (n - from < 4) {
            RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(from), n).foreach((Function1<Object, Object> & Serializable)(Object v1) -> {
                this.heapify$$anonfun$2(BoxesRunTime.unboxToInt(v1));
                return BoxedUnit.UNIT;
            });
            return;
        }
        IntRef min = IntRef.create(from / 2);
        Queue queue = (Queue)Queue$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{min.elem}));
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(n / 2), min.elem).by(-1).foreach((Function1<Object, Object> & Serializable)(Object v1) -> {
            this.heapify$$anonfun$3(n, min, queue, BoxesRunTime.unboxToInt(v1));
            return BoxedUnit.UNIT;
        });
        while (queue.nonEmpty()) {
            int parent;
            int i2 = BoxesRunTime.unboxToInt(queue.dequeue());
            if (!this.fixDown(this.scala$collection$mutable$PriorityQueue$$resarr().p_array(), i2, n) || (parent = i2 / 2) >= min.elem || parent <= 0) continue;
            min.elem = parent;
            queue.$plus$eq(BoxesRunTime.boxToInteger(parent));
        }
    }

    @Override
    public PriorityQueue<A> $plus$plus(IterableOnce<A> xs) {
        return (PriorityQueue)((PriorityQueue)this.clone()).$plus$plus$eq((IterableOnce)xs);
    }

    public void enqueue(Seq<A> elems) {
        this.$plus$plus$eq((IterableOnce)elems);
    }

    public A dequeue() {
        if (this.scala$collection$mutable$PriorityQueue$$resarr().p_size0() > 1) {
            this.scala$collection$mutable$PriorityQueue$$resarr().p_size0_$eq(this.scala$collection$mutable$PriorityQueue$$resarr().p_size0() - 1);
            Object result = this.scala$collection$mutable$PriorityQueue$$resarr().p_array()[1];
            this.scala$collection$mutable$PriorityQueue$$resarr().p_array()[1] = this.scala$collection$mutable$PriorityQueue$$resarr().p_array()[this.scala$collection$mutable$PriorityQueue$$resarr().p_size0()];
            this.scala$collection$mutable$PriorityQueue$$resarr().p_array()[this.scala$collection$mutable$PriorityQueue$$resarr().p_size0()] = null;
            this.fixDown(this.scala$collection$mutable$PriorityQueue$$resarr().p_array(), 1, this.scala$collection$mutable$PriorityQueue$$resarr().p_size0() - 1);
            return this.scala$collection$mutable$PriorityQueue$$toA(result);
        }
        throw new NoSuchElementException("no element to remove from heap");
    }

    public <A1> Seq<A1> dequeueAll() {
        ArrayBuilder<Object> b = ArrayBuilder$.MODULE$.make(ClassTag$.MODULE$.Any());
        b.sizeHint(this.size());
        while (this.nonEmpty()) {
            b.$plus$eq((Object)this.dequeue());
        }
        return ArraySeq$.MODULE$.unsafeWrapArray(b.result());
    }

    @Override
    public A head() {
        if (this.scala$collection$mutable$PriorityQueue$$resarr().p_size0() > 1) {
            return this.scala$collection$mutable$PriorityQueue$$toA(this.scala$collection$mutable$PriorityQueue$$resarr().p_array()[1]);
        }
        throw new NoSuchElementException("queue is empty");
    }

    @Override
    public void clear() {
        this.scala$collection$mutable$PriorityQueue$$resarr().clear();
        this.scala$collection$mutable$PriorityQueue$$resarr().p_size0_$eq(1);
    }

    @Override
    public Iterator<A> iterator() {
        return this.scala$collection$mutable$PriorityQueue$$resarr().iterator().drop(1);
    }

    public PriorityQueue<A> reverse() {
        PriorityQueue<A> revq = new PriorityQueue<A>(this.ord().reverse());
        int n = this.scala$collection$mutable$PriorityQueue$$resarr().p_size0();
        revq.scala$collection$mutable$PriorityQueue$$resarr().p_ensureSize(n);
        revq.scala$collection$mutable$PriorityQueue$$resarr().p_size0_$eq(n);
        Object[] from = this.scala$collection$mutable$PriorityQueue$$resarr().p_array();
        Object[] to = revq.scala$collection$mutable$PriorityQueue$$resarr().p_array();
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), n).foreach((Function1<Object, Object> & Serializable)(Object v1) -> {
            to[BoxesRunTime.unboxToInt(v1)] = from[n - BoxesRunTime.unboxToInt(v1)];
            return BoxedUnit.UNIT;
        });
        revq.scala$collection$mutable$PriorityQueue$$heapify(1);
        return revq;
    }

    public Iterator<A> reverseIterator() {
        return new AbstractIterator<A>(this){
            private int i;
            private final /* synthetic */ PriorityQueue $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.i = $outer.scala$collection$mutable$PriorityQueue$$resarr().p_size0() - 1;
            }

            public boolean hasNext() {
                return this.i >= 1;
            }

            public Object next() {
                Object n = this.$outer.scala$collection$mutable$PriorityQueue$$resarr().p_array()[this.i];
                --this.i;
                return this.$outer.scala$collection$mutable$PriorityQueue$$toA(n);
            }
        };
    }

    public Queue<A> toQueue() {
        return (Queue)new Queue(Queue$.MODULE$.$lessinit$greater$default$1()).$plus$plus$eq((IterableOnce)this.iterator());
    }

    @Override
    public String toString() {
        return this.toList().mkString("PriorityQueue(", ", ", ")");
    }

    @Override
    public List<A> toList() {
        return List$.MODULE$.from((IterableOnce)this.iterator());
    }

    @Override
    public PriorityQueue<A> clone() {
        PriorityQueue<A> pq = new PriorityQueue<A>(this.ord());
        int n = this.scala$collection$mutable$PriorityQueue$$resarr().p_size0();
        pq.scala$collection$mutable$PriorityQueue$$resarr().p_ensureSize(n);
        System.arraycopy(this.scala$collection$mutable$PriorityQueue$$resarr().p_array(), 1, pq.scala$collection$mutable$PriorityQueue$$resarr().p_array(), 1, n - 1);
        pq.scala$collection$mutable$PriorityQueue$$resarr().p_size0_$eq(n);
        return pq;
    }

    @Override
    public <B> int copyToArray(Object xs, int start, int len) {
        int copied = IterableOnce$.MODULE$.elemsToCopyToArray(this.length(), ScalaRunTime$.MODULE$.array_length(xs), start, len);
        if (copied > 0) {
            Array$.MODULE$.copy(this.scala$collection$mutable$PriorityQueue$$resarr().p_array(), 1, xs, start, copied);
        }
        return copied;
    }

    public PriorityQueue$ orderedCompanion() {
        return PriorityQueue$.MODULE$;
    }

    public Object writeReplace() {
        return new DefaultSerializationProxy(PriorityQueue$.MODULE$.evidenceIterableFactory(this.ord()), this);
    }

    @Override
    public String className() {
        return "PriorityQueue";
    }

    private final /* synthetic */ boolean heapify$$anonfun$1(int n$1, int i) {
        return this.fixDown(this.scala$collection$mutable$PriorityQueue$$resarr().p_array(), i, n$1);
    }

    private final /* synthetic */ void heapify$$anonfun$2(int i) {
        this.fixUp(this.scala$collection$mutable$PriorityQueue$$resarr().p_array(), i);
    }

    private final /* synthetic */ void heapify$$anonfun$3(int n$2, IntRef min$1, Queue queue$1, int i) {
        if (this.fixDown(this.scala$collection$mutable$PriorityQueue$$resarr().p_array(), i, n$2)) {
            int parent = i / 2;
            if (parent < min$1.elem) {
                min$1.elem = parent;
                queue$1.$plus$eq(BoxesRunTime.boxToInteger(parent));
                return;
            }
            return;
        }
    }

    public class ResizableArrayAccess<A0>
    extends ArrayBuffer<A0> {
        public ResizableArrayAccess<A0> mapInPlace(Function1<A0, A0> f) {
            int siz = this.size();
            for (int i = 1; i < siz; ++i) {
                this.update(i, f.apply(this.apply(i)));
            }
            return this;
        }

        public int p_size0() {
            return this.size0();
        }

        public void p_size0_$eq(int s) {
            this.size0_$eq(s);
        }

        public Object[] p_array() {
            return this.array();
        }

        public void p_ensureSize(int n) {
            super.ensureSize(n);
        }

        public void p_ensureAdditionalSize(int n) {
            super.ensureSize(this.size0() + n);
        }

        public void p_swap(int a, int b) {
            Object h = this.array()[a];
            this.array()[a] = this.array()[b];
            this.array()[b] = h;
        }
    }
}

