/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import java.util.NoSuchElementException;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.IndexedSeqOps;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.Iterator;
import scala.collection.Searching;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.generic.DefaultSerializable;
import scala.collection.immutable.Seq$;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.ArrayDeque$;
import scala.collection.mutable.ArrayDequeOps;
import scala.collection.mutable.Builder;
import scala.collection.mutable.IndexedBuffer;
import scala.collection.mutable.IndexedSeq;
import scala.collection.mutable.IndexedSeq$;
import scala.math.Integral;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.runtime.Arrays$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Scala3RunTime$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;

public class ArrayDeque<A>
extends AbstractBuffer<A>
implements IndexedBuffer<A>,
ArrayDequeOps<A, ArrayDeque, ArrayDeque<A>>,
DefaultSerializable {
    private Object[] array;
    private int start;
    private int end;

    public static int DefaultInitialSize() {
        return ArrayDeque$.MODULE$.DefaultInitialSize();
    }

    public static int StableSize() {
        return ArrayDeque$.MODULE$.StableSize();
    }

    public static Object[] alloc(int n) {
        return ArrayDeque$.MODULE$.alloc(n);
    }

    public static /* synthetic */ Object fill(int n, Function0 function0) {
        return ArrayDeque$.MODULE$.fill(n, function0);
    }

    public static SeqOps fill(int n, Function0 function0) {
        return ArrayDeque$.MODULE$.fill(n, function0);
    }

    public static Object fill(int n, int n2, Function0 function0) {
        return ArrayDeque$.MODULE$.fill(n, n2, function0);
    }

    public static Object fill(int n, int n2, int n3, Function0 function0) {
        return ArrayDeque$.MODULE$.fill(n, n2, n3, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, Function0 function0) {
        return ArrayDeque$.MODULE$.fill(n, n2, n3, n4, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, int n5, Function0 function0) {
        return ArrayDeque$.MODULE$.fill(n, n2, n3, n4, n5, function0);
    }

    public static <B> ArrayDeque<B> from(IterableOnce<B> iterableOnce) {
        return ArrayDeque$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static Object iterate(Object object, int n, Function1 function1) {
        return ArrayDeque$.MODULE$.iterate(object, n, function1);
    }

    public static <A> Builder<A, ArrayDeque<A>> newBuilder() {
        return ArrayDeque$.MODULE$.newBuilder();
    }

    public static Object range(Object object, Object object2, Integral integral) {
        return ArrayDeque$.MODULE$.range(object, object2, integral);
    }

    public static Object range(Object object, Object object2, Object object3, Integral integral) {
        return ArrayDeque$.MODULE$.range(object, object2, object3, integral);
    }

    public static /* synthetic */ Object tabulate(int n, Function1 function1) {
        return ArrayDeque$.MODULE$.tabulate(n, function1);
    }

    public static SeqOps tabulate(int n, Function1 function1) {
        return ArrayDeque$.MODULE$.tabulate(n, function1);
    }

    public static Object tabulate(int n, int n2, Function2 function2) {
        return ArrayDeque$.MODULE$.tabulate(n, n2, function2);
    }

    public static Object tabulate(int n, int n2, int n3, Function3 function3) {
        return ArrayDeque$.MODULE$.tabulate(n, n2, n3, function3);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, Function4 function4) {
        return ArrayDeque$.MODULE$.tabulate(n, n2, n3, n4, function4);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, int n5, Function5 function5) {
        return ArrayDeque$.MODULE$.tabulate(n, n2, n3, n4, n5, function5);
    }

    public static SeqOps unapplySeq(SeqOps seqOps) {
        return ArrayDeque$.MODULE$.unapplySeq(seqOps);
    }

    public static Object unfold(Object object, Function1 function1) {
        return ArrayDeque$.MODULE$.unfold(object, function1);
    }

    public static <A> int $lessinit$greater$default$1() {
        return ArrayDeque$.MODULE$.$lessinit$greater$default$1();
    }

    public ArrayDeque(Object[] array, int start, int end) {
        this.array = array;
        this.start = start;
        this.end = end;
        IndexedSeqOps.$init$(this);
        scala.collection.IndexedSeq.$init$(this);
        scala.collection.mutable.IndexedSeqOps.$init$(this);
        IndexedSeq.$init$(this);
        IndexedBuffer.$init$(this);
        StrictOptimizedIterableOps.$init$(this);
        StrictOptimizedSeqOps.$init$(this);
        ArrayDequeOps.$init$(this);
        DefaultSerializable.$init$(this);
        this.reset(this.array(), this.start(), this.end());
    }

    @Override
    public Iterator<A> iterator() {
        return IndexedSeqOps.iterator$(this);
    }

    @Override
    public Iterator<A> reverseIterator() {
        return IndexedSeqOps.reverseIterator$(this);
    }

    @Override
    public <B> B foldRight(B z, Function2<A, B, B> op) {
        return (B)IndexedSeqOps.foldRight$(this, z, op);
    }

    @Override
    public IndexedSeqView<A> view() {
        return IndexedSeqOps.view$(this);
    }

    @Override
    public IndexedSeqView<A> view(int from, int until) {
        return IndexedSeqOps.view$(this, from, until);
    }

    @Override
    public Iterable<A> reversed() {
        return IndexedSeqOps.reversed$(this);
    }

    @Override
    public Object take(int n) {
        return IndexedSeqOps.take$(this, n);
    }

    @Override
    public Object drop(int n) {
        return IndexedSeqOps.drop$(this, n);
    }

    @Override
    public A head() {
        return (A)IndexedSeqOps.head$(this);
    }

    @Override
    public Option<A> headOption() {
        return IndexedSeqOps.headOption$(this);
    }

    @Override
    public A last() {
        return (A)IndexedSeqOps.last$(this);
    }

    @Override
    public final int lengthCompare(int len) {
        return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, len);
    }

    @Override
    public final int lengthCompare(Iterable<?> that) {
        return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, that);
    }

    @Override
    public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
        return IndexedSeqOps.search$(this, elem, ord);
    }

    @Override
    public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
        return IndexedSeqOps.search$(this, elem, from, to, ord);
    }

    @Override
    public scala.collection.mutable.IndexedSeqOps mapInPlace(Function1 f) {
        return scala.collection.mutable.IndexedSeqOps.mapInPlace$(this, f);
    }

    @Override
    public scala.collection.mutable.IndexedSeqOps sortInPlace(Ordering ord) {
        return scala.collection.mutable.IndexedSeqOps.sortInPlace$(this, ord);
    }

    @Override
    public scala.collection.mutable.IndexedSeqOps sortInPlaceWith(Function2 lt) {
        return scala.collection.mutable.IndexedSeqOps.sortInPlaceWith$(this, lt);
    }

    @Override
    public scala.collection.mutable.IndexedSeqOps sortInPlaceBy(Function1 f, Ordering ord) {
        return scala.collection.mutable.IndexedSeqOps.sortInPlaceBy$(this, f, ord);
    }

    @Override
    public IndexedBuffer flatMapInPlace(Function1 f) {
        return IndexedBuffer.flatMapInPlace$(this, f);
    }

    @Override
    public IndexedBuffer filterInPlace(Function1 p) {
        return IndexedBuffer.filterInPlace$(this, p);
    }

    @Override
    public IndexedBuffer patchInPlace(int from, IterableOnce patch, int replaced) {
        return IndexedBuffer.patchInPlace$(this, from, patch, replaced);
    }

    @Override
    public Tuple2<ArrayDeque<A>, ArrayDeque<A>> partition(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public Tuple2<ArrayDeque<A>, ArrayDeque<A>> span(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.span$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<ArrayDeque<A1>, ArrayDeque<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<ArrayDeque<A1>, ArrayDeque<A2>, ArrayDeque<A3>> unzip3(Function1<A, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<A, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<A, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<A, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<A, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<A, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public <A1, A2> Tuple2<ArrayDeque<A1>, ArrayDeque<A2>> partitionMap(Function1<A, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public Object takeRight(int n) {
        return StrictOptimizedIterableOps.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public Object distinctBy(Function1 f) {
        return StrictOptimizedSeqOps.distinctBy$(this, f);
    }

    @Override
    public Object prepended(Object elem) {
        return StrictOptimizedSeqOps.prepended$(this, elem);
    }

    @Override
    public Object appended(Object elem) {
        return StrictOptimizedSeqOps.appended$(this, elem);
    }

    @Override
    public Object appendedAll(IterableOnce suffix) {
        return StrictOptimizedSeqOps.appendedAll$(this, suffix);
    }

    @Override
    public Object prependedAll(IterableOnce prefix) {
        return StrictOptimizedSeqOps.prependedAll$(this, prefix);
    }

    @Override
    public Object padTo(int len, Object elem) {
        return StrictOptimizedSeqOps.padTo$(this, len, elem);
    }

    @Override
    public Object diff(Seq that) {
        return StrictOptimizedSeqOps.diff$(this, that);
    }

    @Override
    public Object intersect(Seq that) {
        return StrictOptimizedSeqOps.intersect$(this, that);
    }

    @Override
    public final Object clone() {
        return ArrayDequeOps.clone$(this);
    }

    @Override
    public final void requireBounds(int idx, int until) {
        ArrayDequeOps.requireBounds$(this, idx, until);
    }

    @Override
    public int requireBounds$default$2() {
        return ArrayDequeOps.requireBounds$default$2$(this);
    }

    @Override
    public Object copySliceToArray(int srcStart, Object dest, int destStart, int maxItems) {
        return ArrayDequeOps.copySliceToArray$(this, srcStart, dest, destStart, maxItems);
    }

    @Override
    public Object reverse() {
        return ArrayDequeOps.reverse$(this);
    }

    @Override
    public Object slice(int from, int until) {
        return ArrayDequeOps.slice$(this, from, until);
    }

    @Override
    public Iterator<ArrayDeque<A>> sliding(int size, int step) {
        return ArrayDequeOps.sliding$(this, size, step);
    }

    @Override
    public Iterator<ArrayDeque<A>> grouped(int n) {
        return ArrayDequeOps.grouped$(this, n);
    }

    @Override
    public Object writeReplace() {
        return DefaultSerializable.writeReplace$(this);
    }

    @Override
    public /* synthetic */ Iterator scala$collection$mutable$ArrayDequeOps$$super$sliding(int size, int step) {
        return IndexedSeqOps.sliding$(this, size, step);
    }

    @Override
    public Object[] array() {
        return this.array;
    }

    public void array_$eq(Object[] x$1) {
        this.array = x$1;
    }

    public int start() {
        return this.start;
    }

    public void start_$eq(int x$1) {
        this.start = x$1;
    }

    public int end() {
        return this.end;
    }

    public void end_$eq(int x$1) {
        this.end = x$1;
    }

    private void reset(Object[] array, int start, int end) {
        if ((array.length & array.length - 1) != 0) {
            throw Scala3RunTime$.MODULE$.assertFailed("Array.length must be power of 2");
        }
        this.requireBounds(start, array.length);
        this.requireBounds(end, array.length);
        this.array_$eq(array);
        this.start_$eq(start);
        this.end_$eq(end);
    }

    public ArrayDeque(int initialSize) {
        this(ArrayDeque$.MODULE$.alloc(initialSize), 0, 0);
    }

    @Override
    public int knownSize() {
        return IndexedSeqOps.knownSize$(this);
    }

    @Override
    public <S extends Stepper<?>> S stepper(StepperShape<A, S> shape) {
        return (S)IndexedSeqOps.stepper$(this, shape);
    }

    @Override
    public A apply(int idx) {
        this.requireBounds(idx, this.requireBounds$default$2());
        return this._get(idx);
    }

    @Override
    public void update(int idx, A elem) {
        this.requireBounds(idx, this.requireBounds$default$2());
        this._set(idx, elem);
    }

    @Override
    public ArrayDeque<A> addOne(A elem) {
        this.ensureSize(this.length() + 1);
        return this.appendAssumingCapacity(elem);
    }

    @Override
    public ArrayDeque<A> prepend(A elem) {
        this.ensureSize(this.length() + 1);
        return this.prependAssumingCapacity(elem);
    }

    public ArrayDeque<A> appendAssumingCapacity(A elem) {
        this.array()[this.end()] = elem;
        this.end_$eq(this.end_$plus(1));
        return this;
    }

    public ArrayDeque<A> prependAssumingCapacity(A elem) {
        this.start_$eq(this.start_$minus(1));
        this.array()[this.start()] = elem;
        return this;
    }

    @Override
    public ArrayDeque<A> prependAll(IterableOnce<A> elems) {
        block5: {
            Iterator it = elems.iterator();
            if (!it.nonEmpty()) break block5;
            int n = this.length();
            int n2 = elems.knownSize();
            int srcLength = n2;
            if (srcLength < 0) {
                this.prependAll((IterableOnce)it.to(IterableFactory$.MODULE$.toFactory(IndexedSeq$.MODULE$)));
            } else {
                int srcLength2 = n2;
                if (this.mustGrow(srcLength2 + n)) {
                    int finalLength = srcLength2 + n;
                    Object[] array2 = ArrayDeque$.MODULE$.alloc(finalLength);
                    int copied = it.copyToArray(array2);
                    this.copySliceToArray(0, array2, srcLength2, n);
                    this.reset(array2, 0, finalLength);
                } else {
                    int srcLength3 = n2;
                    for (int i = 0; i < srcLength3; ++i) {
                        this._set(i - srcLength3, it.next());
                    }
                    this.start_$eq(this.start_$minus(srcLength3));
                }
            }
        }
        return this;
    }

    @Override
    public ArrayDeque<A> addAll(IterableOnce<A> elems) {
        int n = elems.knownSize();
        int srcLength = n;
        if (srcLength > 0) {
            this.ensureSize(srcLength + this.length());
            elems.iterator().foreach((Function1<Object, ArrayDeque> & Serializable)elem -> this.appendAssumingCapacity(elem));
        } else {
            elems.iterator().foreach((Function1<Object, ArrayDeque> & Serializable)elem -> (ArrayDeque)this.$plus$eq(elem));
        }
        return this;
    }

    @Override
    public void insert(int idx, A elem) {
        int i;
        this.requireBounds(idx, this.length() + 1);
        int n = this.length();
        if (idx == 0) {
            this.prepend((Object)elem);
            return;
        }
        if (idx == n) {
            this.addOne((Object)elem);
            return;
        }
        int finalLength = n + 1;
        if (this.mustGrow(finalLength)) {
            Object[] array2 = ArrayDeque$.MODULE$.alloc(finalLength);
            this.copySliceToArray(0, array2, 0, idx);
            array2[idx] = elem;
            this.copySliceToArray(idx, array2, idx + 1, n);
            this.reset(array2, 0, finalLength);
            return;
        }
        if (n <= idx * 2) {
            int i2;
            for (i2 = n - 1; i2 >= idx; --i2) {
                this._set(i2 + 1, this._get(i2));
            }
            this.end_$eq(this.end_$plus(1));
            this._set(++i2, elem);
            return;
        }
        for (i = 0; i < idx; ++i) {
            this._set(i - 1, this._get(i));
        }
        this.start_$eq(this.start_$minus(1));
        this._set(i, elem);
    }

    @Override
    public void insertAll(int idx, IterableOnce<A> elems) {
        Tuple2<Iterator<A>, Integer> tuple2;
        this.requireBounds(idx, this.length() + 1);
        int n = this.length();
        if (idx == 0) {
            this.prependAll((IterableOnce)elems);
            return;
        }
        if (idx == n) {
            this.addAll((IterableOnce)elems);
            return;
        }
        int _srcLength = elems.knownSize();
        if (_srcLength >= 0) {
            tuple2 = Tuple2$.MODULE$.apply(elems.iterator(), BoxesRunTime.boxToInteger(_srcLength));
        } else {
            IndexedSeq indexed = (IndexedSeq)IndexedSeq$.MODULE$.from((IterableOnce)elems);
            tuple2 = Tuple2$.MODULE$.apply(indexed.iterator(), BoxesRunTime.boxToInteger(indexed.size()));
        }
        Tuple2<Iterator<A>, Integer> tuple22 = tuple2;
        Iterator<A> it = tuple22._1();
        int srcLength = BoxesRunTime.unboxToInt(tuple22._2());
        if (it.nonEmpty()) {
            int i;
            int finalLength = srcLength + n;
            if (this.mustGrow(finalLength)) {
                Object[] array2 = ArrayDeque$.MODULE$.alloc(finalLength);
                this.copySliceToArray(0, array2, 0, idx);
                int copied = it.copyToArray(array2, idx);
                this.copySliceToArray(idx, array2, idx + srcLength, n);
                this.reset(array2, 0, finalLength);
                return;
            }
            if (2 * idx >= n) {
                int i2;
                for (i2 = n - 1; i2 >= idx; --i2) {
                    this._set(i2 + srcLength, this._get(i2));
                }
                this.end_$eq(this.end_$plus(srcLength));
                while (it.hasNext()) {
                    this._set(++i2, it.next());
                }
                return;
            }
            for (i = 0; i < idx; ++i) {
                this._set(i - srcLength, this._get(i));
            }
            this.start_$eq(this.start_$minus(srcLength));
            while (it.hasNext()) {
                this._set(i, it.next());
                ++i;
            }
            return;
        }
    }

    @Override
    public void remove(int idx, int count) {
        if (count > 0) {
            int i;
            this.requireBounds(idx, this.requireBounds$default$2());
            int n = this.length();
            int removals = Math.min(n - idx, count);
            int finalLength = n - removals;
            int suffixStart = idx + removals;
            if (this.shouldShrink(finalLength)) {
                Object[] array2 = ArrayDeque$.MODULE$.alloc(finalLength);
                this.copySliceToArray(0, array2, 0, idx);
                this.copySliceToArray(suffixStart, array2, idx, n);
                this.reset(array2, 0, finalLength);
                return;
            }
            if (2 * idx <= finalLength) {
                int i2;
                for (i2 = suffixStart - 1; i2 >= removals; --i2) {
                    this._set(i2, this._get(i2 - removals));
                }
                while (i2 >= 0) {
                    this._set(i2, null);
                    --i2;
                }
                this.start_$eq(this.start_$plus(removals));
                return;
            }
            for (i = idx; i < finalLength; ++i) {
                this._set(i, this._get(i + removals));
            }
            while (i < n) {
                this._set(i, null);
                ++i;
            }
            this.end_$eq(this.end_$minus(removals));
            return;
        }
        Predef$.MODULE$.require(count == 0, () -> ArrayDeque.remove$$anonfun$1(count));
    }

    @Override
    public A remove(int idx) {
        A elem = this.apply(idx);
        this.remove(idx, 1);
        return elem;
    }

    @Override
    public ArrayDeque<A> subtractOne(A elem) {
        int idx = this.indexOf(elem);
        if (idx >= 0) {
            this.remove(idx, 1);
        }
        return this;
    }

    public Option<A> removeHeadOption(boolean resizeInternalRepr) {
        if (this.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(this.removeHeadAssumingNonEmpty(resizeInternalRepr));
    }

    public boolean removeHeadOption$default$1() {
        return false;
    }

    public A removeHead(boolean resizeInternalRepr) {
        if (this.isEmpty()) {
            throw new NoSuchElementException("empty collection");
        }
        return this.removeHeadAssumingNonEmpty(resizeInternalRepr);
    }

    public boolean removeHead$default$1() {
        return false;
    }

    private A removeHeadAssumingNonEmpty(boolean resizeInternalRepr) {
        Object elem = this.array()[this.start()];
        this.array()[this.start()] = null;
        this.start_$eq(this.start_$plus(1));
        if (resizeInternalRepr) {
            this.resize(this.length());
        }
        return (A)elem;
    }

    private boolean removeHeadAssumingNonEmpty$default$1() {
        return false;
    }

    public Option<A> removeLastOption(boolean resizeInternalRepr) {
        if (this.isEmpty()) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(this.removeLastAssumingNonEmpty(resizeInternalRepr));
    }

    public boolean removeLastOption$default$1() {
        return false;
    }

    public A removeLast(boolean resizeInternalRepr) {
        if (this.isEmpty()) {
            throw new NoSuchElementException("empty collection");
        }
        return this.removeLastAssumingNonEmpty(resizeInternalRepr);
    }

    public boolean removeLast$default$1() {
        return false;
    }

    private A removeLastAssumingNonEmpty(boolean resizeInternalRepr) {
        this.end_$eq(this.end_$minus(1));
        Object elem = this.array()[this.end()];
        this.array()[this.end()] = null;
        if (resizeInternalRepr) {
            this.resize(this.length());
        }
        return (A)elem;
    }

    private boolean removeLastAssumingNonEmpty$default$1() {
        return false;
    }

    public scala.collection.immutable.Seq<A> removeAll() {
        Builder elems = Seq$.MODULE$.newBuilder();
        elems.sizeHint(this.length());
        while (this.nonEmpty()) {
            elems.$plus$eq(this.removeHeadAssumingNonEmpty(this.removeHeadAssumingNonEmpty$default$1()));
        }
        return (scala.collection.immutable.Seq)elems.result();
    }

    public scala.collection.immutable.Seq<A> removeAllReverse() {
        Builder elems = Seq$.MODULE$.newBuilder();
        elems.sizeHint(this.length());
        while (this.nonEmpty()) {
            elems.$plus$eq(this.removeLastAssumingNonEmpty(this.removeLastAssumingNonEmpty$default$1()));
        }
        return (scala.collection.immutable.Seq)elems.result();
    }

    public scala.collection.immutable.Seq<A> removeHeadWhile(Function1<A, Object> f) {
        Builder elems = Seq$.MODULE$.newBuilder();
        while (this.headOption().exists(f)) {
            elems.$plus$eq(this.removeHeadAssumingNonEmpty(this.removeHeadAssumingNonEmpty$default$1()));
        }
        return (scala.collection.immutable.Seq)elems.result();
    }

    public scala.collection.immutable.Seq<A> removeLastWhile(Function1<A, Object> f) {
        Builder elems = Seq$.MODULE$.newBuilder();
        while (this.lastOption().exists(f)) {
            elems.$plus$eq(this.removeLastAssumingNonEmpty(this.removeLastAssumingNonEmpty$default$1()));
        }
        return (scala.collection.immutable.Seq)elems.result();
    }

    public Option<A> removeFirst(Function1<A, Object> p, int from) {
        int i = this.indexWhere(p, from);
        if (i < 0) {
            return None$.MODULE$;
        }
        return Some$.MODULE$.apply(this.remove(i));
    }

    public int removeFirst$default$2() {
        return 0;
    }

    public scala.collection.immutable.Seq<A> removeAll(Function1<A, Object> p) {
        int i;
        Builder res = Seq$.MODULE$.newBuilder();
        int j = 0;
        for (i = 0; i < this.size(); ++i) {
            Object object;
            if (BoxesRunTime.unboxToBoolean(p.apply(this.apply(i)))) {
                object = res.$plus$eq(this.apply(i));
                continue;
            }
            if (i != j) {
                this.update(j, this.apply(i));
            }
            ++j;
            object = BoxedUnit.UNIT;
        }
        if (i != j) {
            this.takeInPlace(j);
        }
        return (scala.collection.immutable.Seq)res.result();
    }

    public void ensureSize(int hint) {
        if (hint > this.length() && this.mustGrow(hint)) {
            this.resize(hint);
            return;
        }
    }

    @Override
    public int length() {
        return this.end_$minus(this.start());
    }

    @Override
    public boolean isEmpty() {
        return this.start() == this.end();
    }

    @Override
    public ArrayDeque<A> klone() {
        return new ArrayDeque<A>((Object[])this.array().clone(), this.start(), this.end());
    }

    @Override
    public SeqFactory<ArrayDeque> iterableFactory() {
        return ArrayDeque$.MODULE$;
    }

    @Override
    public void clear() {
        while (this.nonEmpty()) {
            this.removeHeadAssumingNonEmpty(this.removeHeadAssumingNonEmpty$default$1());
        }
    }

    public ArrayDeque clearAndShrink(int size) {
        this.reset(ArrayDeque$.MODULE$.alloc(size), 0, 0);
        return this;
    }

    public int clearAndShrink$default$1() {
        return 16;
    }

    @Override
    public ArrayDeque<A> ofArray(Object[] array, int end) {
        return new ArrayDeque<A>(array, 0, end);
    }

    @Override
    public <B> int copyToArray(Object dest, int destStart, int len) {
        int copied = IterableOnce$.MODULE$.elemsToCopyToArray(this.length(), ScalaRunTime$.MODULE$.array_length(dest), destStart, len);
        if (copied > 0) {
            this.copySliceToArray(0, dest, destStart, len);
        }
        return copied;
    }

    @Override
    public <B> Object toArray(ClassTag<B> evidence$1) {
        return this.copySliceToArray(0, Arrays$.MODULE$.newGenericArray(this.length(), evidence$1), 0, this.length());
    }

    public void trimToSize() {
        this.resize(this.length());
    }

    @Override
    public int start_$plus(int idx) {
        return this.start() + idx & this.array().length - 1;
    }

    private int start_$minus(int idx) {
        return this.start() - idx & this.array().length - 1;
    }

    private int end_$plus(int idx) {
        return this.end() + idx & this.array().length - 1;
    }

    private int end_$minus(int idx) {
        return this.end() - idx & this.array().length - 1;
    }

    private boolean mustGrow(int len) {
        return len >= this.array().length;
    }

    private boolean shouldShrink(int len) {
        return this.array().length > 128 && this.array().length - len - (len >> 1) > len;
    }

    private boolean canShrink(int len) {
        return this.array().length > 16 && this.array().length - len > len;
    }

    private A _get(int idx) {
        return (A)this.array()[this.start_$plus(idx)];
    }

    private void _set(int idx, A elem) {
        this.array()[this.start_$plus((int)idx)] = elem;
    }

    private void resize(int len) {
        if (this.mustGrow(len) || this.canShrink(len)) {
            int n = this.length();
            Object[] array2 = (Object[])this.copySliceToArray(0, ArrayDeque$.MODULE$.alloc(len), 0, n);
            this.reset(array2, 0, n);
            return;
        }
    }

    @Override
    public String stringPrefix() {
        return "ArrayDeque";
    }

    private static final Object remove$$anonfun$1(int count$1) {
        return "removing negative number of elements: " + count$1;
    }
}

