/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.mutable;

import java.io.Serializable;
import java.util.Arrays;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Function4;
import scala.Function5;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.IndexedSeqOps;
import scala.collection.IndexedSeqView;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Searching;
import scala.collection.Seq;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StrictOptimizedSeqOps;
import scala.collection.convert.impl.ObjectArrayStepper;
import scala.collection.generic.CommonErrors$;
import scala.collection.generic.DefaultSerializable;
import scala.collection.mutable.AbstractBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayBufferView;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.GrowableBuilder;
import scala.collection.mutable.IndexedBuffer;
import scala.collection.mutable.IndexedSeq;
import scala.collection.mutable.MutationTracker;
import scala.math.Integral;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import scala.util.Sorting$;

public class ArrayBuffer<A>
extends AbstractBuffer<A>
implements IndexedBuffer<A>,
StrictOptimizedSeqOps<A, ArrayBuffer, ArrayBuffer<A>>,
DefaultSerializable {
    private static final long serialVersionUID = -1582447879429021880L;
    private transient int mutationCount;
    private Object[] array;
    private int size0;

    public static int DefaultInitialSize() {
        return ArrayBuffer$.MODULE$.DefaultInitialSize();
    }

    public static /* synthetic */ Object fill(int n, Function0 function0) {
        return ArrayBuffer$.MODULE$.fill(n, function0);
    }

    public static SeqOps fill(int n, Function0 function0) {
        return ArrayBuffer$.MODULE$.fill(n, function0);
    }

    public static Object fill(int n, int n2, Function0 function0) {
        return ArrayBuffer$.MODULE$.fill(n, n2, function0);
    }

    public static Object fill(int n, int n2, int n3, Function0 function0) {
        return ArrayBuffer$.MODULE$.fill(n, n2, n3, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, Function0 function0) {
        return ArrayBuffer$.MODULE$.fill(n, n2, n3, n4, function0);
    }

    public static Object fill(int n, int n2, int n3, int n4, int n5, Function0 function0) {
        return ArrayBuffer$.MODULE$.fill(n, n2, n3, n4, n5, function0);
    }

    public static <B> ArrayBuffer<B> from(IterableOnce<B> iterableOnce) {
        return ArrayBuffer$.MODULE$.from((IterableOnce)iterableOnce);
    }

    public static Object iterate(Object object, int n, Function1 function1) {
        return ArrayBuffer$.MODULE$.iterate(object, n, function1);
    }

    public static <A> Builder<A, ArrayBuffer<A>> newBuilder() {
        return ArrayBuffer$.MODULE$.newBuilder();
    }

    public static Object range(Object object, Object object2, Integral integral) {
        return ArrayBuffer$.MODULE$.range(object, object2, integral);
    }

    public static Object range(Object object, Object object2, Object object3, Integral integral) {
        return ArrayBuffer$.MODULE$.range(object, object2, object3, integral);
    }

    public static int resizeUp(int n, int n2) {
        return ArrayBuffer$.MODULE$.resizeUp(n, n2);
    }

    public static /* synthetic */ Object tabulate(int n, Function1 function1) {
        return ArrayBuffer$.MODULE$.tabulate(n, function1);
    }

    public static SeqOps tabulate(int n, Function1 function1) {
        return ArrayBuffer$.MODULE$.tabulate(n, function1);
    }

    public static Object tabulate(int n, int n2, Function2 function2) {
        return ArrayBuffer$.MODULE$.tabulate(n, n2, function2);
    }

    public static Object tabulate(int n, int n2, int n3, Function3 function3) {
        return ArrayBuffer$.MODULE$.tabulate(n, n2, n3, function3);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, Function4 function4) {
        return ArrayBuffer$.MODULE$.tabulate(n, n2, n3, n4, function4);
    }

    public static Object tabulate(int n, int n2, int n3, int n4, int n5, Function5 function5) {
        return ArrayBuffer$.MODULE$.tabulate(n, n2, n3, n4, n5, function5);
    }

    public static SeqOps unapplySeq(SeqOps seqOps) {
        return ArrayBuffer$.MODULE$.unapplySeq(seqOps);
    }

    public static Object unfold(Object object, Function1 function1) {
        return ArrayBuffer$.MODULE$.unfold(object, function1);
    }

    public ArrayBuffer(Object[] initialElements, int initialSize) {
        IndexedSeqOps.$init$(this);
        scala.collection.IndexedSeq.$init$(this);
        scala.collection.mutable.IndexedSeqOps.$init$(this);
        IndexedSeq.$init$(this);
        IndexedBuffer.$init$(this);
        StrictOptimizedIterableOps.$init$(this);
        StrictOptimizedSeqOps.$init$(this);
        DefaultSerializable.$init$(this);
        this.mutationCount = 0;
        this.array = initialElements;
        this.size0 = initialSize;
    }

    @Override
    public Iterator<A> iterator() {
        return IndexedSeqOps.iterator$(this);
    }

    @Override
    public Iterator<A> reverseIterator() {
        return IndexedSeqOps.reverseIterator$(this);
    }

    @Override
    public IndexedSeqView<A> view(int from, int until) {
        return IndexedSeqOps.view$(this, from, until);
    }

    @Override
    public Iterable<A> reversed() {
        return IndexedSeqOps.reversed$(this);
    }

    @Override
    public Object take(int n) {
        return IndexedSeqOps.take$(this, n);
    }

    @Override
    public Object drop(int n) {
        return IndexedSeqOps.drop$(this, n);
    }

    @Override
    public Object reverse() {
        return IndexedSeqOps.reverse$(this);
    }

    @Override
    public Object slice(int from, int until) {
        return IndexedSeqOps.slice$(this, from, until);
    }

    @Override
    public A head() {
        return (A)IndexedSeqOps.head$(this);
    }

    @Override
    public Option<A> headOption() {
        return IndexedSeqOps.headOption$(this);
    }

    @Override
    public A last() {
        return (A)IndexedSeqOps.last$(this);
    }

    @Override
    public final int lengthCompare(int len) {
        return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, len);
    }

    @Override
    public final int lengthCompare(Iterable<?> that) {
        return IndexedSeqOps.lengthCompare$((IndexedSeqOps)this, that);
    }

    @Override
    public <B> Searching.SearchResult search(B elem, Ordering<B> ord) {
        return IndexedSeqOps.search$(this, elem, ord);
    }

    @Override
    public <B> Searching.SearchResult search(B elem, int from, int to, Ordering<B> ord) {
        return IndexedSeqOps.search$(this, elem, from, to, ord);
    }

    @Override
    public scala.collection.mutable.IndexedSeqOps mapInPlace(Function1 f) {
        return scala.collection.mutable.IndexedSeqOps.mapInPlace$(this, f);
    }

    @Override
    public scala.collection.mutable.IndexedSeqOps sortInPlaceWith(Function2 lt) {
        return scala.collection.mutable.IndexedSeqOps.sortInPlaceWith$(this, lt);
    }

    @Override
    public scala.collection.mutable.IndexedSeqOps sortInPlaceBy(Function1 f, Ordering ord) {
        return scala.collection.mutable.IndexedSeqOps.sortInPlaceBy$(this, f, ord);
    }

    @Override
    public IndexedBuffer flatMapInPlace(Function1 f) {
        return IndexedBuffer.flatMapInPlace$(this, f);
    }

    @Override
    public IndexedBuffer filterInPlace(Function1 p) {
        return IndexedBuffer.filterInPlace$(this, p);
    }

    @Override
    public IndexedBuffer patchInPlace(int from, IterableOnce patch, int replaced) {
        return IndexedBuffer.patchInPlace$(this, from, patch, replaced);
    }

    @Override
    public Tuple2<ArrayBuffer<A>, ArrayBuffer<A>> partition(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.partition$(this, p);
    }

    @Override
    public Tuple2<ArrayBuffer<A>, ArrayBuffer<A>> span(Function1<A, Object> p) {
        return StrictOptimizedIterableOps.span$(this, p);
    }

    @Override
    public <A1, A2> Tuple2<ArrayBuffer<A1>, ArrayBuffer<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<ArrayBuffer<A1>, ArrayBuffer<A2>, ArrayBuffer<A3>> unzip3(Function1<A, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<A, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<A, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<A, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<A, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<A, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filter(Function1 pred) {
        return StrictOptimizedIterableOps.filter$(this, pred);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public <A1, A2> Tuple2<ArrayBuffer<A1>, ArrayBuffer<A2>> partitionMap(Function1<A, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public Object takeRight(int n) {
        return StrictOptimizedIterableOps.takeRight$(this, n);
    }

    @Override
    public Object dropRight(int n) {
        return StrictOptimizedIterableOps.dropRight$(this, n);
    }

    @Override
    public Object distinctBy(Function1 f) {
        return StrictOptimizedSeqOps.distinctBy$(this, f);
    }

    @Override
    public Object prepended(Object elem) {
        return StrictOptimizedSeqOps.prepended$(this, elem);
    }

    @Override
    public Object appended(Object elem) {
        return StrictOptimizedSeqOps.appended$(this, elem);
    }

    @Override
    public Object appendedAll(IterableOnce suffix) {
        return StrictOptimizedSeqOps.appendedAll$(this, suffix);
    }

    @Override
    public Object prependedAll(IterableOnce prefix) {
        return StrictOptimizedSeqOps.prependedAll$(this, prefix);
    }

    @Override
    public Object padTo(int len, Object elem) {
        return StrictOptimizedSeqOps.padTo$(this, len, elem);
    }

    @Override
    public Object diff(Seq that) {
        return StrictOptimizedSeqOps.diff$(this, that);
    }

    @Override
    public Object intersect(Seq that) {
        return StrictOptimizedSeqOps.intersect$(this, that);
    }

    @Override
    public Object writeReplace() {
        return DefaultSerializable.writeReplace$(this);
    }

    public ArrayBuffer() {
        this(new Object[16], 0);
    }

    public ArrayBuffer(int initialSize) {
        this(new Object[RichInt$.MODULE$.max$extension(Predef$.MODULE$.intWrapper(initialSize), 1)], 0);
    }

    public Object[] array() {
        return this.array;
    }

    public void array_$eq(Object[] x$1) {
        this.array = x$1;
    }

    public int size0() {
        return this.size0;
    }

    public void size0_$eq(int x$1) {
        this.size0 = x$1;
    }

    @Override
    public <S extends Stepper<?>> S stepper(StepperShape<A, S> shape) {
        return shape.parUnbox(new ObjectArrayStepper<Object>(this.array(), 0, this.length()));
    }

    @Override
    public int knownSize() {
        return IndexedSeqOps.knownSize$(this);
    }

    public void ensureSize(int n) {
        this.array_$eq(ArrayBuffer$.MODULE$.scala$collection$mutable$ArrayBuffer$$$ensureSize(this.array(), this.size0(), n));
    }

    public void sizeHint(int size) {
        if (size > this.length() && size >= 1) {
            this.ensureSize(size);
            return;
        }
    }

    private void reduceToSize(int n) {
        ++this.mutationCount;
        Arrays.fill(this.array(), n, this.size0(), null);
        this.size0_$eq(n);
    }

    public void trimToSize() {
        this.resize(this.length());
    }

    private void resize(int requiredLength) {
        this.array_$eq(ArrayBuffer$.MODULE$.scala$collection$mutable$ArrayBuffer$$$downsize(this.array(), requiredLength));
    }

    private void checkWithinBounds(int lo, int hi) {
        if (lo < 0) {
            throw CommonErrors$.MODULE$.indexOutOfBounds(lo, this.size0() - 1);
        }
        if (hi > this.size0()) {
            throw CommonErrors$.MODULE$.indexOutOfBounds(hi - 1, this.size0() - 1);
        }
    }

    @Override
    public A apply(int n) {
        this.checkWithinBounds(n, n + 1);
        return (A)this.array()[n];
    }

    @Override
    public void update(int index, A elem) {
        this.checkWithinBounds(index, index + 1);
        ++this.mutationCount;
        this.array()[index] = elem;
    }

    @Override
    public int length() {
        return this.size0();
    }

    @Override
    public ArrayBufferView<A> view() {
        return new ArrayBufferView(this, (Function0<Object>)(Function0<Integer> & Serializable)() -> this.mutationCount);
    }

    @Override
    public SeqFactory<ArrayBuffer> iterableFactory() {
        return ArrayBuffer$.MODULE$;
    }

    @Override
    public void clear() {
        this.reduceToSize(0);
    }

    public ArrayBuffer clearAndShrink(int size) {
        this.clear();
        this.resize(size);
        return this;
    }

    public int clearAndShrink$default$1() {
        return 16;
    }

    @Override
    public ArrayBuffer<A> addOne(A elem) {
        ++this.mutationCount;
        int newSize = this.size0() + 1;
        if (this.array().length <= newSize - 1) {
            this.ensureSize(newSize);
        }
        this.size0_$eq(newSize);
        this.array()[newSize - 1] = elem;
        return this;
    }

    @Override
    public ArrayBuffer<A> addAll(IterableOnce<A> elems) {
        IterableOnce<A> iterableOnce = elems;
        if (iterableOnce instanceof ArrayBuffer) {
            ArrayBuffer arrayBuffer = (ArrayBuffer)iterableOnce;
            ArrayBuffer elems2 = arrayBuffer;
            int elemsLength = elems2.size0();
            if (elemsLength > 0) {
                ++this.mutationCount;
                this.ensureSize(this.size0() + elemsLength);
                Array$.MODULE$.copy(elems2.array(), 0, this.array(), this.length(), elemsLength);
                this.size0_$eq(this.length() + elemsLength);
                v0 = BoxedUnit.UNIT;
            } else {
                v0 = BoxedUnit.UNIT;
            }
        } else {
            v0 = Growable.addAll$(this, elems);
        }
        return this;
    }

    @Override
    public void insert(int index, A elem) {
        this.checkWithinBounds(index, index);
        ++this.mutationCount;
        this.ensureSize(this.size0() + 1);
        Array$.MODULE$.copy(this.array(), index, this.array(), index + 1, this.size0() - index);
        this.size0_$eq(this.size0() + 1);
        this.update(index, elem);
    }

    @Override
    public ArrayBuffer<A> prepend(A elem) {
        this.insert(0, elem);
        return this;
    }

    @Override
    public void insertAll(int index, IterableOnce<A> elems) {
        this.checkWithinBounds(index, index);
        IterableOnce<A> iterableOnce = elems;
        if (iterableOnce instanceof Iterable) {
            Iterable iterable = (Iterable)iterableOnce;
            Iterable elems2 = iterable;
            int elemsLength = elems2.size();
            if (elemsLength > 0) {
                ++this.mutationCount;
                this.ensureSize(this.size0() + elemsLength);
                int len = this.size0();
                Array$.MODULE$.copy(this.array(), index, this.array(), index + elemsLength, len - index);
                int actual = IterableOnce$.MODULE$.copyElemsToArray(elems2, this.array(), index, elemsLength);
                if (actual != elemsLength) {
                    throw new IllegalStateException("Copied " + actual + " of " + elemsLength);
                }
                this.size0_$eq(len + elemsLength);
                return;
            }
            return;
        }
        this.insertAll(index, (IterableOnce<A>)ArrayBuffer$.MODULE$.from((IterableOnce)elems));
    }

    @Override
    public A remove(int index) {
        this.checkWithinBounds(index, index + 1);
        A res = this.apply(index);
        Array$.MODULE$.copy(this.array(), index + 1, this.array(), index, this.size0() - (index + 1));
        this.reduceToSize(this.size0() - 1);
        return res;
    }

    @Override
    public void remove(int index, int count) {
        if (count > 0) {
            this.checkWithinBounds(index, index + count);
            Array$.MODULE$.copy(this.array(), index + count, this.array(), index, this.size0() - (index + count));
            this.reduceToSize(this.size0() - count);
            return;
        }
        if (count < 0) {
            throw new IllegalArgumentException("removing negative number of elements: " + count);
        }
    }

    public ArrayBuffer result() {
        return this;
    }

    public <NewTo> Builder<A, NewTo> mapResult(Function1<ArrayBuffer<A>, NewTo> f) {
        return new GrowableBuilder(this).mapResult(f);
    }

    @Override
    public String stringPrefix() {
        return "ArrayBuffer";
    }

    @Override
    public <B> int copyToArray(Object xs, int start, int len) {
        int copied = IterableOnce$.MODULE$.elemsToCopyToArray(this.length(), ScalaRunTime$.MODULE$.array_length(xs), start, len);
        if (copied > 0) {
            Array$.MODULE$.copy(this.array(), 0, xs, start, copied);
        }
        return copied;
    }

    public <B> ArrayBuffer<A> sortInPlace(Ordering<B> ord) {
        if (this.length() > 1) {
            ++this.mutationCount;
            Sorting$.MODULE$.stableSort((Object)this.array(), 0, this.length(), ord);
        }
        return this;
    }

    private <B> B foldl(int start, int end, B z, Function2<B, A, B> op) {
        while (start != end) {
            int n = start + 1;
            B b = op.apply(z, this.array()[start]);
            start = n;
            z = b;
        }
        return z;
    }

    private <B> B foldr(int start, int end, B z, Function2<A, B, B> op) {
        while (start != end) {
            int n = end - 1;
            B b = op.apply(this.array()[end - 1], z);
            end = n;
            z = b;
        }
        return z;
    }

    @Override
    public <B> B foldLeft(B z, Function2<B, A, B> op) {
        return this.foldl(0, this.length(), z, op);
    }

    @Override
    public <B> B foldRight(B z, Function2<A, B, B> op) {
        return this.foldr(0, this.length(), z, op);
    }

    @Override
    public <B> B reduceLeft(Function2<B, A, B> op) {
        if (this.length() > 0) {
            return (B)this.foldl(1, this.length(), this.array()[0], op);
        }
        return (B)IterableOnceOps.reduceLeft$(this, op);
    }

    @Override
    public <B> B reduceRight(Function2<A, B, B> op) {
        if (this.length() > 0) {
            return (B)this.foldr(0, this.length() - 1, this.array()[this.length() - 1], op);
        }
        return (B)IterableOnceOps.reduceRight$(this, op);
    }

    @Override
    public Iterator<ArrayBuffer<A>> sliding(int size, int step) {
        return new MutationTracker.CheckedIterator<ArrayBuffer<A>>(IndexedSeqOps.sliding$(this, size, step), (Function0<Object>)((Function0<Integer> & Serializable)this::sliding$$anonfun$1));
    }

    private final int sliding$$anonfun$1() {
        return this.mutationCount;
    }
}

