/*
 * Decompiled with CFR 0.152.
 */
package scala.collection.immutable;

import java.io.Serializable;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.collection.Factory;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Set;
import scala.collection.SortedOps;
import scala.collection.SortedSetFactoryDefaults;
import scala.collection.SortedSetOps;
import scala.collection.Stepper;
import scala.collection.StepperShape;
import scala.collection.StepperShape$;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.convert.impl.AnyBinaryTreeStepper$;
import scala.collection.convert.impl.DoubleBinaryTreeStepper$;
import scala.collection.convert.impl.IntBinaryTreeStepper;
import scala.collection.convert.impl.IntBinaryTreeStepper$;
import scala.collection.convert.impl.LongBinaryTreeStepper$;
import scala.collection.generic.DefaultSerializable;
import scala.collection.immutable.AbstractSet;
import scala.collection.immutable.RedBlackTree;
import scala.collection.immutable.RedBlackTree$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.SetOps;
import scala.collection.immutable.SortedSet;
import scala.collection.immutable.StrictOptimizedSetOps;
import scala.collection.immutable.StrictOptimizedSortedSetOps;
import scala.collection.immutable.TreeMap;
import scala.collection.immutable.TreeSet$;
import scala.collection.immutable.TreeSet$sub$2$;
import scala.collection.mutable.Builder;
import scala.collection.mutable.Growable;
import scala.collection.mutable.ReusableBuilder;
import scala.math.Ordering;
import scala.math.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.util.Either;

public final class TreeSet<A>
extends AbstractSet<A>
implements SortedSet<A>,
StrictOptimizedSortedSetOps<A, TreeSet, TreeSet<A>>,
DefaultSerializable {
    private final RedBlackTree.Tree<A, Object> tree;
    private final Ordering<A> ordering;

    public static Factory evidenceIterableFactory(Object object) {
        return TreeSet$.MODULE$.evidenceIterableFactory(object);
    }

    public static Object fill(int n, Function0 function0, Object object) {
        return TreeSet$.MODULE$.fill(n, function0, object);
    }

    public static Object iterate(Object object, int n, Function1 function1, Object object2) {
        return TreeSet$.MODULE$.iterate(object, n, function1, object2);
    }

    public static <A> ReusableBuilder<A, TreeSet<A>> newBuilder(Ordering<A> ordering) {
        return TreeSet$.MODULE$.newBuilder(ordering);
    }

    public static Object tabulate(int n, Function1 function1, Object object) {
        return TreeSet$.MODULE$.tabulate(n, function1, object);
    }

    public static Object unfold(Object object, Function1 function1, Object object2) {
        return TreeSet$.MODULE$.unfold(object, function1, object2);
    }

    public TreeSet(RedBlackTree.Tree<A, Object> tree, Ordering<A> ordering) {
        this.tree = tree;
        this.ordering = ordering;
        SortedOps.$init$(this);
        SortedSetOps.$init$(this);
        SortedSetFactoryDefaults.$init$(this);
        scala.collection.SortedSet.$init$(this);
        SortedSet.$init$(this);
        StrictOptimizedIterableOps.$init$(this);
        scala.collection.StrictOptimizedSetOps.$init$(this);
        scala.collection.StrictOptimizedSortedSetOps.$init$(this);
        StrictOptimizedSetOps.$init$(this);
        DefaultSerializable.$init$(this);
        if (ordering == null) {
            throw new NullPointerException("ordering must not be null");
        }
    }

    @Override
    public int compare(A k0, A k1) {
        return SortedOps.compare$(this, k0, k1);
    }

    @Override
    public final Object from(Object from) {
        return SortedOps.from$(this, from);
    }

    @Override
    public Object rangeFrom(Object from) {
        return SortedOps.rangeFrom$(this, from);
    }

    @Override
    public final Object until(Object until) {
        return SortedOps.until$(this, until);
    }

    @Override
    public Object rangeUntil(Object until) {
        return SortedOps.rangeUntil$(this, until);
    }

    @Override
    public final Object to(Object to) {
        return SortedOps.to$(this, to);
    }

    @Override
    public Iterator<A> keysIteratorFrom(A start) {
        return SortedSetOps.keysIteratorFrom$(this, start);
    }

    @Override
    public A firstKey() {
        return (A)SortedSetOps.firstKey$(this);
    }

    @Override
    public A lastKey() {
        return (A)SortedSetOps.lastKey$(this);
    }

    @Override
    public SortedSetOps rangeTo(Object to) {
        return SortedSetOps.rangeTo$(this, to);
    }

    @Override
    public scala.collection.SortedSet fromSpecific(IterableOnce coll) {
        return SortedSetFactoryDefaults.fromSpecific$(this, coll);
    }

    @Override
    public Builder<A, TreeSet<A>> newSpecificBuilder() {
        return SortedSetFactoryDefaults.newSpecificBuilder$(this);
    }

    @Override
    public scala.collection.SortedSet empty() {
        return SortedSetFactoryDefaults.empty$(this);
    }

    @Override
    public SortedSetOps.WithFilter<A, scala.collection.immutable.Set, TreeSet> withFilter(Function1<A, Object> p) {
        return SortedSetFactoryDefaults.withFilter$(this, p);
    }

    @Override
    public String stringPrefix() {
        return scala.collection.SortedSet.stringPrefix$(this);
    }

    @Override
    public scala.collection.immutable.Set<A> unsorted() {
        return SortedSet.unsorted$(this);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.immutable.Set<A1>, scala.collection.immutable.Set<A2>> unzip(Function1<A, Tuple2<A1, A2>> asPair) {
        return StrictOptimizedIterableOps.unzip$(this, asPair);
    }

    @Override
    public <A1, A2, A3> Tuple3<scala.collection.immutable.Set<A1>, scala.collection.immutable.Set<A2>, scala.collection.immutable.Set<A3>> unzip3(Function1<A, Tuple3<A1, A2, A3>> asTriple) {
        return StrictOptimizedIterableOps.unzip3$(this, asTriple);
    }

    @Override
    public Object map(Function1 f) {
        return StrictOptimizedIterableOps.map$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedMap(Builder<B, C2> b, Function1<A, B> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedMap$(this, b, f);
    }

    @Override
    public Object flatMap(Function1 f) {
        return StrictOptimizedIterableOps.flatMap$(this, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatMap(Builder<B, C2> b, Function1<A, IterableOnce<B>> f) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatMap$(this, b, f);
    }

    @Override
    public final <B, C2> C2 strictOptimizedConcat(IterableOnce<B> that, Builder<B, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedConcat$(this, that, b);
    }

    @Override
    public Object collect(PartialFunction pf) {
        return StrictOptimizedIterableOps.collect$(this, pf);
    }

    @Override
    public final <B, C2> C2 strictOptimizedCollect(Builder<B, C2> b, PartialFunction<A, B> pf) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedCollect$(this, b, pf);
    }

    @Override
    public Object flatten(Function1 toIterableOnce) {
        return StrictOptimizedIterableOps.flatten$(this, toIterableOnce);
    }

    @Override
    public final <B, C2> C2 strictOptimizedFlatten(Builder<B, C2> b, Function1<A, IterableOnce<B>> toIterableOnce) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedFlatten$(this, b, toIterableOnce);
    }

    @Override
    public Object zip(IterableOnce that) {
        return StrictOptimizedIterableOps.zip$(this, that);
    }

    @Override
    public final <B, C2> C2 strictOptimizedZip(IterableOnce<B> that, Builder<Tuple2<A, B>, C2> b) {
        return (C2)StrictOptimizedIterableOps.strictOptimizedZip$(this, that, b);
    }

    @Override
    public Object zipWithIndex() {
        return StrictOptimizedIterableOps.zipWithIndex$(this);
    }

    @Override
    public Object scanLeft(Object z, Function2 op) {
        return StrictOptimizedIterableOps.scanLeft$(this, z, op);
    }

    @Override
    public Object filterNot(Function1 pred) {
        return StrictOptimizedIterableOps.filterNot$(this, pred);
    }

    @Override
    public Object filterImpl(Function1 pred, boolean isFlipped) {
        return StrictOptimizedIterableOps.filterImpl$(this, pred, isFlipped);
    }

    @Override
    public <A1, A2> Tuple2<scala.collection.immutable.Set<A1>, scala.collection.immutable.Set<A2>> partitionMap(Function1<A, Either<A1, A2>> f) {
        return StrictOptimizedIterableOps.partitionMap$(this, f);
    }

    @Override
    public Object tapEach(Function1 f) {
        return StrictOptimizedIterableOps.tapEach$(this, f);
    }

    @Override
    public scala.collection.SortedSet map(Function1 f, Ordering ev) {
        return scala.collection.StrictOptimizedSortedSetOps.map$(this, f, ev);
    }

    @Override
    public scala.collection.SortedSet flatMap(Function1 f, Ordering ev) {
        return scala.collection.StrictOptimizedSortedSetOps.flatMap$(this, f, ev);
    }

    @Override
    public scala.collection.SortedSet zip(IterableOnce that, Ordering ev) {
        return scala.collection.StrictOptimizedSortedSetOps.zip$(this, that, ev);
    }

    @Override
    public scala.collection.SortedSet collect(PartialFunction pf, Ordering ev) {
        return scala.collection.StrictOptimizedSortedSetOps.collect$(this, pf, ev);
    }

    @Override
    public Object writeReplace() {
        return DefaultSerializable.writeReplace$(this);
    }

    @Override
    public /* synthetic */ Object scala$collection$SortedSetOps$$super$min(Ordering ord) {
        return IterableOnceOps.min$(this, ord);
    }

    @Override
    public /* synthetic */ Object scala$collection$SortedSetOps$$super$max(Ordering ord) {
        return IterableOnceOps.max$(this, ord);
    }

    @Override
    public /* synthetic */ boolean scala$collection$SortedSet$$super$equals(Object that) {
        return Set.equals$(this, that);
    }

    public RedBlackTree.Tree<A, Object> tree() {
        return this.tree;
    }

    @Override
    public Ordering<A> ordering() {
        return this.ordering;
    }

    public TreeSet(Ordering<A> ordering) {
        this(null, ordering);
    }

    public TreeSet$ sortedIterableFactory() {
        return TreeSet$.MODULE$;
    }

    private TreeSet<A> newSetOrSelf(RedBlackTree.Tree<A, Object> t) {
        if (t == this.tree()) {
            return this;
        }
        return new TreeSet<A>(t, this.ordering());
    }

    @Override
    public int size() {
        return RedBlackTree$.MODULE$.count(this.tree());
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public A head() {
        return RedBlackTree$.MODULE$.smallest(this.tree()).key();
    }

    @Override
    public A last() {
        return RedBlackTree$.MODULE$.greatest(this.tree()).key();
    }

    @Override
    public TreeSet<A> tail() {
        return new TreeSet<A>(RedBlackTree$.MODULE$.tail(this.tree()), this.ordering());
    }

    @Override
    public TreeSet<A> init() {
        return new TreeSet<A>(RedBlackTree$.MODULE$.init(this.tree()), this.ordering());
    }

    @Override
    public <A1> A min(Ordering<A1> ord) {
        if (ord == this.ordering() && this.nonEmpty()) {
            return this.head();
        }
        return (A)SortedSetOps.min$(this, ord);
    }

    @Override
    public <A1> A max(Ordering<A1> ord) {
        if (ord == this.ordering() && this.nonEmpty()) {
            return this.last();
        }
        return (A)SortedSetOps.max$(this, ord);
    }

    @Override
    public TreeSet<A> drop(int n) {
        if (n <= 0) {
            return this;
        }
        if (n >= this.size()) {
            return (TreeSet)this.empty();
        }
        return new TreeSet<A>(RedBlackTree$.MODULE$.drop(this.tree(), n, this.ordering()), this.ordering());
    }

    @Override
    public TreeSet<A> take(int n) {
        if (n <= 0) {
            return (TreeSet)this.empty();
        }
        if (n >= this.size()) {
            return this;
        }
        return new TreeSet<A>(RedBlackTree$.MODULE$.take(this.tree(), n, this.ordering()), this.ordering());
    }

    @Override
    public TreeSet<A> slice(int from, int until) {
        if (until <= from) {
            return (TreeSet)this.empty();
        }
        if (from <= 0) {
            return this.take(until);
        }
        if (until >= this.size()) {
            return this.drop(from);
        }
        return new TreeSet<A>(RedBlackTree$.MODULE$.slice(this.tree(), from, until, this.ordering()), this.ordering());
    }

    @Override
    public TreeSet<A> dropRight(int n) {
        return this.take(this.size() - package$.MODULE$.max(n, 0));
    }

    @Override
    public TreeSet<A> takeRight(int n) {
        return this.drop(this.size() - package$.MODULE$.max(n, 0));
    }

    private int countWhile(Function1<A, Object> p) {
        int result = 0;
        Iterator<A> it = this.iterator();
        while (it.hasNext() && BoxesRunTime.unboxToBoolean(p.apply(it.next()))) {
            ++result;
        }
        return result;
    }

    @Override
    public TreeSet<A> dropWhile(Function1<A, Object> p) {
        return this.drop(this.countWhile(p));
    }

    @Override
    public TreeSet<A> takeWhile(Function1<A, Object> p) {
        return this.take(this.countWhile(p));
    }

    @Override
    public Tuple2<TreeSet<A>, TreeSet<A>> span(Function1<A, Object> p) {
        return this.splitAt(this.countWhile(p));
    }

    @Override
    public <U> void foreach(Function1<A, U> f) {
        RedBlackTree$.MODULE$.foreachKey(this.tree(), f);
    }

    @Override
    public Option<A> minAfter(A key) {
        RedBlackTree.Tree<A, Object> v = RedBlackTree$.MODULE$.minAfter(this.tree(), key, this.ordering());
        if (v == null) {
            return Option$.MODULE$.empty();
        }
        return Some$.MODULE$.apply(v.key());
    }

    @Override
    public Option<A> maxBefore(A key) {
        RedBlackTree.Tree<A, Object> v = RedBlackTree$.MODULE$.maxBefore(this.tree(), key, this.ordering());
        if (v == null) {
            return Option$.MODULE$.empty();
        }
        return Some$.MODULE$.apply(v.key());
    }

    @Override
    public Iterator<A> iterator() {
        return RedBlackTree$.MODULE$.keysIterator(this.tree(), RedBlackTree$.MODULE$.keysIterator$default$2(), this.ordering());
    }

    @Override
    public Iterator<A> iteratorFrom(A start) {
        return RedBlackTree$.MODULE$.keysIterator(this.tree(), Some$.MODULE$.apply(start), this.ordering());
    }

    @Override
    public <S extends Stepper<?>> S stepper(StepperShape<A, S> shape) {
        int n = shape.shape();
        IntBinaryTreeStepper<RedBlackTree.Tree<A, Object>> s = StepperShape$.MODULE$.IntShape() == n ? IntBinaryTreeStepper$.MODULE$.from(this.size(), this.tree(), (Function1<RedBlackTree.Tree, RedBlackTree.Tree> & Serializable)_$1 -> _$1.left(), (Function1<RedBlackTree.Tree, RedBlackTree.Tree> & Serializable)_$2 -> _$2.right(), (Function1<RedBlackTree.Tree, Integer> & Serializable)_$3 -> BoxesRunTime.unboxToInt(_$3.key())) : (StepperShape$.MODULE$.LongShape() == n ? LongBinaryTreeStepper$.MODULE$.from(this.size(), this.tree(), (Function1<RedBlackTree.Tree, RedBlackTree.Tree> & Serializable)_$4 -> _$4.left(), (Function1<RedBlackTree.Tree, RedBlackTree.Tree> & Serializable)_$5 -> _$5.right(), (Function1<RedBlackTree.Tree, Long> & Serializable)_$6 -> BoxesRunTime.unboxToLong(_$6.key())) : (StepperShape$.MODULE$.DoubleShape() == n ? DoubleBinaryTreeStepper$.MODULE$.from(this.size(), this.tree(), (Function1<RedBlackTree.Tree, RedBlackTree.Tree> & Serializable)_$7 -> _$7.left(), (Function1<RedBlackTree.Tree, RedBlackTree.Tree> & Serializable)_$8 -> _$8.right(), (Function1<RedBlackTree.Tree, Double> & Serializable)_$9 -> BoxesRunTime.unboxToDouble(_$9.key())) : shape.parUnbox(AnyBinaryTreeStepper$.MODULE$.from(this.size(), this.tree(), (Function1<RedBlackTree.Tree, RedBlackTree.Tree> & Serializable)_$10 -> _$10.left(), (Function1<RedBlackTree.Tree, RedBlackTree.Tree> & Serializable)_$11 -> _$11.right(), (Function1<RedBlackTree.Tree, Object> & Serializable)_$12 -> _$12.key()))));
        return (S)s;
    }

    @Override
    public boolean contains(A elem) {
        return RedBlackTree$.MODULE$.contains(this.tree(), elem, this.ordering());
    }

    @Override
    public TreeSet<A> range(A from, A until) {
        return this.newSetOrSelf(RedBlackTree$.MODULE$.range(this.tree(), from, until, this.ordering()));
    }

    @Override
    public TreeSet<A> rangeImpl(Option<A> from, Option<A> until) {
        return this.newSetOrSelf(RedBlackTree$.MODULE$.rangeImpl(this.tree(), from, until, this.ordering()));
    }

    @Override
    public TreeSet<A> incl(A elem) {
        return this.newSetOrSelf(RedBlackTree$.MODULE$.update(this.tree(), elem, null, false, this.ordering()));
    }

    @Override
    public TreeSet<A> excl(A elem) {
        return this.newSetOrSelf(RedBlackTree$.MODULE$.delete(this.tree(), elem, this.ordering()));
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public TreeSet<A> concat(IterableOnce<A> that) {
        var3_2 = that;
        if (!(var3_2 instanceof TreeSet)) ** GOTO lbl-1000
        ts = var4_3 = (TreeSet)var3_2;
        v0 = this.ordering();
        var6_5 = ts.ordering();
        if (!(v0 != null ? v0.equals(var6_5) == false : var6_5 != null)) {
            v1 = RedBlackTree$.MODULE$.union(this.tree(), ts.tree(), this.ordering());
        } else lbl-1000:
        // 2 sources

        {
            it = that.iterator();
            t = this.tree();
            while (it.hasNext()) {
                t = RedBlackTree$.MODULE$.update(t, it.next(), null, false, this.ordering());
            }
            v1 = t;
        }
        t = v1;
        return this.newSetOrSelf(t);
    }

    @Override
    public TreeSet<A> removedAll(IterableOnce<A> that) {
        IterableOnce<A> iterableOnce = that;
        if (iterableOnce instanceof TreeSet) {
            TreeSet treeSet;
            TreeSet ts = treeSet = (TreeSet)iterableOnce;
            Ordering<A> ordering = this.ordering();
            Ordering<A> ordering2 = ts.ordering();
            if (!(ordering != null ? !ordering.equals(ordering2) : ordering2 != null)) {
                return this.newSetOrSelf(RedBlackTree$.MODULE$.difference(this.tree(), ts.tree(), this.ordering()));
            }
        }
        LazyRef lazyRef = new LazyRef();
        that.iterator().foreach(this.sub$1(lazyRef));
        return this.newSetOrSelf(this.sub$1(lazyRef).currentTree());
    }

    @Override
    public TreeSet<A> intersect(Set<A> that) {
        Set<A> set = that;
        if (set instanceof TreeSet) {
            TreeSet treeSet;
            TreeSet ts = treeSet = (TreeSet)set;
            Ordering<A> ordering = this.ordering();
            Ordering<A> ordering2 = ts.ordering();
            if (!(ordering != null ? !ordering.equals(ordering2) : ordering2 != null)) {
                return this.newSetOrSelf(RedBlackTree$.MODULE$.intersect(this.tree(), ts.tree(), this.ordering()));
            }
        }
        return (TreeSet)scala.collection.SetOps.intersect$(this, that);
    }

    @Override
    public TreeSet<A> diff(Set<A> that) {
        Set<A> set = that;
        if (set instanceof TreeSet) {
            TreeSet treeSet;
            TreeSet ts = treeSet = (TreeSet)set;
            Ordering<A> ordering = this.ordering();
            Ordering<A> ordering2 = ts.ordering();
            if (!(ordering != null ? !ordering.equals(ordering2) : ordering2 != null)) {
                return this.newSetOrSelf(RedBlackTree$.MODULE$.difference(this.tree(), ts.tree(), this.ordering()));
            }
        }
        return (TreeSet)SetOps.diff$(this, that);
    }

    @Override
    public TreeSet<A> filter(Function1<A, Object> f) {
        return this.newSetOrSelf(RedBlackTree$.MODULE$.filterEntries(this.tree(), (Function2<Object, Object, Boolean> & Serializable)(k, _$13) -> BoxesRunTime.unboxToBoolean(f.apply(k))));
    }

    @Override
    public Tuple2<TreeSet<A>, TreeSet<A>> partition(Function1<A, Object> p) {
        Tuple2<RedBlackTree.Tree<A, Object>, RedBlackTree.Tree<A, Object>> tuple2;
        Tuple2<RedBlackTree.Tree<A, Object>, RedBlackTree.Tree<A, Object>> $1$;
        Tuple2<RedBlackTree.Tree<A, Object>, RedBlackTree.Tree<A, Object>> tuple22 = $1$ = (tuple2 = RedBlackTree$.MODULE$.partitionEntries(this.tree(), (Function2<Object, Object, Boolean> & Serializable)(a, _$14) -> BoxesRunTime.unboxToBoolean(p.apply(a))));
        RedBlackTree.Tree<A, Object> l = tuple22._1();
        RedBlackTree.Tree<A, Object> r = tuple22._2();
        return Tuple2$.MODULE$.apply(this.newSetOrSelf(l), this.newSetOrSelf(r));
    }

    @Override
    public boolean equals(Object obj) {
        Object object = obj;
        if (object instanceof TreeSet) {
            TreeSet treeSet;
            TreeSet that = treeSet = (TreeSet)object;
            Ordering<A> ordering = this.ordering();
            Ordering<A> ordering2 = that.ordering();
            if (!(ordering != null ? !ordering.equals(ordering2) : ordering2 != null)) {
                return RedBlackTree$.MODULE$.keysEqual(this.tree(), that.tree(), this.ordering());
            }
        }
        return scala.collection.SortedSet.equals$(this, obj);
    }

    @Override
    public String className() {
        return "TreeSet";
    }

    private final TreeSet$sub$2$ sub$lzyINIT1$1(LazyRef sub$lzy1$1) {
        TreeSet$sub$2$ treeSet$sub$2$;
        LazyRef lazyRef = sub$lzy1$1;
        synchronized (lazyRef) {
            treeSet$sub$2$ = (TreeSet$sub$2$)(sub$lzy1$1.initialized() ? sub$lzy1$1.value() : sub$lzy1$1.initialize(new TreeSet$sub$2$(this)));
        }
        return treeSet$sub$2$;
    }

    private final TreeSet$sub$2$ sub$1(LazyRef sub$lzy1$2) {
        return (TreeSet$sub$2$)(sub$lzy1$2.initialized() ? sub$lzy1$2.value() : this.sub$lzyINIT1$1(sub$lzy1$2));
    }

    public static class TreeSetBuilder<A>
    extends RedBlackTree.SetHelper<A>
    implements ReusableBuilder<A, TreeSet<A>> {
        private RedBlackTree.Tree<A, Object> tree;

        public TreeSetBuilder(Ordering<A> ordering) {
            super(ordering);
            Growable.$init$(this);
            Builder.$init$(this);
            this.tree = null;
        }

        @Override
        public final Growable $plus$eq(Object elem) {
            return Growable.$plus$eq$(this, elem);
        }

        @Override
        public final Growable $plus$eq(Object elem1, Object elem2, Seq elems) {
            return Growable.$plus$eq$(this, elem1, elem2, elems);
        }

        @Override
        public final Growable $plus$plus$eq(IterableOnce elems) {
            return Growable.$plus$plus$eq$(this, elems);
        }

        @Override
        public int knownSize() {
            return Growable.knownSize$(this);
        }

        @Override
        public void sizeHint(int size) {
            Builder.sizeHint$(this, size);
        }

        @Override
        public final void sizeHint(IterableOnce<?> coll, int delta) {
            Builder.sizeHint$(this, coll, delta);
        }

        @Override
        public int sizeHint$default$2() {
            return Builder.sizeHint$default$2$(this);
        }

        @Override
        public final void sizeHintBounded(int size, Iterable<?> boundingColl) {
            Builder.sizeHintBounded$(this, size, boundingColl);
        }

        @Override
        public <NewTo> Builder<A, NewTo> mapResult(Function1<TreeSet<A>, NewTo> f) {
            return Builder.mapResult$(this, f);
        }

        private Ordering<A> ordering$accessor() {
            return super.ordering();
        }

        @Override
        public TreeSetBuilder<A> addOne(A elem) {
            this.tree = this.mutableUpd(this.tree, elem);
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public TreeSetBuilder<A> addAll(IterableOnce<A> xs) {
            Object object;
            IterableOnce<A> iterableOnce = xs;
            if (iterableOnce instanceof TreeSet) {
                TreeSet treeSet;
                TreeSet ts = treeSet = (TreeSet)iterableOnce;
                Ordering ordering = ts.ordering();
                Ordering<A> ordering2 = this.ordering$accessor();
                if (!(ordering != null ? !ordering.equals(ordering2) : ordering2 != null)) {
                    if (this.tree == null) {
                        this.tree = ts.tree();
                        object = BoxedUnit.UNIT;
                        return this;
                    }
                    this.tree = RedBlackTree$.MODULE$.union(this.beforePublish(this.tree), ts.tree(), this.ordering$accessor());
                    object = BoxedUnit.UNIT;
                    return this;
                }
            }
            if (iterableOnce instanceof TreeMap) {
                TreeMap treeMap;
                TreeMap ts = treeMap = (TreeMap)iterableOnce;
                Ordering ordering = ts.ordering();
                Ordering<A> ordering3 = this.ordering$accessor();
                if (!(ordering != null ? !ordering.equals(ordering3) : ordering3 != null)) {
                    if (this.tree == null) {
                        this.tree = ts.tree0();
                        object = BoxedUnit.UNIT;
                        return this;
                    }
                    this.tree = RedBlackTree$.MODULE$.union(this.beforePublish(this.tree), ts.tree0(), this.ordering$accessor());
                    object = BoxedUnit.UNIT;
                    return this;
                }
            }
            object = Growable.addAll$(this, xs);
            return this;
        }

        @Override
        public void clear() {
            this.tree = null;
        }

        @Override
        public TreeSet<A> result() {
            return new TreeSet<A>(this.beforePublish(this.tree), this.ordering$accessor());
        }
    }
}

