/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.patch;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.BinaryEncoder;
import com.intellij.openapi.diff.impl.patch.BinaryFilePatch;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.vcs.changes.patch.BlobIndexUtil;
import com.intellij.openapi.vcs.changes.patch.GitPatchWriter;
import com.intellij.util.ArrayUtilRt;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class BinaryPatchWriter {
    private static final Logger LOG = Logger.getInstance(BinaryFilePatch.class);
    @NonNls
    private static final String GIT_BINARY_HEADER = "GIT binary patch";
    @NonNls
    private static final String LITERAL_HEADER = "literal %s";

    public static void writeBinaries(@Nullable Path basePath, @NotNull List<BinaryFilePatch> patches, @NotNull Writer writer) throws IOException {
        if (patches == null) {
            BinaryPatchWriter.$$$reportNull$$$0(0);
        }
        if (writer == null) {
            BinaryPatchWriter.$$$reportNull$$$0(1);
        }
        String lineSeparator = "\n";
        for (BinaryFilePatch filePatch : patches) {
            GitPatchWriter.writeGitHeader(writer, basePath, (FilePatch)filePatch, lineSeparator);
            byte[] afterContent = filePatch.getAfterContent();
            writer.write(GitPatchWriter.getIndexHeader(filePatch.isNewFile() ? BlobIndexUtil.NOT_COMMITTED_HASH : BinaryPatchWriter.getSha1ForContent(filePatch.getBeforeContent()), filePatch.isDeletedFile() ? BlobIndexUtil.NOT_COMMITTED_HASH : BinaryPatchWriter.getSha1ForContent(afterContent)));
            writer.write(lineSeparator);
            writer.write(GIT_BINARY_HEADER);
            writer.write(lineSeparator);
            writer.write(String.format(LITERAL_HEADER, afterContent == null ? 0 : afterContent.length));
            writer.write(lineSeparator);
            try {
                BinaryEncoder.encode(new ByteArrayInputStream(afterContent != null ? afterContent : ArrayUtilRt.EMPTY_BYTE_ARRAY), writer);
            }
            catch (BinaryEncoder.BinaryPatchException e) {
                String afterFile = basePath == null ? filePatch.getAfterName() : basePath.resolve(filePatch.getAfterName()).toString();
                LOG.error("Can't write patch for binary file: " + afterFile, (Throwable)e);
            }
            writer.write(lineSeparator);
        }
    }

    @NotNull
    private static String getSha1ForContent(byte @Nullable [] content) {
        String string = content != null ? BlobIndexUtil.getSha1(content) : BlobIndexUtil.NOT_COMMITTED_HASH;
        if (string == null) {
            BinaryPatchWriter.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patches";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/changes/patch/BinaryPatchWriter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/changes/patch/BinaryPatchWriter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSha1ForContent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "writeBinaries";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

